/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fEMW
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        internal var traced :Trace = new Trace();
        
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            addChild(traced);
            
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.75);
            graphics.drawRect  (0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        {
            _init();
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

class Trace extends Sprite
{
    protected var _r:Number;
    protected var _c:Number;
    
    internal var mPoint:Point = new Point();
    internal var mActive:Boolean = false;
    
    public function Trace()
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);

        _r = 4;
        
    }

    public function _init() :void
    {
        graphics.lineStyle(_r, _c);
    }
    
    public function addedToStage($e:Event) :void
    {
        _init();
        
        stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        graphics.clear();
        
        mActive = true;     
        
        stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        
        mPoint = new Point($e.stageX, $e.stageY);
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        graphics.moveTo(mPoint.x, mPoint.y);
        
        mPoint = new Point($e.stageX, $e.stageY);
        
        graphics.lineTo(mPoint.x, mPoint.y);
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        mActive = false;
        
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
    }
    
    public function onEnterFrame($e:Event) :void
    {size = (mActive) ? (size += (size < 10) ? 0.25 : 0) : 0; color = (mActive) ? (color += (color < 255) ? (0.5) : 0) : 0;}
    
    public function get size() :Number
    { return _r }
    
    public function get color() :Number
    { return _c }
    
    public function set size($value:Number) :void
    { _r = $value; _init(); }
    
    public function set color($value:Number) :void
    { _c = $value; _init(); }
}