/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fDdv
 */

// forked from curvedstraightline's ランダム玉ぼかし
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    
    public class FlashTest extends Sprite
    {
            public const WIDTH:int = stage.stageWidth;
            public const HEIGHT:int = stage.stageHeight;
            
            public const BALL_MAX:int = 1;
            
            public var perlin_sp:Sprite = new Sprite();
            public var perlin_bp:Bitmap;
            public var perlin_bmd:BitmapData = new BitmapData(
                WIDTH,
                HEIGHT,
                true,
                0x000000
            );
            
            public var dot_sp:Sprite = new Sprite();
            public var dot_bp:Bitmap;
            public var dot_bmd:BitmapData = new BitmapData(
                WIDTH,
                HEIGHT,
                true,
                0x000000
            );
            public var dot_sh:Shape;
            
        public function FlashTest()
        {
                dot_bp = new Bitmap();
            dot_bp.bitmapData = dot_bmd;
            dot_sp.addChild(dot_bp);
            
            perlin_bp = new Bitmap();
            perlin_bp.bitmapData = perlin_bmd;
            perlin_sp.addChild(perlin_bp);

            stage.addChild(perlin_sp);
            stage.addChild(dot_sp);
            //_sp.blendMode = BlendMode.LAYER;
            dot_sp.blendMode = BlendMode.DIFFERENCE;
            
             
            
            stage.addEventListener(Event.ENTER_FRAME,makeDot);
            stage.addEventListener(Event.ENTER_FRAME,perlinNoise);
        }
        
        private var X:int;
        private var Y:int;
        public function makeDot(event:Event):void
        {
                for(var i:int = 1;i <= BALL_MAX;++i){
                    var COLOR:Number;
                    var RED:int = randomNum(0xff);
                    var GREEN:int = randomNum(0xcc);
                    var BLUE:int = 0xff;
                    COLOR = RED << 16 | GREEN << 8 | BLUE;
                    
                    var BALL_SIZE:int = randomNum(50);
                    
                    X = randomNum(stage.stageWidth);
                    Y = randomNum(stage.stageHeight);
                    dot_sh = new Shape();
                    dot_sh.graphics.beginFill(COLOR);
                    dot_sh.graphics.drawCircle(X,Y,BALL_SIZE);
                    dot_sh.graphics.endFill();
                    dot_bmd.draw(dot_sh);
                }
                
                dot_bmd.applyFilter( 
                    dot_bmd,
                    dot_bmd.rect,
                    new Point(0, 0),
                    new BlurFilter(80, 20)
                );
                dot_bmd.scroll(0,-1);
        }
        
        public const BASE_X:int = stage.stageWidth;
        public const BASE_Y:int = stage.stageHeight / 4;
        
        public const OCTAVE_NUMBER:uint = 2;
        public var RANDOM_SEED:int = Math.floor(Math.random() * 0x00000000);
        public var CHANNEL_OPTION:int = 0;  //BitmapDataChannel.RED |BitmapDataChannel.BLUE;//7;
        public var offset_array:Array = [new Point(),new Point(), new Point()];
        public function perlinNoise(event:Event):void
        {
                perlin_bmd.perlinNoise(
                    BASE_X,
                    BASE_Y,
                    OCTAVE_NUMBER,
                    RANDOM_SEED, 
                    false, 
                    false,
                    CHANNEL_OPTION,
                    true,
                    offset_array
                );
                offset_array[0].y += 0.5;
                offset_array[1].x -= 0.7;
                offset_array[2].y -= 0.8;
        }
        
        private function randomNum(num:Number):Number
        {
                var v:Number;
                v = Math.floor(Math.random() * num);
                return v;
        }
    }
}