/**
 * Copyright __dominic ( http://wonderfl.net/user/__dominic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fCnZ
 */

package
{
   
    import flash.display.*;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;

    [SWF(width="465", height="490", backgroundColor="#FFFFFF", frameRate=60)]
    public class Polar105 extends Sprite
    {

        private var _bitmap:Bitmap;
        private var _bmpData:BitmapData;
        private var _container:Shape;
        private var _timer:int;
        private var _frame:int;
        private var _up:Boolean;
       
        public function Polar105()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
           
            _bmpData = new BitmapData( 465, 490, false, 0x0 );
            _bitmap = new Bitmap( _bmpData );
            addChild( _bitmap );

            _container = new Shape();
           
            _timer = 1;
            _up = true;
               
            addEventListener( Event.ENTER_FRAME, draw );
        }
       
        private function draw( e:Event ):void
        {
            _container.graphics.clear();
            var i:int = 0;
            for ( var angle:Number = 0; angle < 360; angle += .5, i++ )
            {
                var r:Number;
                var d:int;
                if ( i < _timer )
                {
                    _container.graphics.beginFill( 0xFFFFFF );
                    r = Math.cos( ( 5 * angle ) / 4 ) + 1 / 3;
                    d = 145;
                }
                else if ( i >= _timer )
                {
                    _container.graphics.beginFill( 0xFA0F00 );
                    r = Math.cos( ( 7 * angle ) * .5 );
                    d = 220;
                }
                var px:Number = 232 + ( r * Math.cos( angle ) * d );
                var py:Number = 232 + ( r * Math.sin( angle ) * d );
                _container.graphics.drawCircle( px, py, 2 );
            }
            _bmpData.draw( _container );
            _bmpData.applyFilter( _bmpData, _bmpData.rect, new Point(), new BlurFilter( 4, 4, 1 ) );
           
            if ( _timer == 720 || !_timer )
                _up = !_up;
            if ( _up )
                _timer++;
            else
                _timer--;
        }
       
    }
   
}
