/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fCiQ
 */





package {
    import flash.geom.Point;
    import flash.filters.BlurFilter;
    import flash.text.TextField;
    import flash.geom.Rectangle;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;

    [SWF(width = "465", height = "465", backgroundColor = "0xffffff", frameRate = "90")]

    
    public class FlashTest extends Sprite {

            private static const WIDTH:Number = 465;
            private static const HEIGHT:Number = 465;
            private static const PARTICLE_MAX:Number = 1200;  //1500;
            
            private var tf:TextField;
            private var canvas:BitmapData;
            private var fxbmd:BitmapData;
            private var particles:Array;
            private var cTrs:ColorTransform;
            private var cTrs2:ColorTransform;
            private var blur:BlurFilter;
            private var rect:Rectangle;
            private var point:Point;
            private var testCounter:Number = 0;            
            private var mx:Number;
            private var my:Number;
            
        public function FlashTest() {
            // write as3 code here..
            
            cTrs  = new ColorTransform(  1.0, 1.0, 1.0, 0.95  );  // 0.4, 0.0, 0.95, 0.95  );  //1, 1, 1, 0.95  );
            cTrs2 = new ColorTransform(  1.0, 1.0, 1.0, 0.95  );  //  0.6, 0.0, 0.95, 0.95  );  //1, 1, 1, 0.95  );
            blur  = new BlurFilter( 16,16,2 ); 
            rect  = new Rectangle( 0,0,WIDTH,HEIGHT );
            point = new Point( 0,0 );
            
            canvas = new BitmapData(WIDTH, HEIGHT);
            addChild(new Bitmap(canvas));
            fxbmd = new BitmapData(WIDTH, HEIGHT);
            addChild(new Bitmap(fxbmd));
            
            tf = new TextField();
            addChild(tf);
            
                particles = [];
            createParticle();
            
            addEventListener(Event.ENTER_FRAME, _upDate);
        }
        
        private function createParticle():void {
                var invertNum:Number = int(Math.random()*2-1+1)-1;
            for(var i:int=0; i<PARTICLE_MAX; i++){
                var p:Particle = new Particle();
                p.x  = Math.sin(i/180)*20 + WIDTH /2;  //10 + WIDTH/2;  //*130 + WIDTH/2;
                p.y  = Math.cos(i/180)*20 + HEIGHT/2;  //*10 + HEIGHT/2;  //*130 + HEIGHT/2;
                p.tx = ( Math.sin(i/180) * Math.PI );
                p.ty = ( Math.cos(i/180) * Math.PI );
                //p.tx = (Math.sin(i/180)*Math.PI+Math.random()*2-1) * Math.random();
                //p.ty = (Math.cos(i/180)*Math.PI+Math.random()*2-1) * Math.random();
                //p.c = 0xff;//0xFFFFFF;// * Math.random();  //0x0;
                particles.push(p);  
            }
        }
        
        private function _upDate(e:Event):void {
                tf.text = "particles : "+particles.length;
                canvas.lock();
                canvas.colorTransform(rect, cTrs);
                
                for(var i:int=0; i<particles.length; i++)
                {
                    particles[i].x += particles[i].tx;
                    particles[i].y += particles[i].ty;
                
                    canvas.setPixel32( particles[i].x,particles[i].y,0xFF000000 );  //0xff000000*Math.random());  //0xff000000);
                
                    if(  particles[i].x > WIDTH || particles[i].x <0 || particles[i].y > HEIGHT || particles[i].y < 0  ) 
                    {    
                        particles.splice( i,6 );
                    }
                }
                canvas.lock();
                fxbmd .lock();                
                    fxbmd.draw(canvas);
                    fxbmd.colorTransform(rect, cTrs2);
                    fxbmd.applyFilter(fxbmd, rect, point, blur);
                canvas.unlock();
                fxbmd .unlock();

                if(  particles.length < PARTICLE_MAX/3  )  //< PARTICLE_MAX/2  ) 
                {
                    createParticle();                    
                }

        }
    }
}


dynamic class Particle 
{
    public var x:Number;
    public var y:Number;
    public var tx:Number;
    public var ty:Number;
    public var g:Number;
    public var c:uint;
    public function Particle()
    {
        c = 0xFFFFFF * Math.random()
    }


}



