/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fCbT
 */

package {
    import alternativ7.engine3d.containers.DistanceSortContainer;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Geometry;
    import alternativ7.engine3d.core.Vertex;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.objects.Mesh;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    /**
     * ...
     * @author ksnmt
     */
    [SWF(backgroundColor="#0", frameRate="120")]
    public class Main extends Sprite {
        
        /*
        // /////////////////////////////////////////////////////// */
        private var camera:Camera3D;
        private var simpleObjectController:SimpleObjectController;
        private var distanceSortContainer:DistanceSortContainer;
        private var geometry:Geometry;
        
        /**
         * constructor
         */
        public function Main():void {
            this.addEventListener(Event.ADDED, init);
        }
        
        private function init(e:Event = null):void {
            this.removeEventListener(Event.ADDED, init);
            
            this.stage.scaleMode    = StageScaleMode.NO_SCALE;
            this.stage.align        = StageAlign.TOP_LEFT;
            this.stage.quality        = StageQuality.LOW;
            
            // DistanceSortContainer
            distanceSortContainer = new DistanceSortContainer();
            
            // Camera3D
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            this.addChild(camera.view);
            
            camera.view.interactive = true;
            
            // Camera controller
            simpleObjectController = new SimpleObjectController(stage, camera, 200, 3);
            simpleObjectController.setObjectPosXYZ(500, 500, 500);
            simpleObjectController.lookAtXYZ(0, 0, 0);
            
            geometry = new Geometry();
            geometry.addVertex(200  , 0      , 0    , 0    , 0    , "v0");
            geometry.addVertex(200  , 200    , 0    , 0    , 0    , "v1");
            geometry.addVertex(0    , 200    , 0    , 0    , 0    , "v2");
            geometry.addVertex(0    , 0      , 0    , 0    , 0    , "v3");
            geometry.addFaceByIds(["v0", "v1", "v2", "v3"], new FillMaterial(0xFF00FF, 1, 1, 0xFFFF00), "f0");
            
            var mesh:Mesh = new Mesh();
            mesh.takeGeometryFrom(geometry);
            
            distanceSortContainer.addChild(camera);
            distanceSortContainer.addChild(mesh);
            
            this.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        public function onEnterFrame(e:Event = null):void {
            simpleObjectController.update();
            camera.render();
        }
    }
}
