/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fBlH
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
 
    public class Main extends Sprite
    {
        private var canvas:BitmapData;
        private var colorArray:Array;
 
        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
 
        private function addedToStage(event:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
 
            canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false);
            addChild(new Bitmap(canvas));
 
            const MAX:Number = 255;    
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(MAX, 1);
            var patternSprite:Sprite = new Sprite();
            patternSprite.graphics.beginGradientFill
            (
                GradientType.LINEAR,
                [0x000080, 0x0000FF, 0x0080FF, 0xF0F040, 0x20A000, 0xE0E000, 0x808080, 0xFFFFFF],
                [1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0],
                [0, MAX * 0.325, MAX * 0.5, MAX * 0.53125, MAX * 0.5625, MAX * 0.6875, MAX * 0.875, MAX],
                matrix
            );
            patternSprite.graphics.drawRect(0, 0, MAX, MAX);
            patternSprite.graphics.endFill();
 
            var pattern:BitmapData = new BitmapData(MAX, MAX, false);
            pattern.draw(patternSprite);
 
            colorArray = [];
            for (var i:int = 0; i < MAX; i++)
            {
                colorArray[i] = pattern.getPixel(i, 0);
            }
 
            generateMap();
 
            stage.addEventListener(MouseEvent.CLICK, onMouseClick);
        }
 
        private function onMouseClick(event:MouseEvent):void 
        {
            generateMap();
        }
 
        private function generateMap():void 
        {
            canvas.perlinNoise(canvas.width / 5, canvas.height / 5, 5, Math.random() * 0xFFFFFF, true, true, 0, true);
            canvas.paletteMap(canvas, canvas.rect, new Point(), colorArray, [], [], []);
        }
    }
}