/**
 * Copyright ck1 ( http://wonderfl.net/user/ck1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fBbh
 */

/////////////////////////------------------------------Gameboard.as--------------------------/////////////////////////

package {
        
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.events.*;
    //import com.efnx.fps.fpsBox;
    import net.hires.debug.Stats;

    [SWF(backgroundColor = "#443333", frameRate = "31", quality = "HIGH", width = "800", height = "600")]
    
    public class Gameboard extends Sprite
    {
        private var fly:Fly;
        private var grashalmArr:Array;
        
        private var rows:uint = 22;
        private var cols:uint = 140;
        private var spacing_X:uint = 6;
        private var spacingY:uint = 23;
        private var offset_X:uint = 10;
        private var offset_Y:uint = 100;
        private var dist:uint = 40;
        private var distGrid_X:uint = Math.ceil( dist / spacing_X );
        private var distGrid_Y:uint = Math.ceil( dist / spacingY );

        public function Gameboard()
        {
            //var fps:fpsBox = new fpsBox(stage);
            //addChild(fps);
                    var stats:Stats = new Stats();
                   stage.addChild(stats);
            
            fly = new Fly(stage);
            fly.x = stage.stageWidth / 2;
            fly.y = stage.stageHeight / 2;
            fly.scaleX = fly.scaleY = .7;
            stage.addChild(fly);

            grashalmArr = [];
            for (var h:uint = 0; h < rows; h++)
            {
                grashalmArr.push(new Array);
                for (var i:uint = 0; i < cols; i++)
                {
                    var color:uint = ( 0x1A + (h * 0x0D) < 0xDD )? 0x1A + (h * 0x0D) : 0x1A + ((h - 10) * 0x0D);
                    var gH:Grashalm = new Grashalm(fly, 0x00 << 16 |  color << 8 | 0x00, dist, this.stage);
                    gH.x = offset_X + i * spacing_X + Math.random() * 12;
                    gH.y = offset_Y + h * spacingY + Math.random() * 12;
                    grashalmArr[h].push(gH);
                }
            }
            stage.addEventListener(Event.ENTER_FRAME, setBall);    
        }

        private function setBall(e:Event):void
        {            
            var ballArrX:int = int( Math.round( (fly.x - offset_X) / spacing_X ) );
            var ballArrY:int = int( Math.round( (fly.y +30 - offset_Y + spacingY * .85) / spacingY ) );
            for ( var yPos:int = ballArrY - distGrid_Y; yPos < ballArrY + distGrid_Y; yPos++)
            {
                for ( var xPos:int = ballArrX - distGrid_X; xPos < ballArrX + distGrid_X; xPos++)
                {
                    if ( xPos > -1 && xPos < cols && yPos > -1 && yPos < rows ) Grashalm(grashalmArr[yPos][xPos]).activate();
                }
            }
            
            var estimatedBallDepth:int = ( ballArrY * cols < stage.numChildren)? ballArrY * cols : stage.numChildren - 1;
            stage.addChildAt( fly, Math.max(0, estimatedBallDepth) );
        }
    }
}


/////////////////////////------------------------------Grashalm.as--------------------------/////////////////////////

    import flash.display.Stage;

    import flash.events.*;

    import flash.display.Sprite;

    import flash.display.Shape;

    import mx.effects.Tween;

    import com.greensock.TweenMax;

    import com.greensock.easing.*;



    class Grashalm extends Shape

    { 

        private var theStage:Stage;

        private var color:uint;

        private var dist:uint;

        private var ball:Fly;



        public var xPos:Number = 0;

        private var left:Boolean = true;

        private var active:Boolean;

        

        

        public function Grashalm(ball:Fly, color:uint, dist:uint, theStage:Stage)

        {

            this.theStage = theStage;

            this.color = color;

            this.ball = ball;

            theStage.addChild(this);

            this.dist = dist;

            draw();

        }

        

        public function activate():void

        {

            if (!active)

            {

                active = true;

                theStage.addEventListener(Event.ENTER_FRAME, ballPos);

            }

        }

        

        private function deactivate():void

        {

            active = false;

            theStage.removeEventListener(Event.ENTER_FRAME, ballPos);

            TweenMax.to(this, .5, { xPos:0, onUpdate:draw} );

        }

        

        public function ballPos(e:Event):void

        {

            var xDist:Number = ball.x - this.x;

            var yDist:Number = ball.y - (this.y - 10);



            if ( Math.sqrt(yDist * yDist + xDist * xDist) < dist)

            {

                if ( (xDist < 0 && xPos < 0) || (xDist > 0 && xPos > 0) ) tweenBack(-xPos);

                else if (xDist < 0) tweenBack((dist + xDist)*.5);

                else if (xDist > 0) tweenBack((-dist + xDist)*.5);

            }

            else if (xPos != 0) deactivate();

        }



        private function tweenBack(newX:Number):void

        {

            theStage.removeEventListener(Event.ENTER_FRAME, ballPos);

            TweenMax.to(this, .5, { xPos:newX, onComplete:function():void { theStage.addEventListener(Event.ENTER_FRAME, ballPos); }, onUpdate:draw} );

        }                      



        private function draw():void

        {

            this.graphics.clear();

            //this.graphics.beginFill(0x222211, .8);

            //this.graphics.drawRect(-4,-2, 8, 4);

            this.graphics.beginFill(this.color);

            this.graphics.moveTo(-4, 0);

            this.graphics.curveTo(-4, -10, xPos - 3, -20);

            this.graphics.curveTo(xPos*1.5 - 3 , -30, xPos*1.3 - 2, -40);

            this.graphics.curveTo(xPos*1.1 - 1, -50, xPos*1.05, -60);

            this.graphics.curveTo(xPos*1.1 + 1, -50, xPos*1.3 + 2, -40);

            this.graphics.curveTo(xPos*1.5 + 3, -30, xPos + 3, -20);

            this.graphics.curveTo(4, -10, 4, 0);

            this.graphics.endFill();

        }



    }




/////////////////////////------------------------------Fly.as--------------------------/////////////////////////

    import flash.display.Shape;

    import flash.display.Sprite;

    import flash.events.Event;

    import flash.events.MouseEvent;

    import flash.filters.BlurFilter;

    import flash.filters.DropShadowFilter;

    import flash.geom.Matrix;

    import flash.geom.Point;

    import flash.utils.*;

    import flash.display.GradientType;



    class Fly extends Sprite

    {
        private var _stage:Stage;

        private var _body:Sprite;

        private var _eye:Sprite;

        private var _antenna:Sprite;

        private var _wingR:Sprite;

        private var _wingL:Sprite;

        private var _flap:Number = 0;

        

        public function Fly(stage:Stage)
        { 

            _stage = stage;
            _body = new Sprite();

            var mtrx:Matrix = new Matrix();

            mtrx.createGradientBox(80, 60, -45);

            _body.graphics.beginGradientFill(GradientType.LINEAR, [0x220011, 0x706660], [ 1, 1], [ 150, 255], mtrx );

            _body.graphics.drawEllipse( -40, -30, 80, 60);

            _body.graphics.endFill();

            this.addChild(_body);


            var eyeMask:Sprite = drawShape(0x995555, 80, 60);

            this.addChild(eyeMask);

            

            _eye = drawShape(0xFFFFFF, 20);

            _eye.addChild( drawShape(0x000000, 6) );

            _eye.mask = eyeMask;

            this.addChild(_eye);

            

            _antenna = drawShape(0x000000, 3, 30);

            var antennaEnd:Sprite = drawShape(0x000000, 5);

            antennaEnd.y = - _antenna.height / 2;

            _antenna.addChild( antennaEnd );

            this.addChild(_antenna);

            

            

            _wingR = new Sprite();

            with (_wingR.graphics)

            {

                beginFill(0x666688, .8);

                drawEllipse( 10, 0, -20, -40);

                endFill();

            }

            _wingR.filters = [new BlurFilter()];

            this.addChild(_wingR);



            _wingL = new Sprite();

            with (_wingL.graphics)

            {

                beginFill(0x666688, .8);

                drawEllipse( 10, 0, -20, -40);

                endFill();

            }

            _wingL.filters = [new BlurFilter()];

            this.addChild(_wingL);

            

            var shadow:Sprite = new Sprite();
            shadow.graphics.beginFill(0x000000, .7);
            shadow.graphics.drawEllipse(-35, -15, 70, 30);
            shadow.graphics.endFill();

            shadow.filters = [new BlurFilter(15, 15)];

            shadow.y = 70;

            this.addChild(shadow);


            _stage.addEventListener(Event.ENTER_FRAME, moveFly);

        }

                

        private function drawShape(color:uint, width:Number, height:Number = NaN):Sprite

        {

            if (!height) height = width;

            var s:Sprite = new Sprite();

            with (s.graphics)

            {

                beginFill(color);

                drawEllipse( -width / 2, -height / 2, width, height);

                endFill();

            }

            return s;            

        }

        

        private function moveFly(e:Event):void

        {

            var difX:Number = stage.mouseX - this.x;

            var difY:Number = stage.mouseY - this.y;

            var radius:Number = Math.sqrt(difX * difX + difY * difY);

            var cosAlpha:Number = Math.acos( (difX / radius) );

            var sinAlpha:Number = Math.asin( (difY / radius) );

            var rotation:Number = (sinAlpha > 0)? cosAlpha : -cosAlpha;

                

            if (radius > 15)

            {

                _eye.x = Math.cos( rotation ) * _body.width / 1.9;

                _eye.y = Math.sin( rotation) * _body.height / 3.5 - 5;

                _eye.visible = (_eye.y < -5)? false : true;

                _eye.scaleX = 1 - Math.pow( Math.abs(_eye.x / 43), 3);

                

                _wingR.x = Math.cos( rotation + 1.5 ) * _body.width / 2;

                _wingR.y = Math.sin( rotation + 1.5 ) * _body.height / 8 - 5;

                _wingR.scaleX = 1 - Math.pow( Math.abs(_wingR.x / 42), 3);

                _wingR.rotation = -45 + ( Math.abs(rotation) * (180 / Math.PI)) / 2;
                if (_wingR.y >  - 5)

                    this.addChildAt(_wingR, this.numChildren);

                else

                    this.addChildAt(_wingR, 0);



                _wingL.x = Math.cos( rotation - 1.5 ) * _body.width / 2;

                _wingL.y = Math.sin( rotation - 1.5 ) * _body.height / 8 - 5;

                _wingL.scaleX = 1 - Math.pow( Math.abs(_wingL.x / 42), 3);

                _wingL.rotation = -45 + ( Math.abs(rotation) * (180 / Math.PI)) / 2;

                if (_wingL.y >  - 5)

                    this.addChildAt(_wingL, this.numChildren);

                else

                    this.addChildAt(_wingL, 0);

                

                _antenna.x = Math.cos( rotation ) * _body.width / 2.5;

                _antenna.y = Math.sin( rotation ) * _body.height / 8 - 15 - _antenna.height / 2;

                if (_antenna.y >  - 15 - _antenna.height / 2)

                    this.addChildAt(_antenna, this.numChildren);

                else

                    this.addChildAt(_antenna, 0);

                    

                var destination:Point = new Point(difX, difY);

                destination.normalize(4);

                this.x += (Math.sqrt(difX*difX) > 50)? destination.x : (difX) / 20;

                this.y += (Math.sqrt(difY * difY) > 50)? destination.y : (difY) / 20;

            }

            

            _flap++;

            var flap:int = (_flap % 2 == 0)? -4 : 4;

            _wingL.rotation += flap; 

            _wingR.rotation += flap;

        }

        

    }

