/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fBWE
 */

// forked from aobyrne's forked from: forked from: Tiling
// forked from whirlpower's forked from: Tiling
// forked from quqjp's Tiling
package 
{
    /*
    * BitmapをやめてShapeにしてみた。
    * 構造理解のため、そぎ落とせるところはそぎ落としている。
    *
    * ※ 止まりません。
    */
    /**
     * http://wonderfl.net/c/7LZE
     */

    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.ColorTransform;
    import flash.text.TextField;
    import frocessing.color.ColorRGB;
    
    public class TilingLine extends Sprite
    {
        private var mapLogic:MapLogic;
        public static var textField:TextField;
        private var csprite:Sprite;
        private var lsprite:Sprite;
        private var currentSprite:Line;
        
        public function TilingLine():void
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            setDebug();
            csprite = new Sprite;
            addChild(csprite);
            lsprite = new Sprite;
            addChild(lsprite);
            
            mapLogic = new MapLogic( 45, 45, 5, 10,false);
            //addEventListener( Event.ENTER_FRAME, render );
            //Wonderfl.capture_delay( 120 );
            theMethod();
        }
        
        private function setDebug():void 
        {
            textField = new TextField();
            textField.width = 400;
            textField.height = 670;
            textField.border = true;
            textField.x = 465;
            addChild(textField);
        }
        
        
        private function theMethod():void 
        {
            csprite.visible = false;
            while (Tile(csprite.addChild( mapLogic.create() )).y < 480) 
            {
                
                
            }
            Tile.period = Tile.counter;
            Tile.counter = 0;
            Tile.linePeriod = Tile.lineCounter;
            Tile.lineCounter = 0;
            mapLogic.reset();
            mapLogic.hasPeriodBeenSet = true;
            while (csprite.numChildren)
            {
                csprite.removeChildAt(csprite.numChildren-1)
            }
            csprite.visible = true;
            addEventListener( Event.ENTER_FRAME, render );
        }
        
        
        private function cTrace(msg:String):void 
        {
            traceAt(msg);
        }
        
        private function render( e:Event ):void
        {
            var tile:Tile = Tile( mapLogic.create() );
            if (tile.y > 480)
            {
                removeEventListener(Event.ENTER_FRAME, render );
                
            }
            else
            {
                if (true && tile.x<2) 
                {
                    setCurrentSprite(tile);
                }
                currentSprite.addChild(tile);
                tile.y = tile.y - currentSprite.y;
                
            }
        }
        
        private function setCurrentSprite(tile:Tile):void 
        {
            cTrace( "tile : " + tile.x+', ' + tile.y );
            cTrace( "tile : ------------------------------------------>" );
            currentSprite = new Line;
            currentSprite.colorRGB.value = 0xffffff * Math.random();
            lsprite.graphics.lineStyle(3, currentSprite.colorRGB.value);
            lsprite.graphics.moveTo(tile.x, tile.y);
            lsprite.graphics.lineTo(tile.x + 465, tile.y);
            addChild(currentSprite);
            currentSprite.y = tile.y;
            overOut(currentSprite,true);
            currentSprite.addEventListener(MouseEvent.CLICK, currentSpriteClickHandler);
            swapChildren(currentSprite,lsprite);
        }
        
        private function overOut(line:Line, isAdding:Boolean):void 
        {
            if (isAdding) 
            {
                
                line.addEventListener(MouseEvent.MOUSE_OVER, currentSpriteMouseOverHandler);
                line.addEventListener(MouseEvent.MOUSE_OUT, currentSpriteMouseOutHandler);
            }
            else
            {
                line.removeEventListener(MouseEvent.MOUSE_OVER, currentSpriteMouseOverHandler);
                line.removeEventListener(MouseEvent.MOUSE_OUT, currentSpriteMouseOutHandler);
            }
        }
        
        private function currentSpriteClickHandler(e:MouseEvent):void
        {
            
            graphics.beginFill(0xffffff*Math.random());
            graphics.drawRect(0,0,10,10);
            var line:Line = e.currentTarget as Line;
            if (line.hasBeenClicked) 
            {
                overOut(line,true);
                currentSpriteMouseOutHandler(e);
            }
            else
            {
                overOut(line,false);
                var colorRGB:NormalizedRGB = line.colorRGB;
                Sprite(e.currentTarget).transform.colorTransform = new ColorTransform(colorRGB.rr, colorRGB.gg, colorRGB.bb, 1);
            }
            line.hasBeenClicked = !line.hasBeenClicked
       }

        
        private function currentSpriteMouseOutHandler(e:MouseEvent):void 
        {
            var c:NormalizedRGB = (e.currentTarget as Line).colorRGB;
            Sprite(e.currentTarget).transform.colorTransform = new ColorTransform(1, 1, 1, 1);
        }
        
        private function currentSpriteMouseOverHandler(e:MouseEvent):void 
        {
            var line:Line = e.currentTarget as Line;
            var colorRGB:NormalizedRGB = line.colorRGB;
            Sprite(e.currentTarget).transform.colorTransform = new ColorTransform(colorRGB.rr, colorRGB.gg, colorRGB.bb, 1);
        }
        
        public static function traceAt(msg:String):void
        {
            textField.appendText(msg + '\n');
            textField.scrollV = textField.maxScrollV;
        }
        
    }
}

import flash.display.*;
import flash.events.MouseEvent;
import flash.text.TextField;
import frocessing.color.ColorHSV;
import frocessing.color.ColorRGB;
    
internal class MapLogic
{
    private var _map            :Array = [];
    
    private var gridW        :int;
    private var igridW        :int;
    
    private var gridH        :int;
    private var igridH        :int;
    
    private var tileMax        :int;
    private var itileMax        :int;
    
    private var tileScale    :int = 10;
    private var itileScale    :int = 10;
    
    private var _isDisplaying:Boolean;
    public  var emptyPos        :int = 0;
    public var hasPeriodBeenSet:Boolean;
    
    private var values:Array;
    private var count:uint;
    
    public function MapLogic( gridW:int, gridH:int, tileMax:int, tileScale:int ,isDisplaying:Boolean = true):void
    {
        _isDisplaying = isDisplaying;
        this.gridW        = igridW=gridH;
        this.gridH        = igridH=gridW;
        this.tileMax        = itileMax=tileMax;
        this.tileScale    = itileScale=tileScale;
        values = [];
    }
    
    
    private function cTrace(arg1:String):void 
    {
        TilingLine.traceAt(arg1);
    }
    
    public function create(number:Number=0):Tile
    {
        var position        :int = -1;
        var emptyWidth    :int = 0;
        var icount:int = 0;
        for ( var i:int = emptyPos; i < emptyPos + 500 ; i++ )
        {
            icount++;
            if (hasPeriodBeenSet)
            {
                //cTrace( "i : " + i );
            }
            if ( !_map[i] && position == -1 )
            {
                //cTrace( "( !_map[i] && position == -1 ) : " + ( !_map[i] && position == -1 ) );
                position = i;
                emptyWidth++;
            } else if ( emptyWidth >= tileMax )
            {
                //cTrace( "( emptyWidth >= tileMax ) : " + ( emptyWidth >= tileMax ) );
                break;
            } else if ( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) 
            {
                //cTrace( "( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) : " + ( !_map[i] && !( i % gridW == 0 && i != emptyPos ) ) );
                emptyWidth++;
            } else if ( position != -1 ) 
            {
                //cTrace( "( position != -1 ) : " + ( position != -1 ) );
                break;
            }
        }
        cTrace( "_map.length : " + _map.length );
            cTrace( "icount : " + icount );
        var ww:int    = hasPeriodBeenSet ? values[count++][2] / tileScale:int( Math.random() * emptyWidth ) + 1;
        number = 0;
        
        var p:int = position;
        for ( var yy:int = 0; yy < ww; yy++ ){
            for ( var xx:int = 0; xx < ww; xx++ ){
                _map[p] = 1;
                p++;
            }
            p += gridW - ww;
        }
        emptyPos = position + ww;
        
        var px:int = position % gridW * tileScale;
        trace( "px : " + px );
        var py:int = position == 0 ? 0 : int( position / gridW ) * tileScale;
        var color:uint = 0;
        if (!hasPeriodBeenSet)
        {
            values[values.length] = [px, py, ww * tileScale, ww * tileScale, _isDisplaying ];  
        }
        else 
        {
            color = 1;
        }
        return new Tile( px, py, ww * tileScale, ww * tileScale,_isDisplaying,color );
    }
    
    public function reset():void 
    {
        this.gridW        = igridW;
        this.gridH        = igridH;
        this.tileMax        = itileMax;
        this.tileScale    = itileScale;
        //values.length = 0;
        _map = null;
        _map = [];
        emptyPos = 0;
    }
}
internal class Tile extends Sprite
{
    static private var color:uint;
    public static var counter:int;
    public static var lineCounter:int;
    public static var period:uint = 310;
    public static var linePeriod:uint = 310;
    private const colors:Array=[0xff0000,0,0xff]
    private var pCounter:int;
    public function Tile( _x:int, _y:int, _w:int, _h:int,isDisplaying:Boolean=true,colorArg:uint=0 ):void
    {
        if (_x<0.1) 
        {
            lineCounter++;
            if (colorArg) 
            {
                color = Math.random() * 0xffffff;
                color = 0xffffff;
                if (lineCounter%2==1 && false) 
                {
                    color = colors[lineCounter % colors.length];
                    //color = 0;
                }
            }
            else
            {
                color = colors[lineCounter % colors.length];
            }
        }
        this.x = _x+1;
        this.y = _y+1;
        counter++;
        if (isDisplaying)
        {
            var tf:TextField = (addChild(new TextField) as TextField);
            tf.text = counter.toString();
            tf.border = true;
            tf.selectable = false;
            tf.width = _w-3;
            tf.height = 20;
        }
        if (lineCounter%2==1)graphics.lineStyle( 2,  colors[lineCounter % colors.length] );
        graphics.beginFill(color);
        graphics.lineStyle(0);
        graphics.drawRect( 0, 0, _w - 2, _h - 2 );
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        pCounter = counter;
    }
    
    private function onMouseOver(e:MouseEvent):void 
    {
        
    }
    
    private function cTrace(arg1:String):void 
    {
        TilingLine.traceAt(arg1);
    }
}
class Line extends Sprite
{
    public var colorRGB:NormalizedRGB = new NormalizedRGB();
    public var hasBeenClicked:Boolean;
}
class NormalizedRGB extends  ColorRGB
{
    private const inv:Number = 1 / 255;
    public function get rr():Number { return r*inv; }
    public function get gg():Number { return g*inv; }
    public function get bb():Number { return b*inv; }
}