/**
 * Copyright nogud ( http://wonderfl.net/user/nogud )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fBTQ
 */

// forked from simultechnology's 初めてのActionScript3.0を見ながら書いてみた。
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	
	public class ParticleDemo extends Sprite
	{
		private var _emitterX:Number = stage.stageWidth/2;
		private var _emitterY:Number = stage.stageHeight/2;
		
		public function ParticleDemo()
		{
			stage.addEventListener(Event.ENTER_FRAME, onLoop, false, 0, true);
		}
		
		private function onLoop(e: Event):void
		{
			var p:Particle = new Particle(_emitterX, 
										   _emitterY,
										   Math.random() * 11 - 6,
										   Math.random() * -20,
										   1,
										   Math.random() * 0xFFFFFF);
			
			addChild(p);
		}
	}
}

import flash.display.*;
import flash.events.Event;
import flash.geom.*;

class Particle extends Sprite
{
	private var _xpos:Number;
	private var _ypos:Number;
	private var _xvel:Number;
	private var _yvel:Number;
	private var _grav:Number;
	
	public function Particle(xp:Number, yp:Number, xvel:Number,
							 yvel:Number, grav:Number, col:uint)
	{
		_xpos = xp;
		_ypos = yp;
		_xvel = xvel;
		_yvel = yvel;
		_grav = grav;
	
		var ball:Sprite = new Ball(xp - 250, yp - 200);
		addChild(ball);
		
		x = _xpos;
		y = _ypos;
		alpha = 0.8;
		// 最低0.1～3.0の間で収まるようにする
		scaleX = scaleY = Math.random()*2.9 + 0.1;
		
		var colorInfo:ColorTransform = ball.transform.colorTransform;
		colorInfo.color = col;
		ball.transform.colorTransform = colorInfo;
		
		addEventListener(Event.ENTER_FRAME, onRun, false, 0, true);
		
	}
	
	private function onRun(e:Event):void
	{
		_yvel += _grav;
		_xpos += _xvel;
		_ypos += _yvel;
		x = _xpos;
		y = _ypos;
		
		if (_xpos < 0 || _ypos < 0 || _xpos > stage.stageWidth ||
			_ypos > stage.stageHeight) {
			removeEventListener(Event.ENTER_FRAME, onRun);
			parent.removeChild(this);
		}
	}
}

class Ball extends Sprite
{
	public function Ball(xpos:Number, ypos:Number)
	{
		this.graphics.beginFill(0xFF0000, 0.5);
		this.graphics.drawCircle(xpos, ypos, 10);
		this.graphics.endFill();
	}
}