/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fBND
 */

// forked from bkzen's 【問題】Graphics の drawCircle と drawRoundRect が壊れました
package 
{
	import adobe.utils.CustomActions;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Matrix;
	
	/**
	 * Graphics.drawCircle と drawRoundRect が壊れました。
	 * 別の方法で、半径 CIRCLE_RADIUS の 円を書きなさい。
	 * @mxmlc -o bin/CircleTest.swf -load-config+=obj\Alltest3Config.xml
	 * @author jc at bk-zen.com
	 */
	public class CircleTest extends Sprite
	{
		private const ANSWER_COLOR: uint = 0x003366;
		private const COLOR: uint = 0x3399CC;
		private const CIRCLE_RADIUS: Number = 50;
		
		public function CircleTest() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e: Event = null): void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//
			var centerX: Number = (stage.stageWidth - CIRCLE_RADIUS) / 2;
			var centerY: Number = (stage.stageHeight - CIRCLE_RADIUS) / 2;
			var g: Graphics = graphics;
			// 差を見るために解答として先に半径+1 の円を描いておきます。
			g.beginFill(ANSWER_COLOR); g.drawCircle(centerX, centerY, CIRCLE_RADIUS + 1);
			
			// 
			drawCircle(g, centerX, centerY, CIRCLE_RADIUS, COLOR);
		}
		
		/**
		 * これを作る。
		 * @param	g
		 * @param	x
		 * @param	y
		 * @param	r
		 * @param	color
		 */
		public function drawCircle(g: Graphics, x: Number, y: Number, r: Number, color: uint): void
		{
			var bmp: Bitmap = Bitmap(addChild(new Bitmap(bmd = new BitmapData(r * 2, r * 2, true, 0), "auto", true)));
			var bmp2: Bitmap = Bitmap(addChild(new Bitmap(ground = bmd.clone(), "auto", true)));
			bmp2.x = bmp.x = x - r;
			bmp2.y = bmp.y = y - r;
			var a: Ant;
			for (var i:int = 0; i < 100; i++) 
			{
				if (ant == null) Ant(ant = a = new Ant(r, r, 0)).view = new BitmapData(4, 1, false, 0);
				else Ant(a = a.next = new Ant(r, r, 0)).view = ant.view;
			}
			rr = r;
			r2 = r * 2;
			tmpColor = 0xFF000000 | color;
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e: Event): void 
		{
			var a: Ant = ant, x: Number, y: Number;
			bmd.lock();
			ground.lock();
			ground.fillRect(ground.rect, 0x0);
			do
			{
				maMatrix.a = maMatrix.d = 1;
				maMatrix.b = maMatrix.c = maMatrix.tx = maMatrix.ty = 0;
				if (--a.time < 0)
				{
					a.speed = Math.random() - 0.1;
					a.rotation = (Math.random() - 0.5) * 0.1;
					a.time = 30 + Math.random() * (40 - a.speed * 40);
				}
				maMatrix.rotate(a.angle += a.rotation);
				x = (maMatrix.tx = (a.x += a.speed * Math.cos(a.angle))) - rr;
				y = (maMatrix.ty = (a.y += a.speed * Math.sin(a.angle))) - rr;
				ground.draw(a.view, maMatrix, null, null, null, true);
				if (Math.sqrt(x * x + y * y) < rr)
				{
					bmd.setPixel32(maMatrix.tx, maMatrix.ty, tmpColor);
				}
				if (a.x < 0) a.x += r2;
				else if (a.x > r2) a.x -= r2;
				if (a.y < 0) a.y += r2;
				else if (a.y > r2) a.y -= r2;
			}
			while (a = a.next)
			ground.unlock();
			bmd.unlock();
		}
		
		private var ant: Ant;
		private var bmd: BitmapData, ground: BitmapData;
		private var maMatrix: Matrix = new Matrix();
		private var rr: Number;
		private var r2: Number;
		private var tmpColor: uint;
		
	}

}
import flash.display.BitmapData;
class Ant
{
	public var x: Number = 0, y: Number = 0, angle: Number = 0, rotation: Number = 0, speed: Number = 0;
	public var len: int = 1, time: int;
	public var next: Ant;
	public var view: BitmapData;
	function Ant(x: Number, y: Number, time: int)
	{
		this.x = x;
		this.y = y;
		this.time = time;
	}
}