/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fBAK
 */

// forked from _wonder's 3Dの回転
// forked from _wonder's 複数のボール跳ね返り3D
// forked from _wonder's 跳ね返り3D
// forked from _wonder's ボールを動かす3D
// forked from _wonder's 遠ざかるボール
// forked from _wonder's base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class MultiBound extends Sprite {
        private var balls:Array;
        private var numBalls:Number = 100;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        
        public function MultiBound() {
            balls = new Array();
            for( var i:uint = 0; i < numBalls; i++ ){
                var ball:Ball3D = new Ball3D( 5 );
                balls.push( ball );
                ball.xpos = Math.random() * 200 - 100;
                ball.ypos = Math.random() * 200 - 100;
                ball.zpos = Math.random() * 200 - 100;
                addChild( ball );
            }

            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            for( var i:uint = 0; i < numBalls; i++ ){
                var angleY:Number = ( mouseX - vpX ) * 0.0005;
                var angleX:Number = ( mouseY - vpY ) * 0.0005;
                var ball:Ball3D = balls[i];
                rotateX( ball, angleX );
                rotateY( ball, angleY );
                doPerspective( ball );
            }
            sortZ();
        }

        private function rotateY(ball:Ball3D, angleY:Number):void {
            var position:Array = [ball.xpos, ball.ypos, ball.zpos];
            var cos:Number = Math.cos( angleY );
            var sin:Number = Math.sin( angleY );
            
            var xRotMatrix:Array = new Array();
            xRotMatrix[0] = [cos,0,sin];
            xRotMatrix[1] = [0,1,0];
            xRotMatrix[2] = [-sin,0,cos];
            
            var result:Array = matrixMultiply( position, xRotMatrix);
            ball.xpos = result[0];
            ball.ypos = result[1];
            ball.zpos = result[2];
        }
        
        private function rotateX(ball:Ball3D, angleX:Number):void {
            var position:Array = [ball.xpos, ball.ypos, ball.zpos];
            var cos:Number = Math.cos( angleX );
            var sin:Number = Math.sin( angleX );
            
            var xRotMatrix:Array = new Array();
            xRotMatrix[0] = [1,0,0];
            xRotMatrix[1] = [0,cos,sin];
            xRotMatrix[2] = [0,-sin,cos];
            
            var result:Array = matrixMultiply( position, xRotMatrix);
            ball.xpos = result[0];
            ball.ypos = result[1];
            ball.zpos = result[2];
        }
        
        private function matrixMultiply( matrixA:Array, matrixB:Array ):Array {
            var result:Array = new Array();
            result[0] = matrixA[0] * matrixB[0][0] + matrixA[1] * matrixB[1][0] + matrixA[2] * matrixB[2][0];
            result[1] = matrixA[0] * matrixB[0][1] + matrixA[1] * matrixB[1][1] + matrixA[2] * matrixB[2][1];
            result[2] = matrixA[0] * matrixB[0][2] + matrixA[1] * matrixB[1][2] + matrixA[2] * matrixB[2][2];
            return result;
        }
        
        private function doPerspective(ball:Ball3D):void {            
            if( ball.zpos > -fl ){
                var scale:Number = fl / ( fl + ball.zpos );
                ball.scaleX = ball.scaleY = scale;
                ball.x = vpX + ball.xpos * scale;
                ball.y = vpX + ball.ypos * scale;
                ball.visible = true;
            } else {
                ball.visible = false;
            }
        }
        
        private function sortZ():void {
            balls.sortOn( "zpos", Array.DESCENDING | Array.NUMERIC );
            for( var i:uint = 0; i < numBalls; i++ ){
                var ball:Ball3D = balls[i];
                setChildIndex( ball, i );
            }
        }
    }
}

import flash.display.Sprite;

class Ball3D extends Sprite {
    public var radius:Number;
    public var color:uint;
    public var xpos:Number = 0;
    public var ypos:Number = 0;
    public var zpos:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;
    public var mass:Number = 1;
    
    public function Ball3D(radius:Number=40, color:uint=0Xff0000){
        this.radius = radius;
        this.color = color;
        init();
    }
    
    public function init():void {
        graphics.lineStyle( 0 );
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
}