/**
 * Copyright taka_milk ( http://wonderfl.net/user/taka_milk )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fB4q
 */

// forked from bioRex21's Construct Image from tiles
package {
	import caurina.transitions.Tweener;	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.FileFilter;
	import flash.net.FileReference;
	import flash.net.URLRequest;

	public class ConstructImage extends Sprite
	{
		
		private var loader:Loader;
		private var imageUrl:URLRequest;
		private var sourceBmd:BitmapData;
		private var sectionBmd:BitmapData;
		private var sectionWidth:Number;
		private var sectionHeigth:Number;
		
		private var horFrames:Number;
		private var verFrames:Number;
		
		private var btn:Button;
		private var fileRef:FileReference;
				
		public function ConstructImage()
		{
			// horFrames*verFrames = total paticles
			horFrames = 30;
			verFrames = 30;			
			
			btn = new Button("click here to load an image");
			addChild(btn);
			btn.x = 320;
			btn.addEventListener(MouseEvent.CLICK, browseFiles);			
		}
		
		public function browseFiles(e:MouseEvent):void
		{
			fileRef = new FileReference();
			fileRef.addEventListener(Event.SELECT, selectHandler);
			
			var arr:Array = [];
                        arr.push(new FileFilter("Images", ".gif;*.jpeg;*.jpg;*.png"));
			fileRef.browse(arr);
		}
		
		
		public function selectHandler(e:Event):void
		{
			fileRef.load();
			fileRef.addEventListener ( Event.COMPLETE, onDataLoaded ) ;
		}
		
		public function onDataLoaded(e:Event):void
		{
			var tempFileRef:FileReference = FileReference (e.target) ;
			loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoaded);
			loader.loadBytes(tempFileRef.data);
		}
 
		private function onImageLoaded (e:Event):void
		{
			sourceBmd = (e.target.content).bitmapData;
			imageReady();
		}

		
		public function imageReady():void
		{
			var w:Number = loader.content.width;
			var h:Number = loader.content.height;
			
			sectionWidth = Math.round(w/horFrames);
			sectionHeigth = Math.round(h/verFrames);
			sourceBmd = new BitmapData(w,h);
			sourceBmd.draw(loader.content);
			
			var i:Number = 1;
			var rect:Rectangle = new Rectangle();
			var yMultiplier:Number = 0;
			var xMultiplier:Number = 0;
			
			for(i; i<=(horFrames * verFrames); i++)
			{
				sectionBmd = new BitmapData(sectionWidth, sectionHeigth);
				
				rect.x = xMultiplier* sectionWidth;
				rect.y = yMultiplier* sectionHeigth;
				rect.width = sectionWidth;
				rect.height = sectionHeigth;
				
				sectionBmd.copyPixels(sourceBmd, rect, new Point());
				xMultiplier++;
				
				if(i % horFrames == 0 )	
				{
					yMultiplier++;
					xMultiplier = 0;
				}
				tweenMe(sectionBmd, rect.x, rect.y );
			} 
			//put the btn over the image
			setChildIndex(btn, (numChildren - 1));
		}
		
		public function tweenMe(sectionData:BitmapData, destX:Number, destY:Number):void
		{
			var b:Bitmap = new Bitmap(sectionData);
			b.x =  Math.floor(Math.random() * (1+550-10)) + 10;
			b.y = Math.floor(Math.random() * (1+200-400)) + 200;
			addChild(b);
			Tweener.addTween(b, {x:destX, y:destY, time:2} );
		}
	}//ConstructImage Class
}//package

import flash.display.Sprite;
import flash.text.TextField;

class Button extends Sprite
{
	
	private var texto:TextField;
		
	public function Button(label:String="label")
	{
		graphics.beginFill(0xff00ff);
		graphics.drawRect(0,0, 200, 20);
		graphics.endFill();
		
		texto = new TextField();
		texto.textColor = 0x000000;
		texto.width = 200;
		texto.text = label;
		texto.selectable = false;
		
		addChild(texto);
	}	
}
