/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/fAF8
 */

// forked from clockmaker's [PV3D]外部画像をLoaderを利用して読み込んだ場合の実装方法
//テクスチャ貼り付けの勉強
//Firefoxでは表示されるが、IEでは表示されない。。。 Google Chromeでもうまくいかない。。。
//外部データ読み込み、crossdomain.xmlの設定難しいなぁ。。。
//今後は、外部データ読み込み方式からBase64データの埋め込み方式に変えてみる予定です。
package {
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    /**
    * 外部画像をBitmapFileMaterialでなく、
    * Loaderを経由してMovieMaterialで表示させるサンプル
    */
    
    public class Main extends BasicView {
        public function Main():void {

            // LoaderContextを準備(クロスドメイン対策：自分のドメインだったらいりません)
            var context:LoaderContext = new LoaderContext(true);

            // 外部ファイルを読み込みます
            var loader:Loader = new Loader();
            loader.load(new URLRequest("http://oretaikan.atukan.com/Creation/sla.jpg"), context);
            
            // マテリアル(テクスチャ)をMovieMaterialをして作成
            // 3番目の引数(animated)をtrueに設定することで常に最新の絵が反映される
            var material:MovieMaterial = new MovieMaterial(loader, true, true);
            material.doubleSided = true; // 両面にテクスチャを貼る
            material.precise = true; // テクスチャの歪み防止
            
            // 平面を作成
            var plane:Plane = new Plane(material, 500, 500);
            
            // 画面を表示
            scene.addChild(plane);
            
            // レンダリング開始
            startRendering();
            
            // ついでに回転でもさせておく
            addEventListener(Event.ENTER_FRAME, function():void {
                plane.yaw(1);
            });
        }
    }
}