/**
 * Copyright KinkumaDesign ( http://wonderfl.net/user/KinkumaDesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f9sc
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="450",height="450",backgroundColor="0xffffff")]
    public class KKLoggerUsage extends Sprite
    {
        private var _clickTimes:int = 0;
        private var _logger:KKLogger;
        
        public function KKLoggerUsage()
        {
            _logger = new KKLogger();
            _logger.x = 10;
            _logger.y = 10;
            addChild(_logger);
            
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
        
        protected function onAddedToStage(event:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            stage.addEventListener(MouseEvent.CLICK, onStageMouseClick);
        }
        
        protected function onStageMouseClick(event:MouseEvent):void
        {
            _clickTimes++;
            var logText:String = "You clicked " + _clickTimes + " time";
            if(_clickTimes > 1){
                logText += "s";
            }
            _logger.log(logText);
        }
    }
}


import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;

class KKLogger extends Sprite
{
    private var _textField:TextField;
    private var _bg:Shape;
    
    public function KKLogger(aWidth:int = 200, aHeight:int = 150)
    {
        _textField = new TextField();
        _textField.multiline = true;
        _textField.width = aWidth;
        _textField.height = aHeight;
        addChild(_textField);
        var tf:TextFormat = new TextFormat();
        tf.font = "_sans";
        tf.color = 0xffffff;
        tf.size = 10;
        _bg = new Shape();
        addChildAt(_bg, 0);
        var g:Graphics = _bg.graphics;
        g.beginFill(0x000000, 0.8);
        g.drawRect(0,0,aWidth, aHeight);
        g.endFill();
        _textField.defaultTextFormat = tf;
        mouseChildren = mouseEnabled = false;
    }
    
    public function log(text:String):void
    {
        if(_textField.text == ""){
            _textField.text = text;
        }else{
            _textField.appendText("\n" + text);
        }
        var tft:String = _textField.text;
        var ar:Array = tft.split("\r");
        while(_textField.textHeight + 5 > _textField.height){
            ar.shift();
            _textField.text = ar.join("\n");
        }
    }
}
