/**
 * Copyright termat ( http://wonderfl.net/user/termat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f9mH
 */

package
{
	import flash.events.Event;
	import flash.display.MovieClip;
	import flash.events.MouseEvent;
	import flash.system.Security;
	import flash.geom.Rectangle;
	import com.modestmaps.Map;
	import com.modestmaps.TweenMap;
	import com.modestmaps.mapproviders.OpenStreetMapProvider;
	import org.papervision3d.core.geom.renderables.Triangle3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.geom.TriangleMesh3D;
	import org.papervision3d.core.math.Matrix3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.core.math.NumberUV;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.core.effects.view.ReflectionView;
	
	[SWF(width="480", height="480", backgroundColor="0xffffff", frameRate="60")];
	public class OsmMap5 extends ReflectionView{
		private var earth:Sphere;
		private var map:Map;
		private var material:CompositeMaterial;
		private var pointer:CompositeMaterial;
		private var selected:Triangle3D;
		private var cursor:Vertex3D = new Vertex3D(0,0,0);
		
		public function OsmMap5() {
			Security.loadPolicyFile("http://tile.openstreetmap.org/crossdomain.xml");
			camera.y = 300; 
			var col:ColorMaterial = new ColorMaterial(0xffffff, 0.5);
			var co:CompositeMaterial = new CompositeMaterial();
			co.addMaterial(col);
			var floor:Plane = new Plane(co, 2000, 2000, 12, 12);
			floor.pitch(-90);
			scene.addChild(floor);
			map = new TweenMap(520, 400, true, new OpenStreetMapProvider(), null);
			var mc:MovieClip = new MovieClip();
			mc.x = 100000;
			mc.addChild(map);
			addChild(mc);
			material = new CompositeMaterial();
			material.addMaterial(new WireframeMaterial(0xff8888));
			var material2:MovieMaterial = new MovieMaterial(mc, false, true, false, new Rectangle(0, 0, 520, 400));
			material.addMaterial(material2);
			earth = new Sphere(material, 290, 24, 24);
			earth.y = 295;
			scene.addChild(earth);
			addEventListener(Event.ENTER_FRAME, update);		
			pointer = new CompositeMaterial();
			pointer.addMaterial(material2);
			pointer.addMaterial(new ColorMaterial(0xff0000, 0.1));
		}

		private function update(e:Event):void {
			earth.rotationY = (earth.rotationY + (240 - mouseX) / 240) % 360;
			if (mouseY > 300) {
				earth.rotationX = (earth.rotationX + (300 - mouseY) / 100) % 360;
			}else {
				earth.rotationX = (earth.rotationX + (0 - earth.rotationX) / 150) % 360;
			}
			singleRender();
		}
	}
}