/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f8qW
 */

// どうしてこうなった・・
package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.*;
    import org.papervision3d.view.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.render.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.*;
    import org.libspark.betweenas3.*;
    import org.libspark.betweenas3.tweens.*;
    import org.libspark.betweenas3.events.*;
    import org.libspark.betweenas3.easing.*;
    
    [SWF(frameRate=60)]
    public class FlashTest extends BasicView {
        private var _cm : ColorMaterial;
        
        private var _lines : Lines3D;
        
        private var _tf : TextField;
        
        private var _p : Array;
        private var _cor : Array;
        
        private var _t : ITween;
        private var _tlap : Object;
        
        public function FlashTest() {
            super(0, 0, true, false, CameraType.FREE);
            
            _tf = new TextField();
            _tf.height = 465;
            _tf.width = 465;
            addChild(_tf);
            
            init();
            init3D();
            
            _tlap = {};
            _cor = [{},{},{},{}];
            onComplete();
            startRendering();
        }
        
        private function onComplete() : void
        {
            for each(var k : String in ["x", "y", "z"]){
                _cor[3][k] = (-_p[0][k] + 3 * _p[1][k] - 3 * _p[2][k] + _p[3][k]) / 6;
                _cor[2][k] = (_p[0][k] - 2 * _p[1][k] + _p[2][k]) / 2;
                _cor[1][k] = (-_p[0][k] + _p[2][k]) / 2;
                _cor[0][k] = (_p[0][k] + 4 * _p[1][k] + _p[2][k]) / 6;
            }
            
            _p.shift();
            var theta : Number = Math.random() * Math.PI * 2;
            var phi : Number = Math.random() * Math.PI * 2;
            _p.push({
                x : Math.cos(theta) * Math.sin(phi) * 500,
                y : Math.sin(theta) * Math.sin(phi) * 500,
                z : Math.cos(phi) * 500
            });
            
            _t = BetweenAS3.tween(_tlap, {t : 1.0}, {t : 0.0}, 1.0);
            _t.onComplete = onComplete;
            _t.play();
        }
        
        private var _vs : Array;
        private var E : int = 300;
        private var _prev : Number3D = new Number3D(10, 0, 0);
        
        private var _dummy : DisplayObject3D = new DisplayObject3D();
        private var _dummy2 : DisplayObject3D = new DisplayObject3D();
        
        override protected function onRenderTick(e : Event = null) : void
        {
            var t : Number = _tlap.t;
            var vec : Array = [];
            for each(var k : String in ["x", "y", "z"]){
                vec.push(((((_cor[3][k] * t) + _cor[2][k]) * t) + _cor[1][k]) * t + _cor[0][k]);
            }
            var cur : Number3D = new Number3D(vec[0], vec[1], vec[2]);
            var prev : Number3D = _vs[_vs.length - 1];
            
            _dummy.position = prev;
            _dummy2.position = cur;
            _dummy.lookAt(_dummy2);
            
            var _pp : Number3D = _prev.clone();
            Matrix3D.multiplyVector3x3(_dummy.transform, _prev);
            
            _lines.addNewLine(2, prev.x + _pp.x, prev.y + _pp.y, prev.z + _pp.z, cur.x + _prev.x, cur.y + _prev.y, cur.z + _prev.z);
            _lines.addNewLine(2, prev.x - _pp.x, prev.y + _pp.y, prev.z + _pp.z, cur.x - _prev.x, cur.y + _prev.y, cur.z + _prev.z);
            _lines.addNewLine(2, cur.x - _prev.x, cur.y + _prev.y, cur.z + _prev.z, cur.x + _prev.x, cur.y + _prev.y, cur.z + _prev.z);
            /*
            _lines.addNewLine(2, prev.x + 10, prev.y, prev.z, cur.x + 10, cur.y, cur.z);
            _lines.addNewLine(2, prev.x - 10, prev.y, prev.z, cur.x - 10, cur.y, cur.z);
            _lines.addNewLine(2, cur.x - 10, cur.y, cur.z, cur.x + 10, cur.y, cur.z);
            */
            if(_lines.lines.length >= (E + 5) * 3){
                _lines.lines.shift(); 
                _lines.lines.shift();
                _lines.lines.shift();
            }
            
            _vs.push(cur);
            if(_vs.length >= E){
                var cc : Number3D = _vs.shift();
                camera.x = cc.x;
                camera.y = cc.y;
                camera.z = cc.z;
                var cd : Number3D = _vs[10];
                _dm.x = cd.x;
                _dm.y = cd.y;
                _dm.z = cd.z;
                camera.lookAt(_dm);
                camera.moveUp(5);
            }
            
//            _tf.appendText(qqq + " " + axis + "\n");
//            _tf.scrollV = _tf.maxScrollV;

            super.onRenderTick(e);
        }
        
        private var _dm : DisplayObject3D;
        private var _ds : Array;
        
        private function init3D() : void
        {
            _dm = new DisplayObject3D();
            _dm.x = 0;
            _dm.y = 0;
            _dm.z = 0;
            
            _vs = [Number3D.ZERO, Number3D.ZERO];
            _lines = new Lines3D(new LineMaterial(0x333377));
            scene.addChild(_lines);
            
            camera.x = 0;
            camera.y = 0;
            camera.z = 0;
            var cd : Object = _p[2];
            _dm.x = cd.x;
            _dm.y = cd.y;
            _dm.z = cd.z;
            camera.lookAt(_dm);
            camera.moveUp(5); 
           
            _cm = new ColorMaterial(0);
        }
        
        private function init() : void
        {
            _p = [];
            
            _p.push({x : 0, y : 0, z : 0});
            _p.push({x : 0, y : 0, z : 0});
            for(var i : int = 1;i < 3;i++){
                var theta : Number = Math.random() * Math.PI * 2;
                var phi : Number = Math.random() * Math.PI * 2;
                _p.push({
                    x : Math.cos(theta) * Math.sin(phi) * 1000,
                    y : Math.sin(theta) * Math.sin(phi) * 1000,
                    z : Math.cos(phi) * 1000
                });
            }
            
        }
    }
}