/**
 * Copyright hgw ( http://wonderfl.net/user/hgw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f8DO
 */

// forked from shapevent's Mouse Toy


package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.StageQuality;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
		
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]
	
	public class MouseToy extends Sprite {
		
		private var circles:Vector.<Shape>;
		private var NUM_CIRCLE:int = 125;
		
		private var canvas:Bitmap;
		
		
		public function MouseToy(){
			stage.quality = StageQuality.LOW;

			circles = new Vector.<Shape>();;
			canvas = new Bitmap(new BitmapData( 465, 465, true, 0x0 ));
			addChild( canvas );
			
			for (var i:int = 0; i<NUM_CIRCLE; i++){
				var c:Shape = makeCircle(NUM_CIRCLE, i);
				c.x = stage.stageWidth / 2;
				c.y = stage.stageHeight / 2;
				c.scaleX = 1 + i/2;
				c.scaleY = 0.01 + i/4;
				circles.push(c);
			}
			circles.reverse();
			
			addEventListener(Event.ENTER_FRAME, onLoop);
		}
		
		
		/**
		 * 
		 * @return 
		 * 
		 */		
		private function makeCircle(all:Number, now:Number):Shape{
			var al:Number = 1-(now/all);
			var s:Shape = new Shape();
			var g:Graphics = s.graphics;
			g.lineStyle( 0, 0x000000, .9*al);
			g.beginFill( 0xFFFFFF );
			g.drawCircle( 0, 0, 10);
			g.endFill();
			return s;
		}

		
		
		
		/**
		 * 
		 * @param e
		 * 
		 */		
		private function onLoop(e:Event):void
		{
			update();
			draw();			
		}
		
		private function update():void
		{	
			circles[0].y += ( mouseY - circles[0].y) * .9;
			circles[0].x += ( mouseX - circles[0].x) * .9;
			for (var i:int = 1; i<circles.length; i++){
				var pre:Shape = circles[i - 1];
				circles[i].y += (pre.y - circles[i].y) * .9;
				circles[i].x += (pre.x - circles[i].x) * .9;
			}
		}
		
		private function draw():void
		{	
			canvas.bitmapData.lock();
			canvas.bitmapData.fillRect( canvas.bitmapData.rect, 0x0);
			for (var i:int = 0; i<NUM_CIRCLE; i++){
				var s:Shape = circles[i];
				canvas.bitmapData.draw(s, s.transform.matrix);
			}
			canvas.bitmapData.unlock();
		}
		
	}
	
}