/**
 * Copyright watanabe ( http://wonderfl.net/user/watanabe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f7kw
 */

package {
    import flash.geom.*
    import flash.display.*;
    import flash.filters.*;
    import flash.events.*;
        public class FlashTest extends Sprite {

       public var bmpd:BitmapData = new BitmapData(255, 255, false, 0);
		public var bmp:Bitmap = new Bitmap();
		
		public var tgtd:BitmapData = new BitmapData(255,255,false,0);
		public var tgt:Bitmap = new Bitmap();
		public var filter:DisplacementMapFilter
		
		public var _phase:Number = 0;
		
		public function FlashTest() {
		    tgtd.noise(Math.random()*1000);
			addEventListener(Event.ENTER_FRAME,onFrame)
		}
		
		private function onFrame(e:Event):void {
			
			_phase -= Math.PI / 20;
			
			bmpd.lock();
			for (var i:int = 0; i < bmpd.width; i++) {
				
				for (var j:uint = 0; j < bmpd.height; j++) {
					
					var centerX:Number = bmpd.width / 2;
					var centerY:Number = bmpd.height / 2;
					
					var dx:Number = i - centerX;
					var dy:Number = j - centerY;
					
					var amp:Number = Math.sqrt(dx * dx + dy * dy);
					var rad:Number = Math.atan2(dy, dx);
					
					
					var strength:Number = Math.sin(amp / 10 + _phase);//波の強さ
					
					
					var r:Number = strength * Math.cos(rad)*128+128
					var g:Number = strength * Math.sin(rad)*128+128
					var b:Number  = 0;
					
					var rgb:Number=(r << 16 | g << 8 | b);
					bmpd.setPixel(i, j, rgb);
				}
				
			}
			bmpd.unlock();
			bmp.bitmapData = bmpd;
			addChild(bmp);
			
			
			tgt.bitmapData=tgtd;
			addChild(tgt);
			tgt.y=255;
			filter = new DisplacementMapFilter(bmpd,new Point(),BitmapDataChannel.RED,BitmapDataChannel.GREEN,5,5,DisplacementMapFilterMode.CLAMP)
			tgt.filters = [filter];
		}
        
        
    }
}