/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f7Uf
 */

// forked from clockmaker's [Alternativa3D] Basic Template
package {

	import alternativ5.engine3d.materials.FillMaterial
	import alternativ5.engine3d.primitives.Box;
	import alternativ5.engine3d.primitives.Plane;
	import alternativ5.engine3d.core.Sprite3D;
	import alternativ5.types.Texture;
	import alternativ5.types.Point3D;
	import alternativ5.utils.MathUtils


	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Matrix


	[SWF(width = 465, height = 465, frameRate = 60)]
	/**
	 * Alternativa3D EllipsoidColliderクラスを使った衝突判定
	 * 
	 * EllipsoidColliderクラスを使った衝突判定のサンプルです。
	 * Clickで、四角が落ちます。
	 * 
	 * @narutohyper
	 */

	/**
	 * Alternativa3D を簡単に扱うためのベーシックテンプレート
	 * @author Yasu (clockmaker)
	 */
	public class SimpleDemo extends Sprite {

		public function SimpleDemo():void {

			// テンプレートを作成します
			var template:BasicTemplate = new BasicTemplate();
			addChild(template);


			//-----------------------------------------------
			//板の作成
			//-----------------------------------------------
				var material:FillMaterial = new FillMaterial(0xFF666666); 
				var plane:Plane = new Plane(1000, 1000); 
				plane.cloneMaterialToAllSurfaces(material); 
				template.scene.root.addChild(plane); 

				//板の角度で跳ねる方向が変わります
				//plane.rotationZ = MathUtils.toRadian(10)
				plane.rotationX = MathUtils.toRadian(90)
				plane.y = 400
				
			//-----------------------------------------------
			//ボールの作成
			//-----------------------------------------------
				// マテリアルを作成します 
				material = new FillMaterial(0xFF6666FF); 

				// プリミティブを作成します 
				var ball:Ball = new Ball(template.scene,100,100,100); 
				ball.cloneMaterialToAllSurfaces(material); 
				// 3Dシーンのルートに追加します 
				template.scene.root.addChild(ball); 
				this.stage.addEventListener(MouseEvent.CLICK,onMouseClick)
				//ball.init()
				
				
			function onMouseClick(e:MouseEvent):void {
				ball.init()
			}


			// Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
			// レンダリング前に実行したい処理を記述します。
			template.onPreRender = function():void {

				// 立方体を回転させます (角度はラジアン)
				ball.doAction();
			

				// カメラの座標を中央に向かせる
				template.cameraContoller.lookAt(new Point3D());
			}
		}
	}
}





//落ちるボール

import alternativ5.engine3d.primitives.Box;
import alternativ5.types.Set;
import alternativ5.engine3d.physics.Collision
import alternativ5.engine3d.physics.EllipsoidCollider
import alternativ5.types.Point3D;

class Ball extends Box {

	private var collider:EllipsoidCollider;

	private var collision:Collision;

	private var nowPoint:Point3D;				//現在の位置
	private var newPoint:Point3D;				//移動位置
	private var speed:Point3D;					//スピード
	private var deceleration:Number;		//跳ね
	private var acceleration:Point3D;		//加速

	private var tempPoint:Point3D;

	public function Ball(scene:Scene3D,w:Number,h:Number,l:Number) {
		super(w,h,l);

		tempPoint= new Point3D();
		nowPoint = new Point3D();
		newPoint = new Point3D();
		speed=new Point3D();						//スピード
		deceleration=0.6;						//減速
		acceleration=new Point3D(0,0.6,0);		//加速

		//衝突判定に使う球の作成
		collider = new EllipsoidCollider (scene,w,h,l);
		collision = new Collision();
		collider.collisionSet=new Set()

		//衝突判定に使うFace(Mesh)の登録
		collider.collisionSet.add(this);
		nowPoint = new Point3D (0,800,0);
		this.coords = nowPoint;
				
	}

	public function init():void {
		//スピードの初期化
		speed = new Point3D();
		//位置の初期化
		nowPoint = new Point3D (0,-800,0);
		
	}

	public function doAction():void {
		speed.add(acceleration);

		//何かに衝突したかどうかをcheckし、真なら衝突情報をcollisionに返す
		if (collider.getCollision (nowPoint, speed, collision)) {
			//衝突方向と進行方向の内積をとり、新たな方向を割り出す。
			tempPoint.copy(collision.normal);

			tempPoint.multiply(2*Point3D.dot(tempPoint, speed));
			speed.subtract(tempPoint);
			speed.multiply(deceleration);
		}　else {
			//現在地(nowPoint)から移動分(speed ベクトル)を移動させ、衝突を判定した上で、新しい移動座標をdestinationPointに返します			
			collider.calculateDestination(nowPoint, speed ,newPoint);			
		}
		
		nowPoint.copy(newPoint);
		this.coords = nowPoint;

	}


}



















/**
 * BasicTemplate for Alternativa3D
 * Alternativa3Dを扱いやすくするためのテンプレートです
 * @author Yasu
 */
import alternativ5.engine3d.controllers.CameraController;
import alternativ5.engine3d.core.Camera3D;
import alternativ5.engine3d.core.Object3D;
import alternativ5.engine3d.core.Scene3D;
import alternativ5.engine3d.display.View;
import flash.display.Sprite;
import flash.display.StageAlign;
import flash.display.StageQuality;
import flash.display.StageScaleMode;
import flash.events.Event;
class BasicTemplate extends Sprite{
	/**
	 * シーンインスタンスです。
	 */
	public var scene:Scene3D;
	/**
	 * ビューインスタンスです。
	 */
	public var view:View;
	/**
	 * カメラインスタンスです。
	 */
	public var camera:Camera3D;
	/**
	 * カメラコントローラーです。
	 */
	public var cameraContoller:CameraController;
	
	private var _viewWidth:int;
	private var _viewHeight:int;
	private var _scaleToStage:Boolean;

	/**
	 * 新しい BasicTemplate インスタンスを作成します。
	 * @param	viewWidth
	 * @param	viewHeight
	 * @param	scaleToStage
	 */
	public function BasicTemplate(viewWidth:int=640, viewHeight:int=480, scaleToStage:Boolean = true) {
		_viewWidth = viewWidth;
		_viewHeight = viewHeight;
		_scaleToStage = scaleToStage;
		
		// Creating scene
		scene = new Scene3D();
		scene.splitAnalysis = false; // not analysis for performance
		scene.root = new Object3D();
		
		// Adding camera
		camera = new Camera3D();
		camera.z = -1000;
		scene.root.addChild(camera);
		
		// camera contoller
		cameraContoller = new CameraController(this);
		cameraContoller.camera = camera;
		
		// set view
		view = new View();
		view.camera = camera;
		addChild(view);
		
		// stage
		if (stage) init();
		else addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理をオーバーライドして記述します。
	 */
	protected function atInit():void {}
	
	/**
	 * 初期化されたときに実行されるイベントです。
	 * 初期化時に実行したい処理を記述します。
	 */
	private var _onInit:Function = function():void { };
	public function get onInit():Function { return _onInit; }
	public function set onInit(value:Function):void {
		_onInit = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPreRender():void {}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング前に実行したい処理を記述します。
	 */
	private var _onPreRender:Function = function():void{};
	public function get onPreRender():Function { return _onPreRender; }
	public function set onPreRender(value:Function):void {
		_onPreRender = value;
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理をオーバーライドして記述します。
	 */
	protected function atPostRender():void {
	}
	
	/**
	 * Event.ENTER_FRAME 時に実行されるレンダリングのイベントです。
	 * レンダリング後に実行したい処理を記述します。
	 */
	protected var _onPostRender:Function = function():void{};
	public function get onPostRender():Function { return _onPostRender; }
	public function set onPostRender(value:Function):void {
		_onPostRender = value;
	}
	
	/**
	 * レンダリングを開始します。
	 */
	public function startRendering():void {
		addEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	/**
	 * レンダリングを停止します。
	 */
	public function stopRendering():void {
		removeEventListener(Event.ENTER_FRAME, onRenderTick);
	}
	
	/**
	 * シングルレンダリング(レンダリングを一回だけ)を実行します。
	 */
	public function singleRender():void {
		onRenderTick();
	}
	
	/**
	 * @private
	 */
	private function init(e:Event = null):void {
		stage.scaleMode = StageScaleMode.NO_SCALE;
		stage.align = StageAlign.TOP_LEFT;
		stage.quality = StageQuality.HIGH;

		// resize
		stage.addEventListener(Event.RESIZE, onResize);
		onResize(null);
		
		// render
		startRendering();
		
		atInit();
		_onInit();
		
	}
	
	/**
	 * @private
	 */
	private function onRenderTick(e:Event = null):void {
		atPreRender();
		_onPreRender();
		scene.calculate();
		atPostRender();
		_onPostRender();
	}
	
	/**
	 * @private
	 */
	private function onResize(event:Event = null):void {
		if (_scaleToStage) {
			view.width = stage.stageWidth;
			view.height = stage.stageHeight;
		}else {
			view.width = _viewWidth;
			view.height = _viewHeight;
		}
	}
}
