/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f7Sr
 */

package
{
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.net.URLLoader;
  import flash.net.URLRequest;
  import flash.text.TextField;
  import flash.text.TextFormat;

  public class ch17ex13 extends Sprite {
    protected var tf:TextField;
    protected var progressBar:Sprite;
    
    public function ch17ex13() {
      tf = new TextField();
      var fmt:TextFormat = new TextFormat("_serif", 24, 0x303030);
      fmt.leading = 10;
      fmt.leftMargin = fmt.rightMargin = 10;
      fmt.indent = 20;
      tf.defaultTextFormat = fmt;
      tf.multiline = tf.wordWrap = true;
      tf.mouseWheelEnabled = true;
      tf.height = stage.stageHeight;
      tf.width = stage.stageWidth;
      tf.text = "Loading...";
      addChild(tf);
      
      progressBar = new Sprite();
      progressBar.graphics.beginFill(0, 0.1);
      progressBar.graphics.drawRect(0, 0, stage.stageWidth, 60);
      progressBar.graphics.endFill();
      addChildAt(progressBar, 0);
  
      var loader:URLLoader = new URLLoader(new URLRequest(
        "http://actionscriptbible.com/files/alice-ch1.txt"));
      loader.addEventListener(Event.COMPLETE, onLoadComplete);
    }
    
    protected function onLoadComplete(event:Event):void {
      tf.text = URLLoader(event.target).data;
      tf.addEventListener(Event.ENTER_FRAME, scrollTextField);
      stage.frameRate = 15;
    }
    
    protected function scrollTextField(event:Event):void {
      var margin:Number = 50;
      if (stage.mouseY < margin) tf.scrollV--;
      if (stage.mouseY > stage.stageHeight - margin) tf.scrollV++;
      progressBar.y = (stage.stageHeight - progressBar.height)
        * (tf.scrollV / tf.maxScrollV);
    }
  }
}