/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f6sP
 */

package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;
import flash.sampler.getSize;
import org.papervision3d.core.math.*;
	
public class Main extends Sprite
{
    static private const N:uint = 10000;
    
    private function _init():void
    {
        _debug(
            "各テスト " + N + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _debug("Vector3D : " + getSize(new flash.geom.Vector3D()));
        _debug("Number3D : " + getSize(new org.papervision3d.core.math.Number3D()));
        _debug("flash.geom.Matrix3D : " + getSize(new flash.geom.Matrix3D()));
        _debug("org.papervision3d.core.math.Matrix3D : " + getSize(new org.papervision3d.core.math.Matrix3D()));
        _debug("org.papervision3d.core.math.Quaternion : " + getSize(new org.papervision3d.core.math.Quaternion()));
   
        _measure("empty(flash.geom)", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
	        		var v : Vector3D = new Vector3D(Math.random(), Math.random(), Math.random());
	        		var axis : Vector3D = new Vector3D(Math.random(), Math.random(), Math.random());
            }
        });
        
        _measure("empty(papervision3d)", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
	        		var v : Number3D = new Number3D(Math.random(), Math.random(), Math.random());
	        		var axis : Number3D = new Number3D(Math.random(), Math.random(), Math.random());
            }
        });
        
        _measure("appendRotation(flash.geom)", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
	        		var v : Vector3D = new Vector3D(Math.random(), Math.random(), Math.random());
	        		var axis : Vector3D = new Vector3D(Math.random(), Math.random(), Math.random());
	            var trans : flash.geom.Matrix3D = new flash.geom.Matrix3D();
	            // インスタンスを使い回せばさらに速い
//	        		trans.identity();
                trans.appendRotation(Math.random(), axis);
                v = trans.deltaTransformVector(v);
                // transformVectorも大して変わらない
            }
        });
        
        _measure("rotationMatrix(papervision3d)", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
	        		var v : Number3D = new Number3D(Math.random(), Math.random(), Math.random());
	        		var axis : Number3D = new Number3D(Math.random(), Math.random(), Math.random());
                var trans : org.papervision3d.core.math.Matrix3D = org.papervision3d.core.math.Matrix3D.rotationMatrix(axis.x, axis.y, axis.z, Math.random());
                org.papervision3d.core.math.Matrix3D.multiplyVector3x3(trans, v);
            }
        });
        
        _measure("applyQuaternion(papervision3d)", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
	        		var v : Number3D = new Number3D(Math.random(), Math.random(), Math.random());
	        		var axis : Number3D = new Number3D(Math.random(), Math.random(), Math.random());
		        	var q : Quaternion = Quaternion.createFromAxisAngle(
		            axis.x / axis.modulo, 
		            axis.y / axis.modulo, 
		            axis.z / axis.modulo,
		            Math.random()
		            );
		        var qc : Quaternion = Quaternion.conjugate(q);
		        
		        var qSrc : Quaternion = new Quaternion(v.x, v.y, v.z, 0);
		        var qDst : Quaternion = Quaternion.multiply(qc, qSrc);
		        qDst.mult(q);
		        v.x = qDst.x;
		        v.y = qDst.y;
		        v.z = qDst.z;
            }
        });
        
        _measure("raw", function ():void
        {
            for (var i:uint = 0; i < N; i++) {
	        		var v : Vector3D = new Vector3D(Math.random(), Math.random(), Math.random());
	        		var axis : Vector3D = new Vector3D(Math.random(), Math.random(), Math.random());
	        		v = rot(v, axis, Math.random());
            }
        });
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private function rot(x : Vector3D, axis : Vector3D, angle : Number) : Vector3D
    {
		var nCos:Number	= Math.cos(angle);
		var nSin:Number	= Math.sin(angle);
		var scos:Number	= 1 - nCos;

		var sxy	:Number = axis.x * axis.y * scos;
		var syz	:Number = axis.y * axis.z * scos;
		var sxz	:Number = axis.x * axis.z * scos;
		var sz	:Number = nSin * axis.z;
		var sy	:Number = nSin * axis.y;
		var sx	:Number = nSin * axis.x;

		var nx : Number = (nCos + axis.x * axis.x * scos) * x.x + (-sz + sxy) * x.y + (sy + sxz) * x.z;
		var ny : Number = (sz + sxy) * x.x + (nCos + axis.y * axis.y * scos) * x.y + (-sx + syz) * x.z;
		var nz : Number = (-sy + sxz) * x.x + (sx + syz) * x.y + (nCos + axis.z * axis.z * scos) * x.z;
		
		x.x = nx;
		x.y = ny;
		x.z = nz;
		return x;
//		return new Vector3D(nx, ny, nz);
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}