/**
 * Copyright amashio ( http://wonderfl.net/user/amashio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f6lw
 */

package{
    
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite{
        
        public function Main(){
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onStageMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onStageMouseUp);
        }
        
        private function createBrushStroke():void{
            var radius:uint = Math.random()*10 + 2;
            var diameter:uint = radius*2;
            var shape:Shape = new Shape();
            shape.graphics.beginFill(Math.random()*0xFFFFFF);
            shape.graphics.drawCircle(radius, radius, radius);
            shape.graphics.endFill();
            var brushStroke:BitmapData = new BitmapData(diameter, diameter, true, 0x00000000);
            brushStroke.draw(shape);
            graphics.lineStyle(diameter);
            graphics.lineBitmapStyle(brushStroke);
        }
        
        private function onStageMouseDown(event:MouseEvent):void{
            createBrushStroke();
            graphics.moveTo(stage.mouseX, stage.mouseY);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }
        
        private function onStageMouseUp(event:MouseEvent):void{
            stage.removeEventListener(MouseEvent.MOUSE_MOVE, onStageMouseMove);
        }
        
        private function onStageMouseMove(event:MouseEvent):void{
            graphics.lineTo(stage.mouseX, stage.mouseY);
            event.updateAfterEvent();
        }
    }
}