/**
 * Copyright hacker_johiroshi ( http://wonderfl.net/user/hacker_johiroshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f6fi
 */

//
//  MessageBox01
//
//  Created by ? ? on 10/05/25.
//  Copyright 2010 ???????. All rights reserved.
//

package {
  	import flash.display.Sprite;
   	import flash.text.TextField;
   	import flash.text.TextFormat;
	import flash.display.SimpleButton;
	import flash.events.MouseEvent;
	import flash.display.Graphics;
	
	public class MessageBox01 extends Sprite {
        
		private var tf:TextField = new TextField();
		private var tf1:TextField = new TextField();
		private var tfm:TextFormat = new TextFormat;
		private var button:SimpleButton = new SimpleButton();
		private var count:int = 0;
		private var s:Sprite = new Sprite();
		private var g:Graphics = s.graphics;
        
		public function MessageBox01()
		{
			SGraphics();

			var TextDetail = new TextDetail(tf);//テキストの設定
			addChild(TextDetail);
			
			var createTextField = new createTextField(tf, 20, 20, 425, 300);//テキストボックスの生成
			addChild(createTextField);
		
			//tf.defaultTextFormat = new TextFormat("", 20, 0x0, true);//テキストのデフォルト値を設定
			
			//TextFormatの生成
			tfm.color = 0x000000;
			tfm.size = 20;
			tfm.italic = true;
			tf.appendText("\nIntroduction2");
			tf.setTextFormat(tfm);
			addChild(tf);
			addButton();
		}

		private function SGraphics():void
		{
			graphics.lineStyle(2.0, 0x00FF00);
			graphics.beginFill(0x69E6FF);
			graphics.drawRect(0, 0, 500, 500);
			graphics.endFill();
		}

		private  function addButton():void
		{
			//Bottonの生成

			button.x = 350;
			button.y = 350;
			button.upState = stateButton(0x0);
			button.overState = stateButton(0xFF4500);
			button.downState = stateButton(0xFF4500);
			button.hitTestState = stateButton(0xFFF4500);
			button.addEventListener(MouseEvent.CLICK, onMouseClick);
			addChild(button);
			textButton();
		}

		private function stateButton(color:int):Sprite
		{
			//ボタンの設定
			g.lineStyle(2.0, 0xFF4500);
			g.beginFill(0xFFFFFF);
			g.drawRect(0, 0, 100, 50);
			g.endFill();
			//s.alpha = 1;
			textButton();
			return s;
		}

		private function textButton():void
		{
			//var tf1:TextField = new TextField();
			tf1.defaultTextFormat = new TextFormat("_typeWriter", 20, 0x000000, true);
			tf1.text = "Next";
			tf1.width = 50;
			tf1.height = 50;
			tf1.x =  372 //(width.stateButton  - tf1.width)  / 2;
			tf1.y = 362 //(height.stateButton - tf1.height) / 2;
			tf1.autoSize = "left";
			tf1.selectable = false;
			addChild(tf1);
		}
		
		private function onMouseClick(event:MouseEvent):void
		{
			//マウスプッシュに依る先送り。
			if(count==5)
			 {
			removeChild(tf);
			tf = null;
			removeChild(tf1);
			tf1 = null;
			g.clear();
			removeEventListener(MouseEvent.CLICK, onMouseClick);
			removeChild(button);
			graphics.clear();
			var tetris:Tetris = new Tetris;
			//tetris.Tetris();
			addChild(tetris);
			
			 }
			
			var	ms0:Array = ["学生も最後か。", "思えば短かったかもしれない。", "学生らしいのは高校生までか。", "これからは半社会人として生きていかなければならないと思うと気が重い。\n\nどうしよう。", "始まる…", "確認array5", "array6"];
			
			tf.text = "\n僕:" + (ms0[count++]);
			tf.setTextFormat(tfm);
		}
	}
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
	
class TextDetail extends Sprite
{
	private var tf:TextField = new TextField();
		
	//テキストの詳細を記入
	public function TextDetail(tf:TextField):void
	{
		//TextBoxの生成
		//var tf:TextField = new TextField();
		tf.text = "Introduction1";
		tf.x = 30;
		tf.y = 30;
		tf.width = 390;
		tf.height = 270;
		tf.multiline = true;		//複数行
		tf.wordWrap = true;		//テキストの折り返し
		//tf.autoSize = "left";
		//addChild(tf);
	}
}
	
import flash.display.Sprite;
import flash.display.Shape;
import flash.text.TextField;
import flash.text.TextFormat;
	
class createTextField extends Sprite
{
	public function createTextField(result:TextField, x:Number, y:Number, width:Number, height:Number):void
	{
		result.x = x;
		result.y = y;
		result.width = width;
		result.height = height;
		result.border = true;
		result.background = true;
		addChild(result);
	}
}


import flash.display.Sprite;
import flash.display.Shape;

import flash.events.KeyboardEvent;

import flash.geom.Point;

import flash.ui.Keyboard;

class Tetris extends Sprite
{
	private const HOGEHOGE:String = "hoge";
	private var hogeNum:Number = 100;
	//プロパティ
	private const FIELD_WIDTH:uint  = 14;

	private const FIELD_HEIGHT:uint = 22;

	private const CELL_WIDTH:uint   = 20;
	private const CELL_HEIGHT:uint  = 20;
	private const TET_WIDTH:uint = 4;
	private const TET_HEIGHT:uint = 4;

		

	private const EMPTY:uint        =  0;

	private const WALL:uint         =  9;

		

	private const WALL_COLOR:uint   = 0x7A5B52;

	private const GRID_COLOR:uint   = 0xC0C0C0;
	private const TET_COLORS:Array = [
		0xE9EE11, // tetPattern01
		0x4DE6E1, // tetPattern02
		0xEA68E7, // tetPattern03
		0xE49E1B, // tetPattern04
		0x2746D8, // tetPattern05
		0x46DF20, // tetPattern06
		0xED2212  // tetPattern07
	];
	private const tetPattern01:Array = [[0, 0, 0, 0], [0, 1, 1, 0], [0, 1, 1, 0], [0, 0, 0, 0]];
	private const tetPattern02:Array = [[0, 0, 0, 0], [2, 2, 2, 2], [0, 0, 0, 0], [0, 0, 0, 0]];
	private const tetPattern03:Array = [[0, 0, 0, 0], [0, 0, 3, 0], [0, 3, 3, 3], [0, 0, 0, 0]];
	private const tetPattern04:Array = [[0, 0, 0, 0], [0, 0, 0, 4], [0, 4, 4, 4], [0, 0, 0, 0]];
	private const tetPattern05:Array = [[0, 0, 0, 0], [0, 5, 0, 0], [0, 5, 5, 5], [0, 0, 0, 0]];
	private const tetPattern06:Array = [[0, 0, 0, 0], [0, 0, 6, 6], [0, 6, 6, 0], [0, 0, 0, 0]];
	private const tetPattern07:Array = [[0, 0, 0, 0], [0, 7, 7, 0], [0, 0, 7, 7], [0, 0, 0, 0]];
	private const TETROMINOS:Array = [tetPattern01, tetPattern02, tetPattern03, tetPattern04, tetPattern05, tetPattern06, tetPattern07];

		

	//壁マップ

	private var fieldMap:Array = [

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9],

		[9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9]

	];

	//

	private var fieldMapColor:Array = [

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0],

		[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]

	];

	private var gameField:Shape;
	private var location:Point;
	private var currentTetromino:Array;
	private var currentIndex:uint;

	//コンストラクタ
	public function Tetris()
	{
		init();
	}
	//初期化
	private function init():void
	{
		gameField = new Shape();
		addChild(gameField);
		gameField.x = CELL_WIDTH;
		gameField.y = CELL_HEIGHT;

		 //配置するテトリミノのパターンをランダムで選択して、「現在のテトリミノ」として配列を作成
		currentTetromino = new Array();
		currentIndex = createTetromino();
		currentTetromino = TETROMINOS[currentIndex];

		location = new Point(3, 0);

		colorMapping();
		drawField();

		//ステージイベント

		stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
	}

	private function onKeyDown(event:KeyboardEvent):void
	{

		switch(event.keyCode)
		{

			case Keyboard.LEFT:

				if (getLeftHit()) break;

				tetrominoClear();

				location.x--;

				fullDrawing();

				break;

			case Keyboard.RIGHT:

				if (getRightHit()) break;

				tetrominoClear();

				location.x++;

				fullDrawing();

				break;

			case Keyboard.DOWN:

				if (getBottomHit()) break;

				tetrominoClear();

				location.y++;	

				fullDrawing();

				break;

		}

	}

	private function adjacentCheck(tx:int, ty:int, direct:uint):Boolean
	{

		/**

		 * 渡されたゲームフィールド座標に隣接するセルが空白であるかどうかをチェックして真偽値を返す

		 * 引数:[tx　ty] 現在のテトリミノのセルが存在しているゲームフィールド上の座標

		 * [direct] 調べたいのはtx tyのどの方角なのか

		 * 戻り値:隣にブロック、テトリミノがあるなら真を返す

		 */

			

		var mx:int, my:int;

			

		switch(direct)
		{

			case Keyboard.LEFT:

				mx = location.x + tx -1; //一つ左隣を調べたい

				my = location.y + ty;

				if (fieldMap[my][mx] && fieldMap[my][mx] != currentIndex + 1)
					return true;

				else
					return false;

					

			case Keyboard.RIGHT:

				mx = location.x + tx +1; //一つ右隣を調べたい

				my = location.y + ty;

				if (fieldMap[my][mx] && fieldMap[my][mx] != currentIndex + 1)
					return true;

				else
					return false;

			case Keyboard.DOWN:

				mx = location.x + tx;

				my = location.y + ty + 1; //一つ下を調べたい

				if (fieldMap[my][mx] && fieldMap[my][mx] != currentIndex + 1)
					return true;

				else
					return false;

		}

		return true;

	}

	private function getBottomHit():Boolean
	{

		/**

		 * 現在のテトリミノ（currentTetromino:Array）

		 * 下方向に障害物がないかどうかをチェックして真偽値を返す。

		 * 戻り値:障害物があった場合に真を返す

		 */

			

		var result:Boolean;

			

		for (var x:int = 0; x < TET_WIDTH; x++)
		{

			for (var y:int = TET_HEIGHT - 1; y >= 0; y--)
			{

				if (currentTetromino[y][x])
				{

					//テトリミノがあればチェック

						result = adjacentCheck(x, y, Keyboard.DOWN);

						break;

				}

			}

			if (result) break;

		}

		return result;

	}	

		

	private function getLeftHit():Boolean
	{

		/**

		 * 現在のテトリミノ（currentTetromino:Array）

		 * 左方向に障害物がないかどうかをチェックして真偽値を返す。

		 * 戻り値:障害物があった場合に真を返す

		 */

			

		var result:Boolean;

			

		for (var y:int = 0; y < TET_HEIGHT; y++)
		{

			for (var x:int = 0; x < TET_WIDTH; x++)
			{

					if (currentTetromino[y][x]) 
					{

						//テトリミノがあればチェック

						result = adjacentCheck(x, y, Keyboard.LEFT);

						break;

					}

			}

			if (result) break;

		}

		return result;

			

	}	

		

	private function getRightHit():Boolean
	{

		/**

		 * 現在のテトリミノ（currentTetromino:Array）

		 * 右方向に障害物がないかどうかをチェックして真偽値を返す。

		 * 戻り値:障害物があった場合に真を返す

		 */

			

		var result:Boolean;

			

		for (var y:int = 0; y < TET_HEIGHT; y++)
		{

			for (var x:int = TET_WIDTH - 1; x >= 0; x--)
			{

				if (currentTetromino[y][x])
				{

					//テトリミノがあればチェック	

					result = adjacentCheck(x, y, Keyboard.RIGHT);

					break;

				}

			}

			if (result) break;

		}

		return result;

	} 

	private function tetrominoClear():void
	{

		/**

		 * マッピングデータ上から現在のテトリミノデータを消去する。

		 * テトリミノを移動する時に必要な処理。

		 */

		for (var y:int = location.y; y < location.y + TET_HEIGHT; y++)
		{

			var py:int = y - location.y;

			for (var x:int = location.x; x < location.x + TET_WIDTH; x++)
			{

				var px:int = x - location.x;

				if (currentTetromino[py][px])
				{

					fieldMap[y][x] = EMPTY;

					fieldMapColor[y][x] = EMPTY;

				}

			}

		}

			

	}	

		

	private function fullDrawing():void
	{

		colorMapping();

		drawField();

	}

	private function createTetromino():uint
	{
		/*
		ランダムなテトロミノ
		*/
		return Math.floor(Math.random()*7);
	}

	private function colorMapping():void
	{
		/*
		マッピングデータの作成
		*/
		for (var y:int = 0; y < FIELD_HEIGHT; y++) {
			for (var x:int = 0; x < FIELD_WIDTH; x++) {
				//壁のマッピング
				if(fieldMap[y][x] == WALL)
					fieldMapColor[y][x] = WALL_COLOR;
				//テトリミノのマッピング
				if(y >= location.y && y <location.y + TET_HEIGHT && x >= location.x && location.x + TET_WIDTH)
				{
					var px:int = x - location.x;
					var py:int = y - location.y;
					if (currentTetromino[py][px] && fieldMap[y][x] == EMPTY)
					{
						fieldMap[y][x] = currentTetromino[py][px];
						fieldMapColor[y][x] = TET_COLORS[currentIndex];
					}
				}
			}
		}
	}

	private function drawField():void
	{
		/*
		ゲームフィールドの描画
		*/
		var py:Number = 0;

		gameField.graphics.clear();
		gameField.graphics.lineStyle(1, GRID_COLOR);

		for (var y:int = 0; y < fieldMap.length; y++)
		{
			var px:Number = 0;

			for (var x:int = 0; x < fieldMap[y].length; x++)
			{
				if(fieldMap[y][x] > EMPTY)
					{
					gameField.graphics.beginFill(fieldMapColor[y][z]);
					gameField.graphics.drawRect(px, py, CELL_WIDTH, CELL_HEIGHT);
					}
				px += CELL_WIDTH;
			}
			py += CELL_HEIGHT;
		}
		gameField.graphics.endFill();
	}

	private function hogehogeCreate():void
	{
	}

	private function repaint():void
	{
	}

	private function rotate():void
	{
	}

	private function pick():void
	{
	}

	private function down():void
	{
	}
}