/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f5zW
 */

package {
  import flash.display.Sprite;
  import flash.events.TimerEvent;
  import flash.text.TextField;
  import flash.utils.Timer;

  import funnel.*;

  public class ControlTheDCMotorWithFirmata extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // 一定時間ごとに移動方向を変えるためのタイマ
    private var changeDirectionTimer:Timer;

    // 移動方向
    private var direction:int = -1;

    // SoftPotの状態を表示するテキストフィールド
    private var textField:TextField;

    public function ControlTheDCMotorWithFirmata() {
      arduino = new Arduino(Arduino.FIRMATA);

      // FIRMATA_STRINGイベントに対してイベントリスナをセット
      arduino.addEventListener(FunnelEvent.FIRMATA_STRING, 
                               onStringEvent);

      // 現在の状態を表示するテキストフィールドを追加
      textField = new TextField();
      addChild(textField);

      // 状態を一定時間（2000ms）ごとに変更するためのタイマを生成してスタート
      changeDirectionTimer = new Timer(2000);
      changeDirectionTimer.addEventListener(TimerEvent.TIMER, 
                                            onTimer);
      changeDirectionTimer.start();
    }

    // タイマイベントが発生したら以下を実行
    private function onTimer(e:TimerEvent):void {
      // 移動方向を交互に決定
      direction = (direction + 1) % 2;

      switch (direction) {
        case 0:
          // 左方向に移動
          arduino.sendFirmataString("L");
          break;
        case 1:
          // 右方向に移動
          arduino.sendFirmataString("R");
          break;
      }
    }

    // FIRMATA_STRINGイベントが発生したら以下を実行
    private function onStringEvent(e:FunnelEvent):void {
      // 受け取った文字列をテキストフィールドに表示
      textField.text = e.message;
    }
  }
}
