/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f5jx
 */

package {
  import flash.display.*;
  import flash.events.Event;
  import flash.geom.Point;
  import flash.media.Camera;
  import flash.media.Video;
  public class ch36ex11 extends Sprite {
    protected var bmp:BitmapData;
    protected var thresholdBmp:BitmapData;
    protected var video:Video;
    public function ch36ex11() {
      bmp = new BitmapData(400, 300);
      addChild(new Bitmap(bmp));
      video = new Video(400, 300);
      video.attachCamera(Camera.getCamera());
      stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    protected function onEnterFrame(event:Event):void {
      bmp.draw(video);
      var hst:Vector.<Vector.<Number>> = bmp.histogram(bmp.rect);
      var maxValue:Vector.<int> = new Vector.<int>(3, true);
      var maxFrequency:Vector.<Number> = new Vector.<Number>(3, true);
      for (var channel:int = 0; channel < 3; channel++) {
        for (var i:int = 0; i < 256; i++) {
          var value:Number = hst[channel][i];
          if (value > maxFrequency[channel]) {
            maxFrequency[channel] = value;
            maxValue[channel] = i;
          }
        }
      }
      var threshold:uint = maxValue[0] << 16 | maxValue[1] << 8 | maxValue[2];
      bmp.threshold(bmp, bmp.rect, new Point(),
        ">", threshold, 0xff000000, 0x00ffffff, true);
    }
  }
}