/**
 * Copyright gaziya ( http://wonderfl.net/user/gaziya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f5Mp
 */

// forked from gaziya's forked from: Matrix3Dのテスト
// forked from gaziya's Matrix3Dのテスト
package {
    import flash.display.Shape;
    import flash.geom.PerspectiveProjection
    import flash.geom.Matrix3D;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.display.Sprite;
    [SWF(width=465,height=465,frameRate=30)]
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            x = stage.stageWidth/2
            y = stage.stageHeight/2
            
            var length:Number = 1
            var points:Vector.<Vector3D> = new Vector.<Vector3D>()            
            points.push(new Vector3D(length,0,0))
            points.push(new Vector3D(-length,0,0))
            points.push(new Vector3D(0,length,0))
            points.push(new Vector3D(0,-length,0))
            points.push(new Vector3D(0,0,length/2))
            
            var shapes:Vector.<Shape> = new Vector.<Shape>()
            for (var i:int; i<points.length; i++) {
                shapes.push(new Shape)
                shapes[i].graphics.beginFill(0xf05000)
                shapes[i].graphics.drawCircle(0,0,100)
                addChild(shapes[i])
            }            
            
            var theta:Number = 0
            var projection:PerspectiveProjection = new PerspectiveProjection()            
            var proj_matrix:Matrix3D = projection.toMatrix3D()          
           
            addEventListener(Event.ENTER_FRAME, loop)
            function loop(e:Event):void {
                theta += Math.sqrt(mouseX*mouseX+mouseY*mouseY)/35
                theta %= 360
                var matrix:Matrix3D = new Matrix3D()                
                matrix.appendRotation(theta,new Vector3D(mouseX,mouseY,0))                
                matrix.append(proj_matrix)
                matrix.appendTranslation(0,0,length*2)
                for (var i:int; i<points.length; i++) {
                    var v:Vector3D = matrix.transformVector(points[i])
                    shapes[i].x = v.x
                    shapes[i].y = v.y
                    shapes[i].z = v.z*1000
                }
            }    
        }
    }
}
