/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f5Cd
 */

// 三角関数のテーブル引きによる高速化
// http://mibai.tec.u-ryukyu.ac.jp/~oshiro/Doc/misc/SinCos_Table.html
// 
// メモリ節約よりも速度重視にしています。
// 
import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 1000000;
    
    private var _a:String = "test";
    private var _abcdefghijklmnopqrstuvwsyzabcdefghijklmnopqrst:String = "test";
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
        _measure("初期化(10000)", function ():void
        {
			CMath.init(10000);
        });
		
        _measure("ループのみ", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                
            }
        });
        
        _measure("Math.cos(i);", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                Math.cos(i);
            }
        });
        
        _measure("CMath.cos(i);", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                CMath.cos(i);
            }
        });
        
        _measure("Math.sin(i);", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                Math.sin(i);
            }
        });
        
        _measure("CMath.sin(i);", function ():void
        {
            for (var i:uint = 0; i < _NUM_TIMES; i++) {
                CMath.sin(i);
            }
        });
		
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
		
		_debug("\n算出精度");
		_debug("cos(0)\nMath:" + Math.cos(0) + ", CMath:" + CMath.cos(0));
		_debug("cos(PI)\nMath:" + Math.cos(Math.PI) + ", CMath:" + CMath.cos(Math.PI));
		_debug("cos(1)\nMath:" + Math.cos(1) + ", CMath:" + CMath.cos(1));
		_debug("cos(10)\nMath:" + Math.cos(10) + ", CMath:" + CMath.cos(10));
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}

class CMath
{
	static private var _triNum:int = 0;
	static private var _triTable:Vector.<Number>;
	
	static public function init(num:int):void
	{
		_triNum = num;
		_triTable = new Vector.<Number>();
		// 0～PI*2までのcosを計算してテーブルにpush
		for (var i:int = 0; i <= num; i++)
		{
			_triTable.push(Math.cos(i / num * Math.PI * 2));
		}
	}
	static public function cos(x:Number):Number
	{
		if (x < 0) x = -x; // cos(x)=cos(-x)
		x /= Math.PI * 2;
		x = x % 1;
		var n:int = Math.round(x * _triNum);
		return _triTable[n];
	}
	static public function sin(x:Number):Number
	{
		return cos(x - Math.PI / 2);
	}
}
