package  
{
	import caurina.transitions.Tweener;
	import flash.display.Sprite;
	import flash.geom.Point;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)] 

	/**
	* Test of ellipse tangent math.
	* @author makc
	* @license WTFPLv2, http://sam.zoy.org/wtfpl/
	*/
	public class EllipseTangent extends Sprite {
		public var A:Number, B:Number, C:Number;

		public function EllipseTangent () {
			A = 150; B = 10; randomize ();
		}

		private function randomize ():void {
			Tweener.addTween (this, { B: A * Math.random (),
			time: 1, transition: "easeInOutElastic",
			onComplete:randomize,
			onUpdate: onUpdate });
		}

		private function onUpdate ():void {

			if (B < 10) B = 10; if (B > A) B = A;
			C = Math.sqrt (A * A - B * B);

			var p0:Point = new Point (
				mouseX - 465/2, mouseY - 465/2);
			p0.normalize (1);

			// http://mathworld.wolfram.com/Ellipse-LineIntersection.html
			var magic:Number = A * B / Math.sqrt (
				(A * p0.y) * (A * p0.y) +
				(B * p0.x) * (B * p0.x));
			p0.normalize (magic);

			var f1:Point = p0.subtract (new Point (-C, 0));
			f1.normalize (1);

			var f2:Point = p0.subtract (new Point (+C, 0));
			f2.normalize (1);

			var n:Point = f1.add (f2);
			n.normalize (1);

			graphics.clear ();
			graphics.beginFill (255);
			graphics.drawCircle (465/2 + p0.x, 465/2 + p0.y, 3);
			graphics.endFill ();

			graphics.lineStyle (0, 0x7F00);
			graphics.moveTo (465/2, 465/2);
			graphics.lineTo (mouseX, mouseY);
			graphics.lineStyle (0, 0x7FFF);
			graphics.lineTo (465/2 + 100 * p0.x, 465/2 + 100 * p0.y);
			graphics.lineStyle (0, 0x7F0000);
			graphics.moveTo (465/2 + p0.x, 465/2 + p0.y);
			graphics.lineTo (465/2 + p0.x + 30 * n.x, 465/2 + p0.y + 30 * n.y);
			graphics.moveTo (465/2 + p0.x - 90 * n.y, 465/2 + p0.y + 90 * n.x);
			graphics.lineTo (465/2 + p0.x + 90 * n.y, 465/2 + p0.y - 90 * n.x);
			graphics.lineStyle (0, 0x7FFF);
			graphics.drawEllipse (465/2 - A, 465/2 - B, 2 * A, 2 * B);
		}
	}
}