/**
 * Copyright elbib ( http://wonderfl.net/user/elbib )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f3ld
 */

// forked from ciel_to's flash on 2009-10-22
package
{
	import flash.display.Sprite;
	import flash.events.Event;

	public class aTree extends Sprite
	{
		private var _leaf:Array = [];
		private var _apple:Array = [];
		
		public function aTree()
		{
			init();
			addEventListener(Event.ENTER_FRAME,loop);
		}
		
		private function init():void
		{
			var i:int;
			for (i = 0; i < 3000; i++)
            { 
				var angle:Number = Math.random() * -180 * Math.PI / 180;
				var radius:Number = Math.random() * 200 + 300;
                var rx:Number = stage.stageWidth/2 + Math.cos(angle)*radius;
                var ry:Number = stage.stageHeight+ Math.sin(angle)*radius;
                var leaf:Leaf = addChild(new Leaf(rx,ry)) as Leaf;
                _leaf.push(leaf);
            }
            
            for(i=0; i<10; i++)
            {
            	var a:Apple = addChildAt(new Apple(), Math.random() * numChildren - 1) as Apple ;
				//a.x = Math.random() * stage.stageWidth;
				//a.y = Math.random() * 100;
				_apple.push(a);
            }
		}
		
		private function loop(e:Event):void
		{
			var i:int;
			for(i=400; i<800; i++)
			{
				_leaf[i].Move();
			}
			
			var len:uint = _apple.length;
			for(i=0; i<len; i++)
			{
				_apple[i].Move();
			}
		}
	}
}

import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Shape;
import flash.display.Graphics;
import flash.display.Sprite;
import flash.geom.Point;
import flash.utils.Timer;
import flash.events.TimerEvent;
import flash.events.Event;

//はっぱのclass
class Leaf extends Bitmap
{ 
    private var _timer:Timer;
    private var bx:Number;
    private var _x:Number;
    private var _amp:Number;
    private var _angle:Number;
    private var _v:Number;
    private var _moveFlg:Boolean;
	// 下の中心座標
	private var _center:Point = new Point(275, 600);
	private var _speedX:Number;
	private var _speedY:Number;
     
    public function Leaf(dx:Number, dy:Number)
    {
		//はっぱの領域
        this.x = dx;
        this.y = dy;
		_speedX = (_center.x - this.x)/150;
		_speedY = (_center.y - this.y)/150;
        _x = dx;
        _v = Math.random()*1+1;
        _amp = Math.random()*2 + 1;
        _angle = Math.random()*360;
        
        draw();
         
		 //２秒後からぱっぱがおちる
        var lifeTime:uint = Math.random()*18000+1000;
        _timer = new Timer(lifeTime, 1);
        _timer.addEventListener(TimerEvent.TIMER, onTimer);
        _timer.start();
    }
     
    private function draw():void
    {
        var g:Shape = new Shape();
        with (g.graphics)
		//はっぱ　３種類
        {
        	beginFill(0x7DEA88);
	        drawEllipse(3.4,0, Math.random()*10+2, Math.random()*8+2);
	        endFill();
	     
	        beginFill(0x4DE640);
	        drawEllipse(1.7,1.7,Math.random()*10+2, Math.random()*8+2);
	        endFill();
	     
	        beginFill(0x36BD1E);
	        drawEllipse(0,0,Math.random()*10+2, Math.random()*8+2);
	        endFill();
        }
        
        var bmd:BitmapData = new BitmapData(15,15,true,0x00);
        bmd.draw(g);
        this.bitmapData = bmd;
        
        g.graphics.clear();
        g = null;
    }
     
    private function onTimer(event:TimerEvent):void
    {
    	_timer.stop();
    	_timer.removeEventListener(TimerEvent.TIMER,onTimer);
    	_timer = null;
        _moveFlg = true;
    }
     
    public function Move():void
    {
    	if(_moveFlg)
    	{
    		_angle += 5;
	        var aa = _amp * Math.sin(_angle * Math.PI / 180);
			if (Math.abs(this.x - _center.x) >= 2)
			{
				 this.x += _speedX;
				this.x += aa;
			}
			if (Math.abs(this.y - _center.y) >= 2)
			{
				 this.y += _speedY;
			}
			else
			{
				var angle:Number = Math.random() * -180 * Math.PI / 180;
				var radius:Number = Math.random() * 200 + 300;
                var rx:Number = stage.stageWidth/2 + Math.cos(angle)*radius;
                var ry:Number = stage.stageHeight+ Math.sin(angle)*radius;
	        	this.y = ry;
	        	this.x = rx;
				_speedX = (_center.x - this.x)/150;
				_speedY = (_center.y - this.y)/150;
			}
	       
	       
    	}
    }
}

//りんごのclass
class Apple extends Sprite
{
    private var _angle:Number = 0;
    private var _g:Number = 5;
    private var _add:Number = 0.3;
    private var _prevY:Number=0;
    private var _moveFlg:Boolean;
    private var _center:Point = new Point(275, 600);
	
	private var _speedX:Number = 0;
	private var _speedY:Number = 0;
	
    private var _timer:Timer;
     
    public function Apple()
    {
		super();
        draw();
		this.x = Math.random() * 550;
		this.y = Math.random() * 100;
		_angle =  Math.atan2(_center.y - this.y,_center.x - this.x);
		_speedX = Math.cos(_angle) * 5;
		_speedY = Math.sin(_angle) * 5;
        
        var lifeTime:uint = Math.random()*20000+5000;
        _timer = new Timer(lifeTime, 1);
        _timer.addEventListener(TimerEvent.TIMER, onTimer);
        _timer.start();
    }
    
	//リンゴの大きさ
    private function draw():void
    {
    	with(this.graphics)
    	{
    		beginFill(0xff2222);
			drawCircle(0,0,13);
       	 	endFill();
    	}
    }
    
    private function onTimer(event:TimerEvent):void
    {  
    	_timer.stop();
    	_timer.removeEventListener(TimerEvent.TIMER,onTimer);
    	_timer = null;
        _moveFlg = true;
    }
	
    public function Move():void
    {
    	if(_moveFlg)
    	{
			if (Math.abs(this.x - _center.x) >= 2)this.x += _speedX;
			if (Math.abs(this.y - _center.y) >= 2)this.y += _speedY;
			
			// リンゴの中間～中心軸へ落ちる速さ
			_speedX *= 1.025;
			_speedY *= 1.025;
			
    		//_g += _add;
	    	//this.y += _g;
		    //
	        //if(this.y > 390)
	        //{
	            //this.y = 390;
				//ｇ=重力
	            //_g *= -0.3;
	        //}
	        //if(this.y==_prevY&&this.x<600)
	        //{
	        	//this.x +=3;
	        //}
	        //_prevY = this.y;
	    }
    }
}