/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f3IW
 */

// forked from sekiryou's  [最適化 Tips] 演算した値をインデックスにする際の留意事項
// forked from muta244's [最適化 Tips] 変数名の長さによる処理速度の違い
package {

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;

import flash.geom.Matrix;
public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 0x1000000;
    
    private function _init():void
    {
        _debug(
            "各テスト 0x" + _NUM_TIMES.toString(16) + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n"
        );
        
		var tmpArray:Array = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
		var tmpVector:Vector.<Number> = Vector.<Number>([0, 1, 2, 3, 4, 5, 6, 7, 8, 9]);
        
		_measure(" ループのみ ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
			}
		});
		_measure(" Array[ 2 ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpArray[2];
			}
		});
		_measure(" Array[ 1 + 1 ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpArray[1 + 1];
			}
		});
		_measure(" Array[ int( 1 + 1 ) ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpArray[int(1 + 1)];
			}
		});
		_measure(" Array[ 1 + 1 >> 0 ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpArray[1 + 1 >> 0];
			}
		});
		_measure(" Vector[ 2 ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpVector[2];
			}
		});
		_measure(" Vector[ 1 + 1 ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpVector[1+1];
			}
		});
		_measure(" Vector[ int( 1 + 1 ) ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpVector[int(1+1)];
			}
		});
		_measure(" Vector[ 1 + 1 >> 0 ] ", function ():void {
			for (var i:uint = 0; i < _NUM_TIMES; i++) {
				var result:Number = tmpVector[1 + 1 >> 0];
			}
		});
        
        
        _debug("\n結果については言及しませんので, 各自ご判断ください.");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}
