/**
 * Copyright FlashBum ( http://wonderfl.net/user/FlashBum )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f2XH
 */

package 
{
	import camo.core.events.CamoDisplayEvent;
	import camo.core.property.CamoPropertySheet;
	import camo.core.property.PropertySelector;

	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;

	[SWF(width="480", height="400", frameRate="30", backgroundColor="#333333")]

	public class FlashTest extends Sprite
	{

		//public static const CSS_URL : String = "css/styles.camo.css";
		public static const BASE_IMAGE_PATH:String = "http://demos.flashartofwar.com/CamoExpandingContainers/images/";
		public var imageURLs : Array = new Array( "image_1.jpg", "image_2.jpg", "image_3.jpg" );
		public var containers : Array = new Array( );
		public var display : Sprite;
		private var styleSheet : CamoPropertySheet = new CamoPropertySheet( );
		private var currentContainer : ExpandingContainer;

		/**
		 * 
		 * 
		 */		
		public function FlashTest()
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			
			onCSSLoad();
		}

		/**
		 * 
		 * @param e
		 * 
		 */		
		private function onCSSLoad() : void
		{
			// This is a little trick I use to format css inside of AS code. By putting
			// it inside of XML it retains its formatting and is easier to read.
			// This has nothing to do with the framework, usually you would import
			// the CSS like any normal text file.
			var cssWrapper:XML = <css><![CDATA[
			/* CSS file */

			.ExpandingContainer{
				width: 50px;
				height: 200px;
				background-color: #ffffff;
				margin: 10px;
				y: 10;
				overflow: hidden;
				padding: 10px;
			}
			
			#container0{
				border: 5px solid #00ff00;	
			}
			
			#container1{
				border: 5px solid #ffffff;	
			}
			
			#container2{
				border: 5px solid #ff0000;	
			}
			]]>
			</css>;
			
			styleSheet.parseCSS( cssWrapper.toString() );
			
			startApp( );
		}

		/**
		 * 
		 * 
		 */		
		private function startApp() : void
		{
			display = new Sprite( );
			display.addEventListener( CamoDisplayEvent.DRAW, onRender, false, 0, true );
			display.addEventListener( "open", onOpen, false, 0, true );
			addChild( display );
			
			createContainers( );
		}

		/**
		 * 
		 * @param e
		 * 
		 */		
		private function onOpen(e : Event) : void
		{
			var target : ExpandingContainer = e.target as ExpandingContainer;
			
			if(target == currentContainer)
				currentContainer = null;
				
			if(currentContainer)
				currentContainer.close( );
			
			currentContainer = target;
		}

		/**
		 * 
		 * 
		 */		
		private function createContainers() : void
		{
			var total : Number = imageURLs.length;
			
			for(var i : int = 0; i < total ; i ++)
			{
				var container : ExpandingContainer = new ExpandingContainer( "container" + i );
				display.addChild( container );
				
				var style : PropertySelector = styleSheet.getSelector( "." + container.className, "#" + container.id );
				
				containers.push( container );
				
				container.applyProperties( style );
				container.src = BASE_IMAGE_PATH + imageURLs[i];
			}
	
			onRender( );
		}

		/**
		 * 
		 * @param e
		 * 
		 */		
		public function onRender(e : Event = null) : void
		{
			var total : Number = containers.length;
			var nextX : Number = 0;
			var currentConatiner : ExpandingContainer;
			
			for (var i : int = 0; i < total ; i ++)
			{
				currentConatiner = containers[i];
				currentConatiner.x = currentConatiner.marginLeft + nextX;
				nextX += currentConatiner.width + currentConatiner.marginRight;
			}
		}
	}
}

import flash.system.LoaderContext;
import camo.core.display.CamoDisplay;

import gs.TweenLite;

import flash.display.Bitmap;
import flash.display.Loader;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLRequest;

class ExpandingContainer extends CamoDisplay
{

	public static const OPEN : String = "open";
	public static const CLOSE : String = "close";
	public var expanded : Boolean = false;
	private var loader : Loader = new Loader( );

	/**
	 * 
	 * @param url
	 * 
	 */		
	public function set src(url : String) : void
	{
		loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onSrcLoad, false, 0, true );
		loader.load( new URLRequest( url ), new LoaderContext( true ) );
	}

	/**
	 * 
	 * @param id
	 * 
	 */		
	public function ExpandingContainer(id : String = "expandingContainer")
	{
		this.id = id;
		super( );
		init( );
	}

	/**
	 * 
	 * 
	 */		
	protected function init() : void
	{
		mouseEnabled = true;
		useHandCursor = true;
		addEventListener( MouseEvent.CLICK, onClick, false, 0, true ); 
	}

	/**
	 * 
	 * @param e
	 * 
	 */		
	protected function onClick(e : MouseEvent) : void
	{
		if(expanded)
				close( );
			else
				expand( );
	}

	/**
	 * 
	 * 
	 */		
	public function expand() : void
	{
		removeEventListener( MouseEvent.CLICK, onClick );
		expanded = true;
		TweenLite.to( this, .3, {width: display.width} );
		dispatchEvent( new Event( OPEN, true, true ) );
	}

	/**
	 * 
	 * 
	 */		
	public function close() : void
	{
		expanded = false;
		addEventListener( MouseEvent.CLICK, onClick, false, 0, true );
		TweenLite.to( this, .3, {width:50} );
		dispatchEvent( new Event( CLOSE, true, true ) );
	}

	/**
	 * 
	 * @param e
	 * 
	 */		
	public function onSrcLoad(e : Event) : void
	{
		loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onSrcLoad );
		addChild( Bitmap( loader.content ) );
	}
}