/**
 * Copyright cafecatalyst ( http://wonderfl.net/user/cafecatalyst )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f2WA
 */

// forked from matacat's forked from: フィボナッチの勉強
// forked from _azzip's フィボナッチの勉強
/*
 * フィボナッチの勉強
 * 
 * 数値の変化でどんな感じになるのか見たかったです。
 * 
 * ところどころなんか可愛い動きがあってかわいいですｗｗ
 * 
 */
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	[SWF(width = 465, height = 465, frameRate = 30)]
	
	public class FlashTest extends Sprite
	{
		private const W:Number = stage.stageWidth;
		private const H:Number = stage.stageHeight;
		private const TOTAL_CIRCLES:int = 200;
		private const PHI:Number = Math.PI * 2 * (Math.sqrt(5) + 1) / 2;  // golden ratio
		
		private var circles:Vector.<Circle> = new Vector.<Circle>(TOTAL_CIRCLES, true);
		
		private var count:int = 0;
		private var coef:Number = 1;
		private var delta:Number = 0.001;
		
		private var canvas:Sprite = new Sprite();
		private var tf:TextField = new TextField();
		private var display:BitmapData = new BitmapData(W, H, false, 0x0);
		private var ct:ColorTransform = new ColorTransform(0.75, 0.75, 0.75);
		private var mx:Matrix = new Matrix(1, 0, 0, 1, W / 2, H / 2);
		
		public function FlashTest()
		{
			canvas.filters = [new GlowFilter(0xFFCC00, 0.5, 8, 8)];
			
			tf.defaultTextFormat = new TextFormat("Arial", null, 0xFFFFFF);
			tf.text = "1.000";
			tf.x = W / -2;
			tf.y = H / -2;
			canvas.addChild(tf);
			
			Circle.minSize = 1;
			Circle.maxSize = 5;
			Circle.fieldRadius = W / 2 - 5;
			
			for (var k:int = 0; k < TOTAL_CIRCLES ; k++)
			{
				circles[k] = new Circle((k + 1) / TOTAL_CIRCLES, Math.random() * 0xFFFFFF);
				circles[k].angle = coef * PHI * k;
				canvas.addChild(circles[k]);
			}
			
			addChild(new Bitmap(display));
			
			addEventListener(Event.ENTER_FRAME,enterHandler);
		}
		
		
		private function enterHandler(e:Event):void
		{
			count++;
			if (count >= stage.frameRate) {
				count = 0;
				coef += delta;
				tf.text = coef.toFixed(3);
				
				for (var k:int = 0; k < TOTAL_CIRCLES; k++) {
					circles[k].moveAngleTo(coef * PHI * k);
				}
			}
			
			display.draw(this, null, ct);
			display.draw(canvas, mx);
		}
	}
}


import flash.display.Shape;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.Quad;

class Circle extends Shape
{
	public static var maxSize:Number;
	public static var minSize:Number;
	public static var fieldRadius:Number;
	
	private var radius:Number;
	
	public function Circle(ratio:Number, color:uint)
	{
		super();
		
		graphics.beginFill(color, 0.75);
		graphics.drawCircle(0, 0, (maxSize - minSize) * ratio + minSize);
		
		radius = fieldRadius * ratio;
	}
	
	private var _angle:Number = 0;
	public function get angle():Number { return _angle; }
	public function set angle(v:Number):void
	{
		_angle = v;
		x = Math.cos(angle) * radius;
		y = Math.sin(angle) * radius;
	}
	
	public function moveAngleTo(destAngle:Number):void
	{
		BetweenAS3.to(this, { angle: destAngle }, 0.9, Quad.easeOut).play();
	}
}
