/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f1tE
 */

// forked from okoi's That flower
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    [SWF(width="465", height="465", frameRate="60")]
    
    /**
     * ...
     * @author okoi
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
                
        private var flowerImageData:Array;
        public static const SIZE_25:int = 0;
        public static const SIZE_20:int = 1;
        public static const SIZE_15:int = 2;
        public static const SIZE_10:int = 3;
        public static const SIZE_5:int = 4;
        public static const SIZE_NUM:int = 5;
        
        public static const COLOR_1:int = 0;
        public static const COLOR_2:int = 1;
        public static const COLOR_3:int = 2;
        public static const COLOR_4:int = 3;
        public static const COLOR_5:int = 4;
        public static const COLOR_NUM:int = 5;
        
        
        private var canvas:BitmapData;
        
        private var flowerDataList:/*Array*/Array;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0, 0, WIDTH, HEIGHT);
            this.graphics.endFill();
            
            canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap(canvas) );
            
            InitFlowerData();
            
            addEventListener( Event.ENTER_FRAME, EnterFrameHandler );
        }
        
        private function EnterFrameHandler( e:Event ) : void {
            
            canvas.lock();
            canvas.fillRect( canvas.rect, 0 );
            for ( var z:int = 0; z < 3; z++ ) {
                var num:int = flowerDataList[z].length;
                for ( var i:int = num - 1; i >= 0; i-- ) {
                    var data:FlowerData = flowerDataList[z][i];
                    var image:BitmapData = flowerImageData[data.sizeId][data.colorId][int(data.angle)];
                    canvas.copyPixels( image, image.rect, new Point( data.x, data.y ), null, null, true );
                    
                    data.x += data.mx;
                    data.y += data.my;
                    data.angle = (data.angle - 0.6);
                    if ( data.angle < 0 ) data.angle += 360;
                    data.angle %= 360;
                    
                    if ( data.y < - (data.radius * 2 * 1.6) ) {
                        flowerDataList[z].splice( i, 1 );
                    }
                }
            }
            canvas.unlock();
            
            addFlower();
            addFlower();
        }
        
        private function InitFlowerData() : void {
            
            flowerImageData = new Array(SIZE_NUM);
            for ( var size:int = 0; size < SIZE_NUM; size++ ){
            
                var radius:int;
                if ( size == SIZE_25 ) radius = 25;
                if ( size == SIZE_20 ) radius = 20;
                if ( size == SIZE_15 ) radius = 15;
                if ( size == SIZE_10 ) radius = 10;
                if ( size == SIZE_5 ) radius = 5;
                
                flowerImageData[size] = new Array(COLOR_NUM);
                for ( var c:int = 0; c < COLOR_NUM; c++ ){
                
                    var color:uint;
                    
                    if ( c == COLOR_1 ) color = 0xF47EB9;
                    if ( c == COLOR_2 ) color = 0xFF7D69;
                    if ( c == COLOR_3 ) color = 0xFBD1DC;
                    if ( c == COLOR_4 ) color = 0xF65A67;
                    if ( c == COLOR_5 ) color = 0xF9E1BE;
                    
                    var flower:Flower = new Flower( radius, color );
                    
                    flowerImageData[size][c] = new Array(360);
                    for ( var a:int = 0; a < 360; a++ ) {
                        //flower.rotation = a;
                        var mat:Matrix = new Matrix(1, 0, 0, 1);
                        mat.rotate( a * Math.PI / 180 );
                        mat.translate( radius * 1.6, radius * 1.6 );
                        var bmd:BitmapData = new BitmapData( radius * 2 * 1.6, radius * 2 * 1.6, true, 0 );
                        bmd.draw( flower, mat );
                        
                        flowerImageData[size][c][a] = bmd;
                    }
                }
            }
            
            //    データの入れ物初期化
            flowerDataList = new Array(3);
            flowerDataList[0] = [];
            flowerDataList[1] = [];
            flowerDataList[2] = [];
        }
        
        private function addFlower() : void {
            
            
            var rand:int; 
            var data:FlowerData = new FlowerData();
            
            //    Z階層を設定
            rand = Math.random() * 60;
            var z:int;
            if ( rand < 57 )      z = 0;
            else if ( rand < 59 ) z = 1;
            else                   z = 2;
            
            //    サイズを決定
            rand = Math.random() * 10;
            var size:int;
            var radius:int;
            if ( z == 0 ) {
                if ( rand < 5 )      { size = SIZE_5;  radius = 5;    }
                else if ( rand < 8 ) { size = SIZE_10; radius = 10; }
                else                 { size = SIZE_15; radius = 15; }
            }else
            if ( z == 1 ) {
                if ( rand < 5 )         { size = SIZE_10; radius = 10; }
                else if ( rand < 8 ) { size = SIZE_15; radius = 15; }
                else                  { size = SIZE_20; radius = 20; }
            }else {
                size = SIZE_25;
                radius = 25;
            }
            
            //    色を決定
            var color:int = Math.random() * COLOR_NUM;
            
            //    初期座標
            var x:Number = Math.random() * (WIDTH + radius * 2) - radius;
            var y:Number = HEIGHT + radius * 2;
            
            //    移動速度
            var mx:Number = (Math.random() - 0.5) * 0.2;
            var my:Number;
            rand = Math.random() * 10;
            if ( size == SIZE_5 ) {
                if ( rand < 5 ) my = -2;
                else            my = -1;
            }else
            if ( size == SIZE_10 ) {
                if ( rand < 5 ) my = -1.5;
                else            my = -1;                
            }else
            if ( size == SIZE_15 ) {
                if ( rand < 5 ) my = -1.5;
                else            my = -1;                                
            }else
            if ( size == SIZE_20 ) {
                my = -1;
            }else
            if ( size == SIZE_25 ) {
                my = -1;
            }
            
            data.angle = 0;
            data.x = x;
            data.y = y;
            data.z = z;
            data.mx = mx;
            data.my = my;
            data.sizeId = size;
            data.colorId = color;
            data.radius = radius;
            
            flowerDataList[z].push( data );
        }
    }
    
}
import flash.display.Graphics;
import flash.display.Shape;

class FlowerData {
    public var sizeId:int;
    public var colorId:int;
    public var angle:Number;
    public var x:Number;
    public var y:Number;
    public var z:Number;
    
    public var mx:Number;
    public var my:Number;
    
    public var radius:int;
}

class Flower extends Shape
{
    //    各花びらの１枚の専有角度
    public static const PETALANGLE:Array = [ 62, 82, 72, 72, 72 ];
    //    花びら１枚に対しての各クォーターの専有角度率
    public static const QUARTERRATE:Array = [ 0.3, 0.15, 0.25, 0.3 ];
    
    public function Flower( radius:Number, color:uint = 0x555555 ) 
    {
        Create( radius, color );
    }
    
    public function Create( radius:Number, color:uint ):void 
    {
        var i:int, p:int;
        var tmp1:int, tmp2:int;
        var t1:Number, t2:int;
        var sin45:Number = Math.sin( 45 * Math.PI / 180 );

        graphics.beginFill( color );

        // 花びら１枚１枚のパラメータを決定する
        var petalAngles:Array = PETALANGLE;
        var rOffset:Array = [];
        var rOffset2:Array = [];

        for ( p = 0; p < 4; p++ ) {

            rOffset.push( Math.random() * 0.2 - 0.1 + 0.5 );
            rOffset2.push( Math.random() * 0.2 + 0.8 );

        }
        //petalAngles.push( 360 - totalAngle );
        rOffset.push( Math.random() * 0.2 - 0.1 + 0.5 );
        rOffset2.push( Math.random() * 0.2 + 0.8 );

        // 各クォーターの専有角度
        var quarterRate:Array = QUARTERRATE;

        // 花びら１枚１枚描画していく
        var startAngle:int = 0;
        for ( p = 0; p < 5; p++ ) {
            for ( i = 0; i <= petalAngles[p]; i++ ) {

                var rad:Number = (startAngle + i) * Math.PI / 180;
                // 基本位置
                var x:Number = Math.cos( rad ) * radius;
                var y:Number = Math.sin( rad ) * radius;

                //
                var quarter:int;
                var quarterStartRate:Number = 0;
                var nowrate:Number = i / petalAngles[p];
                t1 = 0;
                for ( quarter = 0; quarter < 4; quarter++ ) {
                    t1 += quarterRate[quarter];
                    if ( nowrate < t1 ) {
                        break;
                    }
                    quarterStartRate += quarterRate[quarter];
                }
                quarter %= 4;

                var r:Number;
                var rate:Number = (nowrate - quarterStartRate) / quarterRate[quarter];
                rate *= 90; // 1Qで90度分の角度変化を行う

                // Q-0
                // startY 0
                // endY sin45θ
                if ( quarter == 0 ) {
                    rad = (rate) * Math.PI / 180;
                    r = Math.abs( Math.sin( rad ) ) * sin45;
                }
                // Q-1
                // startY sin45θ
                // endY sin90θ
                if ( quarter == 1 ) {
                    rad = (rate + 90) * Math.PI / 180;
                    //trace( Math.abs( Math.sin( rad ) ) );
                    r = (1 - Math.abs( Math.sin( rad ) ) ) * (1 - sin45) * 0.4 + sin45;
                }
                // Q-2
                // startY sin90θ
                // endY sin45θ
                if ( quarter == 2 ) {
                rad = rate * Math.PI / 180;
                r = (1 - Math.abs( Math.sin( rad ) )) * (1 - sin45) * 0.4 + sin45;

                }
                // Q-3
                // startY sin45θ
                // endY 0
                if ( quarter == 3 ) {
                    rad = (rate + 90) * Math.PI / 180;
                    r = Math.abs( Math.sin( rad ) ) * sin45;
                }

                //
                r += rOffset[p];
                x *= r;
                y *= r * 0.9;

                if ( p == 0 && i == 0 ) graphics.moveTo(x, y);
                else graphics.lineTo(x, y);
            }
            startAngle += petalAngles[p];
            
        }
        
        graphics.endFill();
    }
}