/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f1jf
 */

// forked from shohei909's pixels photo veiwer
// forked from shohei909's にょろにょろした何か _30000 worms
package {
    import net.hires.debug.Stats;
    import flash.geom.Matrix;
    import flash.system.LoaderContext;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.display.*;
   
    
    public class MediaRSSReader extends Sprite {
        private var _feed:String = "http://api.flickr.com/services/feeds/photos_public.gne?format=rss_200";
        private var tags:Array = ["colorful"]
        private var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");
        private var ldr:Array = [];
        private var index:int = 0;
        private var thumb:Sprite = new Sprite;
        private var bitmapData:BitmapData;
        public function MediaRSSReader() {
            var ldr:URLLoader = new URLLoader;
            ldr.addEventListener(Event.COMPLETE, function _load(e:Event):void {
                ldr.removeEventListener(Event.COMPLETE, _load);
                onImageLoaded(XML(ldr.data)..media::thumbnail.@url.toXMLString().split('\n'));
            }); 
            ldr.load(new URLRequest(_feed + "&tags=" +tags[ int(tags.length*Math.random()) ]));
        }
        
        private function onImageLoaded($images:Array):void {
            bitmapData = new BitmapData(465,465,true,0xFF000000);
            
            for (var i:int = 0; i < $images.length; ++i) {
                ldr[i] = new Loader;
                //Loaderで読み込んだ画像を後でBitmapDataに書き込む場合
                //第二引数にnew LoaderContext(true)を指定する必要があります
                ldr[i].load(new URLRequest($images[i]), new LoaderContext(true));
                
                ldr[i].contentLoaderInfo.addEventListener(Event.COMPLETE, function _load(e:Event):void {
                    var tgt:Loader = e.currentTarget.loader;
                    e.currentTarget.removeEventListener(Event.COMPLETE, _load);
                    setThumb();
                });
            }
            addChild(new PixelMap(bitmapData) );
            addChild( thumb );
            thumb.x =3; thumb.y =3; 
            index = 0;
            stage.addEventListener("mouseDown",onDown);
        }
        private function setThumb():void{
            while(thumb.numChildren > 0){thumb.removeChildAt( 0 );}
            thumb.addChild( ldr[index] );
            bitmapData.draw( ldr[index], new Matrix(6,0,0,6,7,7) );
        }
        private function onDown(e:Event):void{
            index++;
            index %= ldr.length;
            setThumb();
        }
    }
}
import flash.geom.Rectangle;
import flash.filters.BlurFilter;
import flash.events.Event;
import flash.geom.Point;
import flash.display.BitmapData;
import flash.display.Bitmap;


class PixelMap extends Bitmap{
    private var back:BitmapData;
    private var target:BitmapData;
    private var size:int = 12000;
    private var bitmapFilters:Array = [new BlurFilter(4,4)];
    private var pixels:Vector.<Pixel> = new Vector.<Pixel>();
    
    function PixelMap(tar:BitmapData):void{
        target = tar;
        var width:int = tar.width;  
        var height:int = tar.height;
        size = (width) * (height) / 8
        back = new BitmapData(width,height,false,0x000000);
        super( new BitmapData(width,height,false,0x000000) );
        this.addEventListener("enterFrame",onFrame);
        var colorArr:Array = [0xFF0000,0xFF00,0xFF]
    }
    
    private function onFrame(e:Event):void { add(); drow(); move();  }
    private function drow():void{
        var b:BitmapData = bitmapData;
        b.lock();
        b.merge(back,b.rect,new Point(),1,1,1,255);
        for each( var filter:BlurFilter in bitmapFilters ){
            b.applyFilter(b,b.rect,new Point(),filter)
        }
        for each( var pixel:Pixel in pixels ){
            pixel.draw( b );
        }
        b.unlock();
    }
    
    private function move():void{
        var mx:int = mouseX;
        var my:int = mouseY;
        var b:BitmapData = target;
        var rect:Rectangle = bitmapData.rect;
        for each( var pixel:Pixel in pixels ){
            pixel.move();
        }
    }
    
    private function add():void {
        var x:int; var y:int; var tcolor:uint; var bcolor:uint; var count:int = 0; 
        var b:BitmapData = back;
        var t:BitmapData = target;
        var mx:int = mouseX;
        var my:int = mouseY;
        var w:int = width/2
        var h:int = height/2
        while (count < 5000) {
            x = Math.floor(w * Math.random())*2;
            y = Math.floor(h * Math.random())*2;
            tcolor = t.getPixel(x, y);
            bcolor = b.getPixel(x, y);
            if (tcolor != bcolor) {
                var pixel:Pixel = new Pixel(pixels, mx, my, tcolor);
                pixel.tarX = x; pixel.tarY = y;
                b.setPixel( x, y, tcolor );
                count+=10
            }else{
                count++;
            }
            if (pixels.length > size) { pixels.splice(0, 10); }
        }
    }
}



class Pixel{
    public var x:Number, y:Number;
    public var tarX:int, tarY:int;
    public var speed:int = 16;
    private var parent:Vector.<Pixel> = new Vector.<Pixel>();
    private var green:uint,blue:uint,red:uint,color:uint;
    
    public function Pixel(target:Vector.<Pixel>,x:int,y:int,color:uint){
        parent = target;
        parent.push( this );
        this.x = x; this.y = y;
        setColor(color);
    }
    public function draw( data:BitmapData ):void{ data.setPixel(x,y,color); }
    public function move():void { 
        x = (x*(speed-1) + tarX) / speed; y = (y*(speed-1) + tarY) / speed;
        if(int(x) == tarX && int(y) == int(tarY) ){ remove }
    }
    public function remove():void{ parent.splice(parent.indexOf(this),1); }
    public function setColor( color:uint ):void{
        this.color = color;
        red = color >>> 16;
        green = (color - red) >>> 8
        blue = (color - red - green)
    } 
    
    public function difference( color:uint ):uint{
        var red:uint = color >>> 16;
        var green:uint = (color - red) >>> 8
        var blue:uint = (color - red - green)
        if( Math.abs(red - this.red) + Math.abs(green - this.green) + Math.abs(blue - this.blue) > 0xFF){
            return 10;
        }else{
            return 1;
        }
    }
}
