/**
 * Copyright mex_ichikawa ( http://wonderfl.net/user/mex_ichikawa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f0xv
 */

/* 
 * AS100本ノック
 * 4回目のお題は「オータム（秋）」
 * あなたなりの「オータム（秋）」を表現してください。
 * --
 * ごめんなさい。葉っぱが不自然に落ちるだけです。
 */
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.utils.Timer;
	[SWF(width=465, height=465, backgroundColor=0xFFFFFF, frameRate=30)]
	public class Autumn extends Sprite
	{
		private static const REQUEST_IMAGE:String="http://farm4.static.flickr.com/3240/3006458129_94629d78ee.jpg";
		public static const STAGE_WIDTH:uint = 465;
		public static const STAGE_HEIGHT:uint = 465;
		private var _timer:Timer;
		private var _imgLoader:Loader;

		public function Autumn()
		{
			init();
		}
		private function init():void
		{
			var request:URLRequest = new URLRequest(REQUEST_IMAGE);
			var context:LoaderContext = new LoaderContext(true);
			_imgLoader = new Loader();
			_imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
			try
			{
				_imgLoader.load(request, context);
			} catch (error:Error) {
				trace("image load failed.");
			}
		}
		private function completeHandler(event:Event):void
		{
			var bmd:BitmapData, bm:Bitmap;
			bmd = new BitmapData(_imgLoader.width, _imgLoader.height, true, 0x00FFFFFF);
			bmd.draw(_imgLoader);
			bm = new Bitmap(bmd);
			if(bm.width > bm.height)
			{
				bm.width = STAGE_WIDTH * (STAGE_HEIGHT / bm.height);
				bm.height = STAGE_HEIGHT;
			}
			else
			{
				bm.height = STAGE_HEIGHT * (STAGE_WIDTH / bm.width);
				bm.width = STAGE_WIDTH;
			}
			addChild(bm);
			
			_timer = new Timer(500, 0);
			_timer.addEventListener(TimerEvent.TIMER, timerHandler);
			_timer.start();
		}
		private function timerHandler(event:TimerEvent=null):void
		{
			var s:Sprite = new Leaf();
			this.addChild(s);
		}
		
	}
}
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.events.Event;
import flash.net.URLRequest;
import flash.display.Sprite;
import flash.system.LoaderContext;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.events.*;
import org.libspark.betweenas3.tweens.ITween;
class Leaf extends Sprite {
	private static const REQUEST_IMAGE:String="http://farm3.static.flickr.com/2556/4066961851_b67484925f_o.png";
	private static const MOVE_WIDTH:uint = 400;
	private static const MOVE_HEIGHT:uint = 200;
	private static const MARGIN_HEIGHT:uint = 150;
	private static const DELETE_TIME:uint = 30;
	private static const MOVE_TIME:uint = 3;
	private static var BMD:BitmapData;
	private var _imgLoader:Loader;
	private var _sizeX:int;
	private var _sizeY:int;
	private var _time:Number;
	private var _ITween:ITween;
	private var _preX:Number;
	private var _preY:Number;
	private var _dropFlg:Boolean;
	public function Leaf()
	{
		init();
	}
	public function init():void
	{
		x = Math.random() * Autumn.STAGE_WIDTH;
		y = Math.random() * -Autumn.STAGE_HEIGHT;
		_sizeX = (Math.random() + 0.5) * MOVE_WIDTH * (Math.random() > 0.5 ? -1 : 1);
		_sizeY = MOVE_HEIGHT;
		_time = (Math.random() + 0.5) * MOVE_TIME;
		if(Leaf.BMD)
		{
			completeHandler();
		}
		else
		{
			var request:URLRequest = new URLRequest(REQUEST_IMAGE);
			var context:LoaderContext = new LoaderContext(true);
			_imgLoader = new Loader();
			_imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeHandler);
			try
			{
				_imgLoader.load(request, context);
			} catch (error:Error) {
				trace("image load failed.");
			}
		}
	}
	private function completeHandler(event:Event=null):void
	{
		if(!Leaf.BMD)
		{
			var bmd:BitmapData = new BitmapData(_imgLoader.width, _imgLoader.height, true, 0x00FFFFFF);
			bmd.draw(_imgLoader);
			Leaf.BMD = bmd;
		}
		var bm:Bitmap = new Bitmap(Leaf.BMD);
		bm.scaleX = bm.scaleY = (Math.random() * 0.4 + 0.8);
		bm.x = bm.width / 2;
		bm.y = bm.height / 2;
		addChild(bm);
		playTween();
	}
	private function playTween(event:TweenEvent=null):void
	{
		var _t:ITween = makeTween();
		if(_dropFlg)
		{
			_t.addEventListener(TweenEvent.COMPLETE, dropLeaf);
		}
		else
		{
			_t.addEventListener(TweenEvent.COMPLETE, playTween);
			_t.addEventListener(TweenEvent.UPDATE, updateAngle);
			
		}
		_t.play();
	}
	private function updateAngle(event:TweenEvent):void
	{
		var dx:Number = (_sizeX > 0 ? x - _preX : _preX - x);
		var dy:Number = (_sizeX > 0 ? y - _preY : _preY - y);
//		var dr:Number = Math.atan2(dy, dx) * 180 / Math.PI;
		_preX = x;
		_preY = y;
	}
	private function makeTween():ITween
	{
		_sizeX *= -1;
		var tgX:int = x + _sizeX;
		var tgY:int = y + (_sizeY * (Math.random() * 0.4 + 0.8));
		var _t:ITween = BetweenAS3.parallel(
			BetweenAS3.tween(
				this,
				{x: tgX},
				null,
				_time,
				Sine.easeInOut
			),
			BetweenAS3.tween(
				this,
				{y: tgY},
				null,
				_time,
				Back.easeInOut
			)
		);
		if(tgY > Autumn.STAGE_HEIGHT - MARGIN_HEIGHT)
		{
			_t = BetweenAS3.serial(
				_t,
				BetweenAS3.tween(
					this,
					{alpha: 0},
					null,
					DELETE_TIME,
					Sine.easeInOut
				)
			);
			_dropFlg = true;
		}
		return _t;
	}
	private function dropLeaf(event:TweenEvent):void
	{
		this.parent.removeChild(this);
	}
}
