/**
 * Copyright soundkitchen ( http://wonderfl.net/user/soundkitchen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f0fG
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.IOErrorEvent;
    import flash.events.SecurityErrorEvent;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;

    import org.si.sion.SiONDriver;
    import org.si.sion.events.SiONTrackEvent;
    import org.si.sion.sequencer.SiMMLTrack;
    import org.si.sion.utils.SiONPresetVoice;

    /**
     *
     */
    [SWF(width=465, height=465, frameRate=48, backgroundColor=0xFFFFFF)]
    public class Main extends Sprite
    {
        public static const IMAGE_URL:String = 'http://a2.twimg.com/profile_images/1258323989/twitter_icon_newyear5.png';
        public static const BASE_NOTE:int = 63;
        public static const BPM:int = 120;

        private var bitmapData:BitmapData;
        private var driver:SiONDriver;
        private var voices:SiONPresetVoice;

        private var notes:Array = [1, 3, 5, 6, 8, 10, 12];

        public function Main()
        {
            addEventListener(Event.ADDED_TO_STAGE, initialize);
        }

        private function initialize(evt:Event):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, initialize);

            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            var req:URLRequest = new URLRequest(IMAGE_URL);
            var ctx:LoaderContext = new LoaderContext(true);
            var loader:Loader = new Loader();
            var info:LoaderInfo = loader.contentLoaderInfo;
            info.addEventListener(Event.COMPLETE, onLoadComplete);
            info.addEventListener(IOErrorEvent.IO_ERROR, trace);
            info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, trace);

            loader.load(req, ctx);
        }

        /**
         *
         */
        private function onLoadComplete(evt:Event):void
        {
            var info:LoaderInfo = LoaderInfo(evt.target);
            var loader:Loader = info.loader;

            info.removeEventListener(Event.COMPLETE, onLoadComplete);
            info.removeEventListener(IOErrorEvent.IO_ERROR, trace);
            info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, trace);

            bitmapData = new BitmapData(loader.width, loader.height, true, 0);
            bitmapData.draw(loader, loader.transform.matrix);
            loader.unload();

            driver = new SiONDriver();
            driver.bpm = BPM;
            driver.addEventListener(SiONTrackEvent.BEAT, onBeat);
            driver.setBeatCallbackInterval(1);
            driver.play();

            voices = new SiONPresetVoice();
        }

        private function onBeat(evt:SiONTrackEvent):void
        {
            if (Math.random() < .6) return;

            var marker:Marker = new Marker(bitmapData);
            marker.x = int(Math.random() * stage.stageWidth);
            marker.y = int(Math.random() * stage.stageHeight);
            addChild(marker);

            var o:int = Math.random() >= .5 ? 2 : 1;
            var i:int = int(Math.random() * notes.length);

            var track:SiMMLTrack = driver.noteOn(BASE_NOTE + notes[i] * o, voices['sine'], 4);
            track.velocity = marker.scale * 120;
            track.pan = (marker.x / stage.stageWidth) * 128 - 64;
        }
    }
}

import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.ITween;

class Marker extends Sprite
{
    private var tween:ITween;
    public var scale:Number;

    public function Marker(data:BitmapData)
    {
        var bitmap:Bitmap = new Bitmap(data);
        bitmap.smoothing = true;
        bitmap.x -= bitmap.width >> 1;
        bitmap.y -= bitmap.height >> 1;
        addChild(bitmap);

        scaleX = scaleY = 0;
        scale = Math.random();

        addEventListener(Event.ADDED_TO_STAGE, initialize);
    }

    private function initialize(evt:Event):void
    {
        var ord:int = Math.random() >= .5 ? 1 : -1;

        tween = BetweenAS3.serial(
            BetweenAS3.tween(this, {
                'scaleX': scale,
                'scaleY': scale,
                'rotation': 0
            }, {
                'rotation': Math.random() * 180 * ord
            }, 1, Elastic.easeOut),
            BetweenAS3.to(this, {
                'scaleX': 0,
                'scaleY': 0
            }, .3, Back.easeIn),
            BetweenAS3.removeFromParent(this)
        );
        tween.play();
    }
}
