/**
 * Copyright telcanty ( http://wonderfl.net/user/telcanty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/f0dw
 */

package{
    /*
    
        Heya, Love!

    */
    
    import flash.display.Sprite;
    
    import flash.events.Event;
    
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    
    public class Main extends Sprite
    {
        
        public var halfWidth:Number = stage.stageWidth / 2;
        
        public var lovingOptions:Array = new Array(
                "Cuddle Bunny",
                "Silly Girl",
                "Darling",
                "My Delight",
                "Delicatessen",
                "Sexy Moma",
                "Beautiful",
                "Luscious",
                "Ms. Cash",
                "Sweetheart",
                "Love"
                );
        public var lovingOptionNum:int = Math.random()*lovingOptions.length - 1;
        public var lovingOption:String = lovingOptions[lovingOptionNum];
        
        public var maxScale:Number = 6.2;
        public var minScale:Number = .2;
        public var textOffset:Number = 30;

        public var heartFormat:TextFormat = new TextFormat();
        public var heartText:TextField = new TextField();
        public var happyFormat:TextFormat = new TextFormat();
        public var happyText:TextField = new TextField();
        public var loveFormat:TextFormat = new TextFormat();
        public var loveText:TextField = new TextField();
        public var bgrdColor:Number = 0xFFFFFF * Math.random();
        public var bgrd:Sprite = new Sprite();
        
        public var scaleIncrement:Number = .2;
        public var majorUpdateFrame:Number = 30;    // frameRate on 30
        public var currentUpdateFrame:Number = 0;
    
        public function Main():void
        {
            _init();
        }
        
        public function Update(e:Event = null):void
        {
            // DO MAJOR UPDATE IF NECESSARY
                if(currentUpdateFrame >= majorUpdateFrame)
                {
                    // CHANGE SAYING
                        lovingOptionNum = Math.random()*lovingOptions.length - 1;
                        lovingOption = lovingOptions[lovingOptionNum];
                        loveText.text = String(lovingOption).toUpperCase();
                    // RESET CURRENT UPDATE
                        currentUpdateFrame = 0;
                }else{
                    currentUpdateFrame++;
                }
                
            // DRAW BACKGROUND
                bgrd.graphics.beginFill(0xFFFFFF * Math.random());
                bgrd.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
                bgrd.graphics.endFill();
                
            // RANDOMIZE COLOR
                heartFormat.color = 0xFFFFFF*Math.random();
                heartText.setTextFormat(heartFormat);
            
            // ITERATE SIZING
                heartText.scaleX = heartText.scaleY += scaleIncrement;
                if((heartText.scaleX >= maxScale)||(heartText.scaleX <= minScale))
                {
                    scaleIncrement *= -1;
                }
            
            // REPOSITION ITEMS
                heartText.x = halfWidth - heartText.textWidth / 2 * heartText.scaleX;
                heartText.y = stage.stageHeight / 2 - heartText.textHeight / 2 * heartText.scaleY + textOffset - textOffset / 2;
                happyText.x = halfWidth - happyText.textWidth / 2;
                happyText.y = heartText.y - textOffset;
                loveText.x = halfWidth - loveText.textWidth / 2;
                loveText.y = heartText.y + heartText.textHeight * heartText.scaleY - textOffset;
        }
        
        public function PositionObjects():void
        {
            
        }
        
        private function _init():void
        {
            // HEART TEXT
                heartFormat.size = 100;
                heartFormat.color = 0x000000;
        
                heartText.defaultTextFormat = heartFormat;
                heartText.autoSize = TextFieldAutoSize.LEFT;
                heartText.text = "❤";
                heartText.selectable = false;
                heartText.scaleX = heartText.scaleY = minScale;

        
            // HAPPY TEXT
                happyFormat.size = 20;
                happyFormat.color = 0xFFFFFF;
        
                happyText.defaultTextFormat = happyFormat;
                happyText.autoSize = TextFieldAutoSize.LEFT;
                happyText.text = String("Happy Birthday").toUpperCase();
                happyText.selectable = false;

            // HAPPY LOVE
                loveFormat.size = 20;
                loveFormat.color = 0xFFFFFF;
            
                loveText.defaultTextFormat = loveFormat;
                loveText.autoSize = TextFieldAutoSize.LEFT;
                loveText.text = String(lovingOption).toUpperCase();
                loveText.selectable = false;
                
            // STAGE ADDITIONS
                addChild(bgrd);
                addChild(happyText);
                addChild(heartText);
                addChild(loveText);
            
            // START UPDATE
                addEventListener(Event.ENTER_FRAME, Update);
                Update();
        }
    }
}