/**
 * Copyright gs1mm0ns ( http://wonderfl.net/user/gs1mm0ns )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ez3x
 */

// forked from dbeermann's Simple Mouse Followers
package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]
    
    
    public class MouseFollow extends Sprite
    {
        private var _position:Dot;
        private var _redFollower:Dot;
        private var _greenFollower:Dot;
        private var _blueFollower:Dot;


        public function MouseFollow()
        {
            // setup stage
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            // build mouse position marker
            _position = new Dot( 12, 0x222222 );
            addChild( _position );

            // build red mouse follower
            _redFollower = new Dot( 30, 0xFF0000 );
            _redFollower.blendMode = BlendMode.ADD;
            addChildAt( _redFollower, 0 );

            // build green mouse follower
            _greenFollower = new Dot( 30, 0x00FF00 );
            _greenFollower.blendMode = BlendMode.ADD;
            addChildAt( _greenFollower, 0 );
			
            // build blue mouse follower
            _blueFollower = new Dot( 30, 0x0000FF );
            _blueFollower.blendMode = BlendMode.ADD;
            addChildAt( _blueFollower, 0 );
            
            // setup stats.
            addChild( new Stats() );
            	
            // add listener to mouse movement
            addEventListener( Event.ENTER_FRAME, handleEnterFrame );
        }
        
        private function handleEnterFrame(event:Event):void
	{
            _position.x = mouseX;
            _position.y = mouseY;


            // ----------------------------------------------
            //		Follow code for red dot
            // ---------------------------------------------- 
            _redFollower.x += (mouseX - _redFollower.x) * .15;
            _redFollower.y += (mouseY - _redFollower.y) * .15;


            // ----------------------------------------------
            //		Follow code for green dot
            // ---------------------------------------------- 
            var gDistanceX:Number = mouseX - _greenFollower.x;
            var gDistanceY:Number = mouseY - _greenFollower.y;

            var gDistance:Number = Math.sqrt( Math.pow(gDistanceX,2) + Math.pow(gDistanceY,2) );
            var gRadians:Number = Math.atan2( gDistanceY, gDistanceX );

            _greenFollower.velocityX += Math.cos( gRadians ) * gDistance;
            _greenFollower.velocityY += Math.sin( gRadians ) * gDistance;

            _greenFollower.velocityX *= .6;
            _greenFollower.velocityY *= .6;

            _greenFollower.x += _greenFollower.velocityX;
            _greenFollower.y += _greenFollower.velocityY;


            // ----------------------------------------------
            //		Follow code for blue dot
            // ---------------------------------------------- 
            var bDistanceX:Number = mouseX - _blueFollower.x;
            var bDistanceY:Number = mouseY - _blueFollower.y;

            var bDistance:Number = Math.sqrt( Math.pow(bDistanceX,2) + Math.pow(bDistanceY,2) ) * .2;
            var bRadians:Number = Math.atan2( bDistanceY, bDistanceX );

            _blueFollower.velocityX += Math.cos( bRadians ) * bDistance;
            _blueFollower.velocityY += Math.sin( bRadians ) * bDistance;

            _blueFollower.velocityX *= .7;
            _blueFollower.velocityY *= .7;

            _blueFollower.x += _blueFollower.velocityX;
            _blueFollower.y += _blueFollower.velocityY;
        }
    }
}


import flash.display.Shape;

internal class Dot extends Shape
{
    private var _velocityX:Number = 0;
    private var _velocityY:Number = 0;
    private var _size:uint;
    private var _color:uint;

	
    public function Dot( size:uint, color:uint )
    {
        _size = size;
        _color = color;
        
        draw( );
	}
	
    private function draw():void
    {
        this.graphics.beginFill( _color );
        this.graphics.drawCircle( 0, 0, _size );
        this.graphics.endFill( );
    }

    public function get velocityX():Number
    {
        return _velocityX;
    }

    public function set velocityX(velocityX:Number):void
    {
        _velocityX = velocityX;
    }

    public function get velocityY():Number
    {
        return _velocityY;
    }
    
    public function set velocityY(velocityY:Number):void
    {
        _velocityY = velocityY;
    } 
}