/**
 * Copyright takashi08 ( http://wonderfl.net/user/takashi08 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eysq
 */

// forked from clockmaker's [JigLibFlash] Meteor
package {
    import caurina.transitions.*;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.utils.*;
    import jiglib.physics.*;
    import jiglib.plugin.papervision3d.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;

    [SWF(width="465",height="465",frameRate="45",backgroundColor="0x0")]
    public class Main extends BasicView {

        public static const MAX_ITEMS:int = 30;
        public static const GROUND_SIZE:int = 5000;
        public static const GROUND_HEIGHT:int = 700;

        private var spehres:Vector.<RigidBody>;
        private var physics:Papervision3DPhysics;
        private var count:int = 0;
        private var light:PointLight3D;

        public function Main(){
            // 初期設定
            stage.quality = StageQuality.LOW;
            opaqueBackground = 0x0;
            super(465, 465, false, false);

            // カメラの位置
            camera.y = 700;

            // 3Dの物理エンジン
            physics = new Papervision3DPhysics(scene, 10);

            // 地面を作成
            light = new PointLight3D();
            var groundMat:FlatShadeMaterial = new FlatShadeMaterial(light, 0x222222, 0x000000);

            // パーリンノイズででこぼこ作成
            var bmd:BitmapData = new BitmapData(100, 100, true, 0x0);
            bmd.lock();
            bmd.perlinNoise(20, 20, 1, 1, true, false, 7, true);
            bmd.applyFilter(bmd, bmd.rect, new Point(), new GlowFilter(0xFFFFFF, 1, 16, 16, 5, 3, true));
            bmd.unlock();

            // でこぼこ
            var ground:RigidBody = physics.createTerrain(bmd, groundMat, GROUND_SIZE, GROUND_SIZE, GROUND_HEIGHT, 20, 20);
            ground.friction = 0.1;
            ground.restitution = 0.8;
            ground.y = -GROUND_HEIGHT;

            //　球体のテクスチャ
            var wireFrameMat:FlatShadeMaterial = new FlatShadeMaterial(light, 0x444444);

            spehres = new Vector.<RigidBody>();
            for (var i:int = 0; i < MAX_ITEMS; i++) {
                var size:Number = 200 * Math.random() + 20;
                var segment:uint = Math.sqrt(size) / 2;
                var rigidBody:RigidBody = physics.createSphere(wireFrameMat, size, segment, segment-1);
                rigidBody.restitution = 0.5;
                rigidBody.friction = 0.5;
                rigidBody.moveTo(new Vector3D(GROUND_SIZE / 2 * (Math.random() - 0.5), 1000, GROUND_SIZE / 2 * (Math.random() - 0.5)));
                spehres[i] = rigidBody;
            }

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            startRendering();

            var timer:Timer = new Timer(500);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }

        private function enterFrameHandler(e:Event = null):void {
            // 角度に応じてカメラの位置を設定
            var msec:Number = getTimer();
            camera.x = 1500 * Math.sin(msec / 2000);
            camera.z = 1500 * Math.cos(msec / 2000);
            camera.y = 300 * Math.sin(msec / 2500) + 400;
            camera.fov = 10 * Math.sin(msec / 3000) + 80;

            light.copyPosition(camera);

            // 物理演算
            physics.engine.integrate(0.75);
        }

        private function timerHandler(e:TimerEvent = null):void {
            var rigidBody:RigidBody = spehres[count];
            var shpere:DisplayObject3D = (rigidBody.skin as Pv3dMesh).mesh as DisplayObject3D;

            Tweener.addTween(shpere, { scale: 0, 
                time: 0.9, 
                transition: "easeInExpo", 
                onComplete: function():void {
                    shpere.scale = 1;
                    var force:Number = (Math.random() - 0.5) * 200;
                    rigidBody.moveTo(new Vector3D(0, 2000, 0));
                    rigidBody.addBodyForce(new Vector3D(force, 0, force), new Vector3D(force, 0, force));
                }})

            count++;
            if (count > spehres.length - 1)
                count = 0;
        }
    }
}