/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eyLP
 */

/*
Bitmapにstageの絵柄を書き込む。
直前に描いた画像をちょっとずつ暗くすると、
残像が残ったようにみえる。

*/
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	
	import caurina.transitions.Tweener;

	public class Main extends Sprite {
		private var _sp:Sprite;
		private var _bitmap:Bitmap;
		private var _colorTransform:ColorTransform;

		public function Main() {
			
			_sp = new Sprite();
			_sp.graphics.beginFill(0xFF0000,1);
			_sp.graphics.drawRect(100,0,100,100);
			_sp.graphics.endFill();
			_sp.x=stage.stageWidth/2;
			_sp.y=stage.stageHeight/2;
			this.addChild(_sp);
			
			//bitmapの表示エリアを作っている。
			var bitmapData:BitmapData=new BitmapData(stage.stageWidth,stage.stageHeight);
			_bitmap=new Bitmap(bitmapData);
			this.addChild(_bitmap);
			
			//変色の内容。ちょっとだけ暗くしている。
			_colorTransform = new ColorTransform(1, 1, 1, 1, -0x5, -0x5, -0x5);
			
			this.addEventListener(Event.ENTER_FRAME,onEnter);
		}
		
		private function onEnter(event:Event):void {
			//Spriteを回転
			_sp.rotation++;
			
			//一度、真っ白に戻している。
			//_bitmap.bitmapData.fillRect(_bitmap.bitmapData.rect,0xFFFFFF);
			//前に描いた画像を変色している。
			_bitmap.bitmapData.colorTransform(_bitmap.bitmapData.rect,_colorTransform);
			//_bitmap.bitmapData.scroll(1,1);
			//stageの内容を書き込んでいる。
			_bitmap.bitmapData.draw(stage);
		}
	}
}