/**
 * Copyright Thumasz ( http://wonderfl.net/user/Thumasz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/exTx
 */

// forked from Karnix's Hypotrochoid
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import net.hires.debug.Stats;
    
    public class Hypotrochoid extends Sprite
    {
        private var fixedRadiu_num:Number = NaN;
        private var rollingRadiu_num:Number = NaN;
        private var distance_num:Number = NaN;
        private var maxPoints_int:int = 50000;
        private var offsetX_num:Number = 232.5;
        private var offsetY_num:Number = 232.5;
        private var count_int:int = 0;
        private var cos1_num:Number = NaN;
        private var sin1_num:Number = NaN;
        private var cos2_num:Number = NaN;
        private var sin2_num:Number = NaN;
        private var bmp:Bitmap = new Bitmap();
        private var bmd:BitmapData = null;
        private var _txt:TextField = new TextField();
        private var _x_num:Number = NaN;
        private var _y_num:Number = NaN;
        
        private var color:uint = 0x000000
        
        public function Hypotrochoid()
        {
            this.stage.frameRate = 120;
            
            _txt.text = this.stage.stageWidth + ", " + this.stage.stageHeight;
            
            _txt.autoSize = TextFieldAutoSize.CENTER;
            _txt.x = 232.5;
            
            this.addChild(bmp);
            this.addChild(_txt);
            
            this.stage.addChild(new Stats());
            
            this.stage.addEventListener(MouseEvent.CLICK, reset);
            
            reset();
        }
        
        private function reset(pEvent:MouseEvent = null):void
        {
            this.removeEventListener(Event.ENTER_FRAME, update);
            
            if (bmd != null)
            {
                bmd.dispose();
            }
            
            fixedRadiu_num = Math.floor(Math.random() * 100) + 100;
            rollingRadiu_num = Math.floor(Math.random() * (fixedRadiu_num - 110)) + 100;
            distance_num = Math.floor(Math.random() * (fixedRadiu_num + 10));
            
            count_int = 0;
            
            bmd = new BitmapData(550, 400, false, 0xffffff);
            bmp.bitmapData = bmd;
            
            this.addEventListener(Event.ENTER_FRAME, update);
        }
        
        private function update(pEvent:Event):void
        {
            if (count_int >= maxPoints_int)
            {
                this.removeEventListener(Event.ENTER_FRAME, update);
                return;
            }
            
            for (var _i:int = 0; _i < 500; _i++)
            {
                _txt.text = String(count_int);
                cos1_num = Math.cos(count_int);
                sin1_num = Math.sin(count_int);
                cos2_num = Math.cos(((fixedRadiu_num - rollingRadiu_num) / rollingRadiu_num) * count_int);
                sin2_num = Math.sin(((fixedRadiu_num - rollingRadiu_num) / rollingRadiu_num) * count_int);
                
                _x_num = ((fixedRadiu_num - rollingRadiu_num) * cos1_num) + (distance_num * cos2_num) + offsetX_num;
                _y_num = ((fixedRadiu_num - rollingRadiu_num) * sin1_num) - (distance_num * sin2_num) + offsetY_num;
        
                 color += 1;
                 if(color > 10){
                     color = 0;
                 }

                bmd.setPixel(_x_num, _y_num, new uint(color + color + color));
                
                count_int++;
            }
        }
    }
}