/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ewxF
 */

package 
{
    // Import External Classes
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TextEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import net.hires.debug.Stats;
    
    /**
    * Name           : Main
    * Coded By      : Matt Wakeling
    * Date           : 26th April 2012
    * Description    : Main Extry Point
    *                 : WonderFL Effect - Exploding Bitmap Tween Effect
    *                 : Click Screen to Start/Reset
    *
    * @author Matt Wakeling
    */
    [SWF(width = "465", height = "465", backgroundColor = "0", frameRate = "60" )]
    public class Main extends Sprite 
    {
        // Main Constructor
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        // init Method
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000,1);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();         
            
            var scrWonderFL:WonderFL = new WonderFL();
            addChild(scrWonderFL);
                        
            showText();
            
            addChild(new Stats());
        }
        
        private function showText():void 
        {
            var txtStart:TextField = new TextField;
            
            txtStart.text = "< CLICK MOUSE TO START/RESTART >";
            
            txtStart.autoSize = TextFieldAutoSize.LEFT;
            txtStart.x = stage.stageWidth * 0.5 - txtStart.width * 0.5;
            txtStart.y = stage.stageHeight - txtStart.textHeight;
            txtStart.textColor = 0xFFFF00;
            
            addChild(txtStart);
        }
        
    }
    
}


    // Import External Classes
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;  
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import com.greensock.easing.Strong;  
    import com.greensock.TweenLite;  
    import flash.system.LoaderContext;
    
    /**
    * Name           : WonderFL 
    * Coded By      : Matt Wakeling
    * Date           : 27th April 2012
    * Description    : WonderFL Effect - Exploding Bitmap Tween Effect
    *
    * @author Matt Wakeling
    */
    class WonderFL extends Sprite
    {
        // Intialise Class Properties    
        private var strImageURL:String    = "http://assets.wonderfl.net/images/related_images/7/78/7819/781939489515eb746625f701e5ee4731f69f0fbd";
        private var loader:Loader        = new Loader;  
        
        private var arrImageArray:Array;  
        
        // WonderFL Constructor
        public function WonderFL()
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init); 
        }
        
        // init Method
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            LoadImage(strImageURL);  
        }
        
        // LoadImage Method
        private function LoadImage (strLoaderURL:String):void  
        {  
            loader.contentLoaderInfo.addEventListener (Event.COMPLETE, onLoadComplete);  
            loader.load (new URLRequest (strLoaderURL), new LoaderContext(true));  
        }  
  
        // onLoadComplete Method
        private function onLoadComplete (evtLoadComplete:Event):void  
        {  
            loader.removeEventListener(Event.COMPLETE, onLoadComplete);  
            
            initImageDestruct(evtLoadComplete.target.content);
        }  
    
        private function initImageDestruct (bmpImage:Bitmap):void  
        {  
            var uintImageCenterX:Number = (stage.stageWidth - bmpImage.width) * 0.5;  
            var uintImageCenterY:Number = (stage.stageHeight - bmpImage.height) * 0.5;  
      
            var uintTileColumns:uint = bmpImage.width * 0.1;  
            var uintTileRows:uint = bmpImage.height * 0.1;  
            var uintTileWidth:uint = bmpImage.width / uintTileColumns;  
            var uintTileHeight:uint = bmpImage.height / uintTileRows;  
            var uintTotalTiles:uint = uintTileColumns * uintTileRows;  
            
            arrImageArray = [];
            
            for (var uintRowCounter:uint = 0; uintRowCounter < uintTileRows; uintRowCounter++)  
            {  
                for (var uintColumnCounter:uint = 0; uintColumnCounter < uintTileColumns; uintColumnCounter++)  
                {      
                    var bdTempTile:BitmapData = new BitmapData (uintTileWidth, uintTileHeight); 
                    var rectTile:Rectangle = new Rectangle (uintColumnCounter * uintTileWidth, uintRowCounter * uintTileHeight, uintTileWidth, uintTileHeight);  
                    
                    bdTempTile.copyPixels (bmpImage.bitmapData, rectTile, new Point);  
                    
                    var bmpTempTile:Bitmap = new Bitmap (bdTempTile);  
                    var sprTempTile:Sprite = new Sprite;  
                    
                    sprTempTile.addChild (bmpTempTile);  
                    
                    arrImageArray.push (sprTempTile);  
                    
                    sprTempTile.x = uintColumnCounter * uintTileWidth + uintImageCenterX;  
                    sprTempTile.y = uintRowCounter * uintTileHeight + uintImageCenterY;  
                    
                    addChild (sprTempTile);  
                }  
            }  
            stage.addEventListener (MouseEvent.CLICK, startDestructImage);  
        }  
        
        // startDestructImage Method
        private function startDestructImage (evtMouseClick:Event):void  
        {  
            stage.removeEventListener(MouseEvent.CLICK, startDestructImage);  
            
            for (var uintLoopCounter:uint = 0; uintLoopCounter < arrImageArray.length; uintLoopCounter++)  
            {  
                TweenLite.to (  
                arrImageArray[uintLoopCounter],  
                getRandomInRange (0.25, 2, false),
                {  
                    x:arrImageArray[uintLoopCounter].x  + getRandomInRange (1, 1000, false) * Math.cos(Math.atan2(arrImageArray[uintLoopCounter].y-stage.stageHeight/2, arrImageArray[uintLoopCounter].x-stage.stageWidth/2)),
                    y:arrImageArray[uintLoopCounter].y  + getRandomInRange (1, 1000, false) * Math.sin(Math.atan2(arrImageArray[uintLoopCounter].y-stage.stageHeight/2, arrImageArray[uintLoopCounter].x-stage.stageWidth/2)),
                    rotation: getRandomInRange (-90, 90),  
                    ease:Strong.easeIn,
                    alpha:0,
                    onComplete:removeSprite,  
                    onCompleteParams:[arrImageArray[uintLoopCounter],uintLoopCounter]  
                } 
                );  
            }
            
            //Reset
            stage.addEventListener (MouseEvent.CLICK, resetDestructImage);  
        }
        
        // resetDestructImage Method
        private function resetDestructImage(evtMouseClick:Event):void
        {
            stage.removeEventListener(MouseEvent.CLICK, resetDestructImage);
                        
            LoadImage(strImageURL);  
        }
        
        // removeSprite Method
        private function removeSprite (sprTile:Sprite, uintArrayNo:uint):void  
        {  
            removeChild (sprTile); 
            arrImageArray.splice(uintArrayNo,1);
        }  
        
        //getRandomInRange Function by John Reyes
        public static function getRandomInRange ($min:Number, $max:Number, $rounded:Boolean = true):Number  
        {  
            if ($rounded) return Math.round (Math.random () * ($max - $min) + $min);  
            else return Math.random () * ($max - $min) + $min;  
        }  
        
    }


