/**
 * Copyright Makoto_Tanaka ( http://wonderfl.net/user/Makoto_Tanaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ewoE
 */

// forked from Makoto_Tanaka's File Loader
/*
 * 画像をリサイズする処理
 */
package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.geom.Matrix;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    
    import flash.system.Security;
    
    public class FlashTest extends Sprite {
        
        private const RESIZE_WIDTH:int = 150;
        private const RESIZE_HEIGHT:int = 180
        
        private var _orgBmd:BitmapData = null;        
        private var _resizeBmp:Bitmap = null;
        
        // コンストラクタ
        public function FlashTest() {
            // write as3 code here..
            initSecurity();
            loadImage("http://assets.wonderfl.net/images/related_images/7/7e/7eb1/7eb105ed0d807e337921b22cf04a3ff19b0c4423m");
            
            // フレームの作成
            var frameShape:Shape = new Shape();
            frameShape.graphics.beginFill(0);
            frameShape.graphics.drawRect(-1,-1,RESIZE_WIDTH+2,RESIZE_HEIGHT+2);
            frameShape.graphics.beginFill(0xffffff);
            frameShape.graphics.drawRect(0,0,RESIZE_WIDTH,RESIZE_HEIGHT);
            frameShape.graphics.endFill();
            frameShape.x = 230;
            frameShape.y = 150;
            addChild(frameShape);
        }
        
        // セキュリティ設定
        private function initSecurity():void {
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        }
        
        // 画像のロード
        private function loadImage(url_:String):void　{
            var loader:Loader=new Loader();
            loader.load(new URLRequest(url_));
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE,onComplete);
        }
        
        // リサイズ処理切り替えボタンの作成
        private function initButton():void {
            var btn:Sprite = createButton("With in");
            btn.addEventListener(MouseEvent.CLICK, onClickWithIn);
            btn.x = 5;
            btn.y = 5;
            addChild(btn);
            
            btn = createButton("Crop");
            btn.addEventListener(MouseEvent.CLICK, onClickCrop);
            btn.x = 110;
            btn.y = 5;
            addChild(btn);
        }
        
        // ボタンの作成
        private function createButton(text_:String):Sprite {
            var sprite:Sprite = new Sprite();
            sprite.graphics.beginFill(0xaaaaff);
            sprite.graphics.drawRoundRect(0,0,100,30,5,5);
            sprite.graphics.endFill();
            addChild(sprite);
            
            var tf:TextField = new TextField();
            tf.text = text_;
            tf.x = (100 - tf.textWidth) / 2;
            tf.y = (30 - tf.textHeight) / 2 - 3;
            sprite.addChild(tf);
            
            var cover:Sprite = new Sprite();
            cover.graphics.beginFill(0,0);
            cover.graphics.drawRoundRect(0,0,100,30,5,5);
            cover.graphics.endFill();
            cover.useHandCursor = true;
            cover.mouseEnabled = true;
            sprite.addChild(cover);
            
            return sprite;
        }
        
        // Width in ボタンクリックイベント
        // resizeWithInした画像を表示する
        private function onClickWithIn(e:MouseEvent):void {
            if (_orgBmd) {
                if (_resizeBmp) {
                    _resizeBmp.bitmapData.dispose();
                    removeChild(_resizeBmp);
                }
                
                _resizeBmp = resizeWithIn(_orgBmd, RESIZE_WIDTH, RESIZE_HEIGHT);
                _resizeBmp.x = 230;
                _resizeBmp.y = 150;
                addChild(_resizeBmp);
            }
        }
        
        // Crop ボタンクリックイベント
        // resizeCropした画像を表示する
        private function onClickCrop(e:MouseEvent):void {
            if (_orgBmd) {
                if (_resizeBmp) {
                    _resizeBmp.bitmapData.dispose();
                    removeChild(_resizeBmp);
                }
                
                _resizeBmp = resizeCrop(_orgBmd, RESIZE_WIDTH, RESIZE_HEIGHT);
                _resizeBmp.x = 230;
                _resizeBmp.y = 150;
                addChild(_resizeBmp);
            }
        }
        
        // ロードが終了後のイベント
        private function onComplete(event:Event):void　{
            event.target.removeEventListener(Event.COMPLETE, onComplete);
            
            var content:Bitmap = event.target.content;
            _orgBmd = new BitmapData(content.width, content.height);
            _orgBmd.draw(content);
            var bmp:Bitmap = new Bitmap(_orgBmd, "auto", true);
            bmp.x = 5;
            bmp.y = 150;
            addChild(bmp);
            
            // ボタン作成
            initButton();
        }
        
        // 指定サイズ内に収まるようにリサイズしたBitmapを作成する
        private function resizeWithIn(orgBmd_:BitmapData, width_:int, height_:int):Bitmap {
            var bmd:BitmapData = new BitmapData(orgBmd_.width, orgBmd_.height);
            bmd.draw(orgBmd_);
            var bmp:Bitmap = new Bitmap(bmd, "auto", true);
            
            var scale:Number = Math.min(width_/bmp.width, height_/bmp.height);
            bmp.scaleX = bmp.scaleY = scale;
            return bmp;
        }
        
        // 指定サイズで比率を保った状態で拡大し、オーバーした部分を切り捨てたBitmapを返す
        private function resizeCrop(orgBmd_:BitmapData, width_:int, height_:int):Bitmap {
            var scale:Number = Math.max(width_/orgBmd_.width, height_/orgBmd_.height);
            var orgBmp:Bitmap = new Bitmap(orgBmd_);
            orgBmp.scaleX = orgBmp.scaleY = scale;
            
            var mat:Matrix = new Matrix(scale, 0, 0, scale, (width_ - orgBmp.width)/2, (height_ - orgBmp.height)/2);
            var bmd:BitmapData = new BitmapData(width_, height_);
            bmd.draw(orgBmd_,mat);
            var bmp:Bitmap = new Bitmap(bmd, "auto", true);
            
            return bmp;
        }

    }
}