/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ewa9
 */

//
//    SoundVisualizer2
//
//    音はTsabeat より拝借
//    http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
//
//
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.system.Security;
    
    import frocessing.color.ColorHSV;
    
    [SWF(width = "465", height = "465")]

    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private static const WIDTH:int = 465;
        private static const HEIGHT:int = 465;
        
        private static var policyPath:String = "http://mutast.heteml.jp/crossdomain.xml";
        private var _path:String = "http://mutast.heteml.jp/works/music/music.mp3";
    
        private var _soundloader:SoundLoader;
        private var _view:Shape;
        
        private var _canvas:BitmapData;
        
        private var _particleTop:SoundParticle;
        private var _particleCt:int;
        private var _step:int;
        
        private var _color:ColorHSV;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            //Security.allowDomain("*");
            Security.loadPolicyFile("http://mutast.heteml.jp/crossdomain.xml");

            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            _canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap(_canvas) );
            
            _view = new Shape();
            addChild( _view );
            
            
            _soundloader = new SoundLoader();
            _soundloader.Load( _path );
                    
            InitParticle();
            _step = 0;
            
            _color = new ColorHSV();
            
            addEventListener( Event.ENTER_FRAME, Update );
        }
        
        private function InitParticle() : void
        {

            
            _particleCt = 0;
            _particleTop = new SoundParticle();
            _particleTop.id = _particleCt++;
            _particleTop.angle = 0;
            _particleTop.length = 0;
            SetParticleData( _particleTop, 1 );
            
            trace("###", _particleCt);
            
        }
        
        private function SetParticleData( p:SoundParticle, depth:int ) : void
        {            
            if ( depth == 9 ) return;
            
            for ( var i:int = 0; i < 2; i++ )
            {
                var newP:SoundParticle = new SoundParticle();
                newP.id = _particleCt++;
                newP.angle = 90 + i * 180;
                newP.length = 150 - depth * 10;
                p.AddChild( newP );
                
                SetParticleData( newP, depth + 1 );
            }
        }
        
        
        private function Update(e:Event):void
        {
            var array:Array = _soundloader.GetSpectrumData(false);

            var i:int = 0;
            var arraytotal:Number = 0;
            
            for ( i = 0; i < array.length; i++ )
            {
                arraytotal += array[i];
            }
            
            _particleTop.Update( WIDTH / 2, HEIGHT / 2, 0, array );
            
            
            _view.graphics.clear();            
            ReDrawParticle( _particleTop, _view.graphics );
            
            
            var trans:ColorTransform = new ColorTransform();
            trans.color = _color.value;
            _canvas.draw( _view, null, trans );
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), new BlurFilter(3,3,8) );
            
            
            _color.h = (_color.h + 1) % 360;
            
            _step++;
        }
        
        private function ReDrawParticle( p:SoundParticle, g:Graphics ) : void
        {
            if ( p == null || g == null ) return;
            
            if ( p.child != null )
            {
                for ( var i:int = 0; i < p.child.length; i++ )
                {
                    ReDrawParticle( p.child[i], g );
                }
            }
            
            g.lineStyle(1, 0xFFFFFF);
            g.drawCircle(p.x, p.y, 2);
            
            if ( p.parent != null )
            {
                g.lineStyle(1, 0xFFFFFF, 0.5);
                g.moveTo( p.x, p.y );
                g.lineTo( p.parent.x, p.parent.y );
            }
        }
        
        
    }    
}
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;    
    import flash.media.SoundChannel;    
    import flash.net.URLRequest;
    import flash.utils.ByteArray;

    import flash.display.Graphics;
    
    class SoundLoader
    {
        private  var _started:Boolean;
        private var sound:Sound;
        private var soundChannel:SoundChannel;
        private var bytes:ByteArray;

        
        public function SoundLoader() 
        {
            _started = false;
        }
        
        public function Load(path:String):void
        {
            sound = new Sound();
            sound.addEventListener( Event.COMPLETE, LoadComplete );
            sound.load( new URLRequest(path), new SoundLoaderContext( 10, true ) );
            
            bytes = new ByteArray();
            _started = false;
        }
        
        private function LoadComplete(e:Event):void
        {
            e.target.removeEventListener( Event.COMPLETE, LoadComplete );
            Start();
        }
        
        private function Start():void
        {
            soundChannel = sound.play( 0, 1000 );
            _started = true;
        }
        
        public    function GetSpectrumData(FFTMode:Boolean = false) : Array
        {
            var i:int;
            var buf:Array = new Array(512);
            if ( !_started )
            {
                for ( i = 0; i < 512; i++ )    buf[i] = 0;
                return    buf;
            }
            
            SoundMixer.computeSpectrum( bytes, FFTMode, 0 );
            bytes.position = 0;
            for ( i = 0; i < 512; i++ )    buf[i] = bytes.readFloat();
            
            return    buf;
        }
        
    }    
    class Particle
    {
        public var x:Number;
        public var y:Number;
        
        public function Particle()     {}
        
    }
    
    /**
     * ...
     * @author 
     */
    class SoundParticle extends Particle
    {
        public var id:int;
        
        private var _child:/*SoundParticle*/Array;
        public function get child():/*SoundParticle*/Array { return    _child;    }
        
        private var _parent:SoundParticle;
        public function get parent():SoundParticle { return    _parent;    }
        
        public var angle:Number;
        public var length:Number;
                
        public function SoundParticle() 
        {            
            _child = null;
            _parent = null;
        }
        
        public function Update( tx:Number, ty:Number, pAngle:Number, val:Array ) : void
        {
            angle += val[id]*3 + 0.1;
            angle %= 360;
            
            var rad:Number = (angle + pAngle) % 360 * Math.PI / 180;
            x = tx + Math.cos( rad ) * length;
            y = ty + Math.sin( rad ) * length;    

            if ( _child != null )
            {
                for ( var i:int = 0; i < _child.length; i++ )
                {
                    _child[i].Update( x, y, (angle + pAngle) % 360, val );
                }
            }
        }
        
        public function SetParent( obj:SoundParticle ) : void
        {
            _parent = obj;
        }
        
        public function AddChild( obj:SoundParticle ) : void
        {
            if ( _child == null )    _child = new Array();
            _child.push( obj );
            obj.SetParent( this );
        }
    }    