/**
 * Copyright misinoe ( http://wonderfl.net/user/misinoe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ewGq
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Matrix;
    import flash.display.GradientType;
    import flash.display.BlendMode;
    public class FlashTest extends Sprite {
        
        /*
        * BitmapData.drawでブレンドモードをBlendMode.ERASEにする時の注意点です
        * 描画対象もBitmapDataであった場合は何故か成功しません。
        */
        
        public function FlashTest() {
            // write as3 code here..
            
            
            // 2つのBitmapとペアになるBitmapDataを作成します。
            // BitmapData1、これは左に表示されます
            var bitmapData1:BitmapData = new BitmapData( 200, 200, true, 0xFF888888 );
            var bitmap1:Bitmap = new Bitmap( bitmapData1 );
            this.addChild( bitmap1 );
            // BitmapData2、これは右に表示されます
            var bitmapData2:BitmapData = bitmapData1.clone();
            var bitmap2:Bitmap = new Bitmap( bitmapData2 );
            this.addChild( bitmap2 );
            bitmap2.x = 210;
            
            
            // 不透明度のある丸型グラデーションを描画します。そしてそれをビットマップデータにキャプチャします。
            var gradientBall:Sprite = new Sprite();
            gradientBall.y = 210;
            var gradientMatrix:Matrix = new Matrix();
            gradientMatrix.createGradientBox( 150, 150 );
            this.addChild( gradientBall );
            gradientBall.graphics.beginGradientFill( GradientType.RADIAL, [ 0, 0], [1, 0], [0, 255], gradientMatrix );
            gradientBall.graphics.lineStyle( 0 );
            gradientBall.graphics.drawCircle( 75, 75, 75 );
            var gradientBallBitmapData:BitmapData = new BitmapData( 150, 150, true, 0 );
            gradientBallBitmapData.draw( gradientBall );
            
            
            
            // グラデーションボールを転写したビットマップデータは、そのままではなぜかブレンドモードをERASEにした状態でdrawできません。
            // bitmapData1(左上)に描画をテストします
            bitmapData1.draw( gradientBallBitmapData, new Matrix(), null, BlendMode.ERASE );
            
            // Bitmapをを使ってdrawすると可能となります。
            // bitmapData2(右上)に描画をテストします。drawの第一引数はグラデーションボールを入れたBitmap型にした点が先ほどと違います。
            bitmapData2.draw( new Bitmap(gradientBallBitmapData), new Matrix(), null, BlendMode.ERASE );
        }
    }
}