/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/etny
 */

// forked from Kaede's forked from: あなたのイベントハンドラを教えて！
// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
* あなたのイベントハンドラを教えて！
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.utils.Dictionary;
    public class FlashTest extends Sprite {
    
        private var _btnA:MyButton;
        private var _btnB:MyButton;
        private var _btnC:MyButton;
        private var _label:MyTextField;
        //dicはケースバイケース。多くの場合テキストだけでは済まないのでモデルをつくる
        private var dic:Dictionary;

        public function FlashTest() {
            // ボタンを作成
            _build();
            
            // 自分流のイベントハンドラを記述ください
            
            // kaede 流
            // クリック
           addEventListener(MouseEvent.CLICK, clickHandler);
              // ロールオーバー
           addEventListener(MouseEvent.ROLL_OVER,rollOverHandler,true)
        }
        
        // kaede 流
        private function clickHandler(e:MouseEvent):void {
             if(!(e.target is MyButton))return
             _label.text = String(dic[e.target])+'がクリックされました'          
         }
        
        private function rollOverHandler(e:MouseEvent):void{
             if(!(e.target is MyButton))return
              _label.text = String(dic[e.target])+'がオーバーされました'
        }
        
        
        /**
        * インターフェースを作る
        */
        private function _build():void {
                dic = new Dictionary();
                
            _label = new MyTextField();
            _label.x = 150; _label.y = 280;
            addChild(_label);
            

            _btnA = new MyButton();
            _btnA.text = "Button A"; 
            _btnA.x = 70; _btnA.y = 230;
            dic[addChild(_btnA)] = 'A'
            
            _btnB = new MyButton();
            _btnB.text = "Button B";
            _btnB.x = 190; _btnB.y = 230;
            dic[addChild(_btnB)] = 'B'
               
            _btnC = new MyButton();            
            _btnC.text = "Button C";
            _btnC.x = 310; _btnC.y = 230;
            dic[addChild(_btnC)] = 'C'
        }
    }
}

import flash.display.*
import flash.text.*;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
*/
class MyButton extends Sprite {
    private var _text:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(){
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
    }
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}