/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/esGh
 */

package {
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    import flash.text.TextFieldType;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _input:TextField;
        private var _show:TextField;

        public function FlashTest() {
            var format1:TextFormat = new TextFormat();
            format1.align = "center";
            format1.size = 32;
            
            _input = new TextField();
            _input.type = TextFieldType.INPUT;
            _input.width = 400;
            _input.height = 40;
            _input.border = true;
            _input.defaultTextFormat = format1;
            _input.x = 32.5;
            _input.y = 320;
            _input.text = "anagram";
            this.addChild(_input);

            var format2:TextFormat = new TextFormat();
            format2.align = "center";
            format2.size = 48;
            
            _show = new TextField();
            _show.width = 400;
            _show.height = 80;
            _show.x = 32.5;
            _show.y = 120;
            _show.defaultTextFormat = format2;
            this.addChild(_show);
            
            this.addEventListener(KeyboardEvent.KEY_DOWN, onDown);
        }
        
        private function onDown(e:KeyboardEvent):void {
            if (e.keyCode == Keyboard.ENTER) {
                _show.text = getAnagram(_input.text);
            }
        }
        
        private function getAnagram(org:String):String {
            var str:String = org;
            var anagram:String = "";
            while (str.length > 0) {
                var i:uint = Math.random() * str.length;
                anagram += str.substr(i, 1);
                str = str.substr(0, i) + str.substr(i + 1);
            }
            return anagram;
        }
    }
}