/**
 * Copyright chiqui ( http://wonderfl.net/user/chiqui )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/er66
 */

package 

{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.ColorCorrection;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.ConvolutionFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.utils.getTimer;
    import flash.utils.setInterval;
    import flash.utils.setTimeout;
    import flash.ui.Keyboard;
    import flash.events.KeyboardEvent;
    
    public class Main extends Sprite {
        private static var ORIG:Point = new Point(0, 0);
        public var BRANCH_LEN:Number = 20;
        
        private var rview:Bitmap;
        private var tempg:Sprite;
        
        private var blAlt:Number = .2;
        private var onPress:Boolean = false;
        
        private var colorTrans:ColorTransform;
        
        private var lastPt:Point;
        private var tangle:Number;
        
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // color trans
            colorTrans = new ColorTransform(1, 1, 1, 1, 0, 0, 0, -1);
            // create stuff
            tempg = new Sprite();
            rview = new Bitmap(new BitmapData(this.stage.stageWidth, this.stage.stageHeight, false, 0), "auto", true);
            this.addChild(rview);
            //angle handler
            lastPt = new Point();
            //render
            setInterval(render, 40);
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, onmdown);
            this.stage.addEventListener(MouseEvent.MOUSE_UP, onmup);
            this.stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            if (e.keyCode == Keyboard.DELETE) {
                rview.bitmapData = new BitmapData(this.stage.stageWidth, this.stage.stageHeight, false, 0);
            }
        }        
        
        private function onmup(e:MouseEvent):void {
            this.stage.removeEventListener(MouseEvent.MOUSE_MOVE, onRender);
            onPress = false;
        }
        
        private function onmdown(e:MouseEvent):void {
            lastPt.x = this.stage.mouseX;
            lastPt.y = this.stage.mouseY;
            this.stage.addEventListener(MouseEvent.MOUSE_MOVE, onRender);
            onPress = true;
        }
        
        private function onRender(e:MouseEvent):void {
            tangle = (Math.atan2(lastPt.y - this.stage.mouseY, lastPt.x - this.stage.mouseX) * (180 / Math.PI))+90;
            hitAt(this.stage.mouseX, this.stage.mouseY);
            lastPt.x = this.stage.mouseX;
            lastPt.y = this.stage.mouseY;
        }
        
        private function render():void {            
            rview.bitmapData.lock();
            rview.bitmapData.draw(tempg, null, null, BlendMode.LIGHTEN);
            tempg.graphics.clear();
            //rview.bitmapData.colorTransform(rview.bitmapData.rect, colorTrans);
            rview.bitmapData.unlock();
            if (!onPress && blAlt > .2) {
                blAlt -= .06; 
            }else if(blAlt < .8){
                blAlt += .02;
            }
        }
        
        private function hitAt(tx:Number, ty:Number):void {
            tempg.graphics.lineStyle(1, 0xFFFFFF);
            var len:int = 15;
            var seed:Number = rndOld(10, 90)*blAlt*2;
            for (var i:int = 1; i < 15; i++) {
                setTimeout(drawBranch, 50*Math.random(), tx, ty, tangle-seed, tangle+seed, 1, (BRANCH_LEN+(Math.random()*BRANCH_LEN))*blAlt);
            }
        }
        
        private function drawBranch(ox:int, oy:int, a1:Number, a2:Number, s:int, bl:int):void {
            bl = bl / 1.5;
            if (bl < 4) return;
            var ta:Number = rndOld(a1, a2);
            tempg.graphics.moveTo(ox, oy);
            ox += (bl * Math.sin(ta * (Math.PI / 180)))
            oy -= (bl * Math.cos(ta * (Math.PI / 180)));
            tempg.graphics.lineStyle(1, 0xFFFFFF, BRANCH_LEN/(bl*13));
            tempg.graphics.lineTo(ox, oy);
            a1 = a1+s;
            a2 = a2-s;
            setTimeout(drawBranch, (100*Math.random())+10,  ox, oy, a1, a2, s+1, bl);    
        }
        
        private function rndOld(minNum:Number, maxNum:Number):Number { 
            return (Math.floor(Math.random() * (maxNum - minNum + 1)) + minNum);  
        }          
    }    
}