/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/eqqa
 */

package {
	import caurina.transitions.Equations;
	import caurina.transitions.Tweener;
	import caurina.transitions.properties.DisplayShortcuts;
	
	import com.adobe.serialization.json.JSON;
	import com.bit101.components.ColorChooser;
	import com.bit101.components.PushButton;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.ByteArray;
	import flash.utils.getTimer;
	
        /**
        * 曲は夢幻のオルゴール工房さんにて配布されているmp3ファイルを使用しています
        * http://www.dream-orgel.net/diary.cgi?no=120&continue=on
        */
	[SWF(width="465", height="465", backgroundColor="#000000", frameRate=30)]
	public class LineReader extends Sprite
	{
		private var _field:Sprite = new Sprite();
		private var _paintField:Sprite = new Sprite();
		private var _uiField:Sprite = new Sprite();
		private var _stopUiField:Sprite = new Sprite();
		private var _startField:Sprite = new Sprite();
		
		//Clearエフェクト
		private var _clearEffBmp:Bitmap = new Bitmap();
		private var _clearBmd:BitmapData = new BitmapData(465,465,true,0);
		
		//座標リスト
		private var _pointListList:Array = new Array();
		private var _currentListIndex:int = 0;
		private var _actionFlg:Boolean = true;
		/**
		 * params
		 */
		private var _col:Number = 0xFFFFFF;
		/**
		 * Sound parts
		 */
		private var player:Object = new Object();
		private var loader:Loader = new Loader();
		private var bA:ByteArray;
		private var spectrum:Array;
		public static var lowVal:Number=0;
		public static var middleVal:Number=0;
		public static var highVal:Number = 0;
		private var sound:Sound;
		private var _ch:SoundChannel;
		
		/**
		 * UI
		 */
		private var _colSelector:ColorSelector;
		private var _colChooser:ColorChooser;
		
		/**
		 * RECORD
		 */ 
		private var _rec:DrawRecoder = new DrawRecoder();
		private var _player:DrawPlayer = new DrawPlayer();
		
		/**
		 * TIMER
		 */
		private var _startTime:int;
		
		public function LineReader()
		{
			init();
			setupDisplay();
		}
		
		public function init():void {
			DisplayShortcuts.init();
			Security.loadPolicyFile("http://swimmingbird.heteml.jp/crossdomain.xml");
			
			_field.graphics.clear();
			_field.graphics.beginFill(0xCCCCCC,0);
			_field.graphics.drawRect(0,0,465,465);
			_field.graphics.endFill();
			
			
			//UI Starting
			var _startButton:PushButton = new PushButton(_startField,20,20,"start", startHandler);
			//UI Playing
			//			var _actionBtn:PushButton = new PushButton(_uiField,20,20,"action",actionHandler);
			//			var _noActionBtn:PushButton = new PushButton(_uiField,20,45,"noAction",noActionHandler);
			var _clearBtn:PushButton = new PushButton(_uiField,20,20,"clear",clearHandler);
			var _plotBtn:PushButton = new PushButton(_uiField,20,45,"plot",plotHandler);
			var _stopBtn:PushButton = new PushButton(_uiField,20,120,"stop",stopHandler);
			//UI Stop
			var _playDataBtn:PushButton = new PushButton(_stopUiField,20,20,"play",playDataHandler);
			var _stopDrawBtn:PushButton = new PushButton(_stopUiField,20,45,"stop",stopDrawHandler);
			
			_colSelector = new ColorSelector();
			//			_colChooser = new ColorChooser(_uiField,20,145);
			
			//Effect Init
			_clearEffBmp.bitmapData = _clearBmd;
			_clearEffBmp.visible = false;
			_clearEffBmp.alpha = 0;
			//座標リスト
			var comListString:String = '[{"type":"draw","col":16777010,"time":4831,"fy":122,"childlist":[{"x":160,"time":4974,"y":120},{"x":161,"time":4980,"y":119},{"x":161,"time":5010,"y":118},{"x":161,"time":5015,"y":116},{"x":162,"time":5033,"y":115},{"x":163,"time":5047,"y":114},{"x":163,"time":5058,"y":112},{"x":164,"time":5062,"y":111},{"x":164,"time":5074,"y":109},{"x":165,"time":5094,"y":107},{"x":166,"time":5130,"y":105},{"x":166,"time":5145,"y":103},{"x":167,"time":5154,"y":102},{"x":168,"time":5169,"y":101},{"x":168,"time":5194,"y":98},{"x":169,"time":5206,"y":97},{"x":170,"time":5224,"y":96},{"x":170,"time":5238,"y":94},{"x":171,"time":5261,"y":93},{"x":172,"time":5285,"y":92},{"x":173,"time":5314,"y":90},{"x":173,"time":5327,"y":89},{"x":175,"time":5344,"y":88},{"x":175,"time":5374,"y":87},{"x":177,"time":5381,"y":85},{"x":179,"time":5475,"y":83},{"x":180,"time":5529,"y":83},{"x":182,"time":5579,"y":83},{"x":182,"time":5618,"y":85},{"x":196,"time":6312,"y":121},{"x":197,"time":6345,"y":121},{"x":199,"time":6519,"y":121},{"x":200,"time":6534,"y":121},{"x":202,"time":6550,"y":122},{"x":203,"time":6580,"y":122},{"x":205,"time":6583,"y":122},{"x":222,"time":6941,"y":126},{"x":223,"time":7006,"y":127},{"x":224,"time":7021,"y":127},{"x":226,"time":7095,"y":127},{"x":227,"time":7173,"y":127},{"x":228,"time":7197,"y":127},{"x":230,"time":7437,"y":126},{"x":230,"time":7453,"y":124},{"x":231,"time":7486,"y":123},{"x":232,"time":7509,"y":122},{"x":232,"time":7526,"y":120},{"x":234,"time":7566,"y":118},{"x":234,"time":7597,"y":116},{"x":236,"time":7638,"y":112},{"x":237,"time":7665,"y":111},{"x":238,"time":7683,"y":109},{"x":240,"time":7701,"y":106},{"x":240,"time":7717,"y":104},{"x":241,"time":7741,"y":102},{"x":242,"time":7757,"y":101},{"x":242,"time":7781,"y":98},{"x":244,"time":7789,"y":98},{"x":245,"time":7796,"y":96},{"x":247,"time":7821,"y":94},{"x":247,"time":7829,"y":93},{"x":249,"time":7845,"y":90},{"x":250,"time":7870,"y":89},{"x":251,"time":7876,"y":88},{"x":253,"time":7902,"y":86},{"x":255,"time":7916,"y":85},{"x":255,"time":7949,"y":83},{"x":257,"time":7997,"y":83},{"x":257,"time":8077,"y":84},{"x":257,"time":8101,"y":85},{"x":258,"time":8133,"y":87},{"x":258,"time":8149,"y":88},{"x":258,"time":8173,"y":90},{"x":258,"time":8189,"y":91},{"x":259,"time":8197,"y":93},{"x":259,"time":8221,"y":94},{"x":259,"time":8229,"y":95},{"x":259,"time":8252,"y":96},{"x":259,"time":8261,"y":98},{"x":259,"time":8277,"y":99},{"x":259,"time":8292,"y":100},{"x":259,"time":8301,"y":102},{"x":259,"time":8309,"y":103},{"x":258,"time":8332,"y":105},{"x":258,"time":8341,"y":106},{"x":258,"time":8349,"y":108},{"x":258,"time":8373,"y":110},{"x":258,"time":8389,"y":111},{"x":258,"time":8413,"y":113},{"x":258,"time":8445,"y":115},{"x":258,"time":8460,"y":116},{"x":258,"time":8469,"y":117},{"x":259,"time":8501,"y":119},{"x":259,"time":8525,"y":120},{"x":259,"time":8540,"y":121},{"x":260,"time":8573,"y":122},{"x":260,"time":8605,"y":124},{"x":260,"time":8621,"y":125},{"x":261,"time":8653,"y":126},{"x":262,"time":8677,"y":128},{"x":263,"time":8701,"y":130},{"x":264,"time":8733,"y":131},{"x":263,"time":8765,"y":133},{"x":263,"time":8781,"y":134},{"x":263,"time":8805,"y":135},{"x":263,"time":8836,"y":137},{"x":263,"time":8853,"y":138},{"x":263,"time":8885,"y":140},{"x":262,"time":8909,"y":141},{"x":262,"time":8933,"y":143},{"x":261,"time":8956,"y":144},{"x":261,"time":8989,"y":145},{"x":261,"time":9037,"y":147},{"x":261,"time":9069,"y":148},{"x":261,"time":9093,"y":149},{"x":260,"time":9133,"y":151},{"x":260,"time":9165,"y":152},{"x":260,"time":9205,"y":153},{"x":260,"time":9229,"y":155},{"x":260,"time":9245,"y":156},{"x":261,"time":9277,"y":157},{"x":262,"time":9301,"y":159},{"x":262,"time":9341,"y":160},{"x":262,"time":9389,"y":161},{"x":261,"time":9437,"y":163},{"x":261,"time":9469,"y":164},{"x":261,"time":9485,"y":165},{"x":261,"time":9509,"y":167},{"x":261,"time":9525,"y":168},{"x":261,"time":9549,"y":169},{"x":261,"time":9565,"y":171},{"x":261,"time":9589,"y":173},{"x":261,"time":9613,"y":174},{"x":260,"time":9621,"y":175},{"x":260,"time":9637,"y":176},{"x":260,"time":9653,"y":178},{"x":260,"time":9669,"y":179},{"x":260,"time":9693,"y":181},{"x":260,"time":9708,"y":182},{"x":260,"time":9733,"y":184},{"x":260,"time":9750,"y":185},{"x":260,"time":9773,"y":186},{"x":260,"time":9796,"y":188},{"x":259,"time":9836,"y":189},{"x":259,"time":9861,"y":190},{"x":259,"time":9876,"y":191},{"x":258,"time":9909,"y":193},{"x":258,"time":9941,"y":194},{"x":258,"time":9966,"y":195},{"x":258,"time":10013,"y":197},{"x":257,"time":10029,"y":198},{"x":256,"time":10053,"y":200},{"x":256,"time":10069,"y":201},{"x":256,"time":10101,"y":202},{"x":256,"time":10124,"y":203},{"x":256,"time":10141,"y":205},{"x":256,"time":10165,"y":206},{"x":255,"time":10181,"y":207},{"x":255,"time":10197,"y":209},{"x":255,"time":10212,"y":210},{"x":254,"time":10237,"y":211},{"x":254,"time":10252,"y":213},{"x":254,"time":10260,"y":214},{"x":253,"time":10285,"y":215},{"x":253,"time":10292,"y":217},{"x":252,"time":10317,"y":218},{"x":252,"time":10325,"y":219},{"x":252,"time":10340,"y":221},{"x":251,"time":10357,"y":223},{"x":250,"time":10373,"y":225},{"x":249,"time":10389,"y":226},{"x":249,"time":10397,"y":228},{"x":248,"time":10413,"y":230},{"x":247,"time":10437,"y":231},{"x":246,"time":10477,"y":233},{"x":245,"time":10493,"y":234},{"x":243,"time":10508,"y":235},{"x":242,"time":10533,"y":236},{"x":240,"time":10557,"y":238},{"x":239,"time":10588,"y":239},{"x":237,"time":10621,"y":241},{"x":237,"time":10645,"y":242},{"x":235,"time":10669,"y":243},{"x":234,"time":10685,"y":243},{"x":233,"time":10708,"y":244},{"x":231,"time":10741,"y":245},{"x":230,"time":10765,"y":245},{"x":229,"time":10789,"y":246},{"x":227,"time":10821,"y":247},{"x":226,"time":10845,"y":247},{"x":224,"time":10876,"y":248},{"x":223,"time":10909,"y":248},{"x":222,"time":10941,"y":249},{"x":221,"time":10956,"y":249},{"x":219,"time":10989,"y":249},{"x":218,"time":11029,"y":249},{"x":217,"time":11061,"y":250},{"x":215,"time":11092,"y":250},{"x":214,"time":11149,"y":252},{"x":212,"time":11189,"y":253},{"x":212,"time":11212,"y":254},{"x":212,"time":11245,"y":256},{"x":212,"time":11269,"y":257},{"x":210,"time":11292,"y":258},{"x":209,"time":11309,"y":260},{"x":207,"time":11340,"y":261},{"x":206,"time":11373,"y":262},{"x":205,"time":11405,"y":262},{"x":203,"time":11413,"y":262},{"x":202,"time":11428,"y":264},{"x":200,"time":11445,"y":265},{"x":198,"time":11453,"y":265},{"x":197,"time":11460,"y":266},{"x":196,"time":11477,"y":267},{"x":194,"time":11485,"y":267},{"x":193,"time":11493,"y":267},{"x":192,"time":11517,"y":267},{"x":191,"time":11540,"y":267},{"x":188,"time":11573,"y":267},{"x":187,"time":11598,"y":267},{"x":186,"time":11605,"y":268},{"x":184,"time":11621,"y":268},{"x":183,"time":11645,"y":268},{"x":182,"time":11661,"y":267},{"x":180,"time":11685,"y":266},{"x":179,"time":11716,"y":265},{"x":178,"time":11733,"y":265},{"x":176,"time":11756,"y":265},{"x":175,"time":11773,"y":264},{"x":174,"time":11796,"y":264},{"x":173,"time":11813,"y":264},{"x":172,"time":11845,"y":263},{"x":170,"time":11893,"y":261},{"x":170,"time":11933,"y":260},{"x":170,"time":11964,"y":259},{"x":170,"time":12029,"y":257},{"x":169,"time":12069,"y":256},{"x":168,"time":12109,"y":255},{"x":168,"time":12141,"y":253},{"x":168,"time":12180,"y":252},{"x":167,"time":12197,"y":251},{"x":167,"time":12229,"y":249},{"x":166,"time":12277,"y":248},{"x":165,"time":12332,"y":247},{"x":164,"time":12357,"y":247},{"x":162,"time":12388,"y":247},{"x":161,"time":12413,"y":247},{"x":160,"time":12437,"y":245},{"x":158,"time":12470,"y":245},{"x":157,"time":12500,"y":244},{"x":155,"time":12540,"y":243},{"x":154,"time":12581,"y":242},{"x":153,"time":12613,"y":241},{"x":151,"time":12653,"y":240},{"x":151,"time":12685,"y":238},{"x":150,"time":12708,"y":237},{"x":149,"time":12741,"y":236},{"x":149,"time":12773,"y":234},{"x":149,"time":12789,"y":233},{"x":148,"time":12821,"y":231},{"x":147,"time":12844,"y":229},{"x":147,"time":12861,"y":228},{"x":146,"time":12893,"y":227},{"x":146,"time":12916,"y":225},{"x":146,"time":12933,"y":224},{"x":145,"time":12956,"y":223},{"x":144,"time":12972,"y":220},{"x":144,"time":12997,"y":219},{"x":144,"time":13012,"y":218},{"x":142,"time":13037,"y":216},{"x":142,"time":13053,"y":215},{"x":141,"time":13077,"y":214},{"x":141,"time":13100,"y":212},{"x":141,"time":13124,"y":211},{"x":141,"time":13140,"y":210},{"x":141,"time":13165,"y":208},{"x":142,"time":13180,"y":207},{"x":141,"time":13198,"y":206},{"x":141,"time":13205,"y":204},{"x":141,"time":13229,"y":203},{"x":140,"time":13245,"y":202},{"x":140,"time":13269,"y":200},{"x":139,"time":13285,"y":199},{"x":139,"time":13309,"y":197},{"x":139,"time":13325,"y":195},{"x":140,"time":13348,"y":193},{"x":139,"time":13357,"y":192},{"x":139,"time":13373,"y":191},{"x":139,"time":13388,"y":189},{"x":139,"time":13405,"y":188},{"x":138,"time":13413,"y":187},{"x":138,"time":13428,"y":185},{"x":138,"time":13445,"y":183},{"x":138,"time":13469,"y":182},{"x":138,"time":13485,"y":181},{"x":138,"time":13500,"y":179},{"x":138,"time":13516,"y":177},{"x":138,"time":13540,"y":175},{"x":138,"time":13548,"y":174},{"x":138,"time":13565,"y":173},{"x":138,"time":13581,"y":171},{"x":138,"time":13596,"y":170},{"x":138,"time":13605,"y":169},{"x":139,"time":13629,"y":166},{"x":139,"time":13645,"y":164},{"x":140,"time":13670,"y":162},{"x":140,"time":13685,"y":160},{"x":141,"time":13708,"y":159},{"x":141,"time":13724,"y":157},{"x":142,"time":13741,"y":156},{"x":142,"time":13756,"y":155},{"x":142,"time":13773,"y":153},{"x":143,"time":13789,"y":152},{"x":144,"time":13813,"y":151},{"x":144,"time":13821,"y":149},{"x":145,"time":13836,"y":148},{"x":146,"time":13852,"y":146},{"x":147,"time":13869,"y":145},{"x":147,"time":13876,"y":144},{"x":147,"time":13909,"y":142},{"x":147,"time":13941,"y":141},{"x":148,"time":13956,"y":140},{"x":149,"time":13989,"y":138},{"x":149,"time":14021,"y":136},{"x":150,"time":14053,"y":135},{"x":150,"time":14077,"y":134},{"x":151,"time":14109,"y":132},{"x":151,"time":14149,"y":131},{"x":152,"time":14172,"y":129},{"x":153,"time":14188,"y":128},{"x":153,"time":14220,"y":127},{"x":153,"time":14252,"y":125},{"x":155,"time":14270,"y":125},{"x":155,"time":14317,"y":123},{"x":156,"time":14340,"y":122},{"x":157,"time":14380,"y":121},{"x":158,"time":14436,"y":120},{"x":159,"time":14485,"y":119},{"x":160,"time":14533,"y":117},{"x":161,"time":14581,"y":117},{"x":162,"time":14636,"y":115},{"x":162,"time":14693,"y":114},{"x":161,"time":14756,"y":114}],"fx":160,"id":0},{"type":"draw","col":16777165,"time":16357,"fy":190,"childlist":[{"x":156,"time":16436,"y":191},{"x":155,"time":16476,"y":192},{"x":153,"time":16508,"y":192},{"x":153,"time":16540,"y":190},{"x":152,"time":16556,"y":189},{"x":152,"time":16573,"y":187},{"x":152,"time":16588,"y":186},{"x":152,"time":16613,"y":184},{"x":152,"time":16628,"y":183},{"x":154,"time":16653,"y":181},{"x":154,"time":16668,"y":180},{"x":156,"time":16693,"y":178},{"x":157,"time":16748,"y":178},{"x":158,"time":16789,"y":178},{"x":160,"time":16812,"y":178},{"x":160,"time":16844,"y":180},{"x":161,"time":16884,"y":181},{"x":161,"time":16900,"y":182},{"x":160,"time":16932,"y":184},{"x":160,"time":16949,"y":185},{"x":160,"time":16972,"y":186},{"x":159,"time":17004,"y":187},{"x":158,"time":17029,"y":189},{"x":158,"time":17084,"y":190},{"x":156,"time":17124,"y":191},{"x":155,"time":17172,"y":192},{"x":155,"time":17252,"y":190}],"fx":157,"id":0},{"type":"draw","col":16777165,"time":17893,"fy":197,"childlist":[{"x":234,"time":17997,"y":198},{"x":232,"time":18044,"y":199},{"x":231,"time":18077,"y":198},{"x":230,"time":18108,"y":197},{"x":228,"time":18148,"y":196},{"x":228,"time":18180,"y":195},{"x":228,"time":18196,"y":194},{"x":228,"time":18220,"y":193},{"x":228,"time":18236,"y":191},{"x":228,"time":18260,"y":190},{"x":228,"time":18276,"y":189},{"x":229,"time":18308,"y":187},{"x":230,"time":18332,"y":187},{"x":232,"time":18356,"y":186},{"x":232,"time":18396,"y":184},{"x":234,"time":18429,"y":184},{"x":235,"time":18468,"y":185},{"x":236,"time":18508,"y":186},{"x":236,"time":18540,"y":188},{"x":236,"time":18581,"y":189},{"x":237,"time":18604,"y":190},{"x":237,"time":18628,"y":192},{"x":237,"time":18661,"y":193},{"x":236,"time":18692,"y":194},{"x":236,"time":18732,"y":195},{"x":234,"time":18780,"y":196},{"x":234,"time":18812,"y":198},{"x":234,"time":18892,"y":197}],"fx":235,"id":0},{"type":"draw","col":16777165,"time":19636,"fy":252,"childlist":[{"x":188,"time":19756,"y":251},{"x":187,"time":19789,"y":251},{"x":186,"time":19804,"y":251},{"x":183,"time":19828,"y":250},{"x":182,"time":19844,"y":249},{"x":181,"time":19860,"y":249},{"x":179,"time":19876,"y":249},{"x":178,"time":19900,"y":248},{"x":177,"time":19940,"y":247},{"x":177,"time":19972,"y":245},{"x":177,"time":19988,"y":244},{"x":179,"time":20028,"y":243},{"x":180,"time":20052,"y":243},{"x":181,"time":20070,"y":243},{"x":182,"time":20076,"y":243},{"x":184,"time":20100,"y":243},{"x":185,"time":20117,"y":243},{"x":186,"time":20140,"y":243},{"x":188,"time":20156,"y":243},{"x":190,"time":20188,"y":243},{"x":191,"time":20220,"y":243},{"x":193,"time":20260,"y":245},{"x":193,"time":20292,"y":246},{"x":194,"time":20332,"y":247},{"x":193,"time":20380,"y":249},{"x":191,"time":20413,"y":250},{"x":191,"time":20452,"y":251},{"x":190,"time":20500,"y":253},{"x":189,"time":20540,"y":253},{"x":187,"time":20572,"y":254},{"x":186,"time":20612,"y":254},{"x":186,"time":20693,"y":253}],"fx":190,"id":0},{"type":"draw","col":16777165,"time":21573,"fy":155,"childlist":[{"x":173,"time":21660,"y":155},{"x":171,"time":21692,"y":155},{"x":169,"time":21708,"y":155},{"x":168,"time":21732,"y":154},{"x":167,"time":21748,"y":153},{"x":164,"time":21772,"y":152},{"x":164,"time":21780,"y":150},{"x":163,"time":21805,"y":149},{"x":162,"time":21828,"y":148},{"x":162,"time":21852,"y":146},{"x":162,"time":21868,"y":145},{"x":163,"time":21892,"y":143},{"x":164,"time":21900,"y":143},{"x":166,"time":21924,"y":141},{"x":167,"time":21940,"y":141},{"x":168,"time":21964,"y":139},{"x":170,"time":21980,"y":139},{"x":171,"time":21996,"y":138},{"x":173,"time":22012,"y":138},{"x":174,"time":22037,"y":138},{"x":176,"time":22044,"y":138},{"x":177,"time":22060,"y":138},{"x":179,"time":22083,"y":140},{"x":179,"time":22100,"y":141},{"x":181,"time":22132,"y":143},{"x":181,"time":22156,"y":145},{"x":181,"time":22172,"y":146},{"x":181,"time":22196,"y":147},{"x":181,"time":22212,"y":148},{"x":180,"time":22236,"y":150},{"x":179,"time":22251,"y":151},{"x":178,"time":22284,"y":153},{"x":176,"time":22316,"y":154},{"x":175,"time":22348,"y":155},{"x":174,"time":22375,"y":156},{"x":173,"time":22396,"y":156},{"x":172,"time":22428,"y":157},{"x":170,"time":22468,"y":157},{"x":170,"time":22524,"y":155}],"fx":174,"id":0},{"type":"draw","col":16777165,"time":23052,"fy":155,"childlist":[{"x":229,"time":23140,"y":156},{"x":228,"time":23171,"y":156},{"x":226,"time":23205,"y":157},{"x":225,"time":23220,"y":157},{"x":223,"time":23244,"y":157},{"x":222,"time":23260,"y":158},{"x":220,"time":23284,"y":157},{"x":219,"time":23299,"y":156},{"x":218,"time":23324,"y":155},{"x":216,"time":23340,"y":154},{"x":215,"time":23364,"y":153},{"x":215,"time":23396,"y":151},{"x":215,"time":23436,"y":150},{"x":217,"time":23459,"y":149},{"x":218,"time":23484,"y":146},{"x":220,"time":23499,"y":145},{"x":221,"time":23532,"y":144},{"x":222,"time":23556,"y":143},{"x":224,"time":23572,"y":143},{"x":226,"time":23596,"y":143},{"x":227,"time":23604,"y":143},{"x":228,"time":23627,"y":143},{"x":230,"time":23644,"y":144},{"x":231,"time":23667,"y":145},{"x":232,"time":23684,"y":146},{"x":233,"time":23707,"y":147},{"x":234,"time":23732,"y":149},{"x":235,"time":23764,"y":150},{"x":234,"time":23788,"y":151},{"x":234,"time":23804,"y":153},{"x":232,"time":23828,"y":154},{"x":232,"time":23844,"y":156},{"x":231,"time":23868,"y":157},{"x":230,"time":23915,"y":158},{"x":228,"time":23948,"y":158}],"fx":231,"id":0},{"type":"draw","col":16777165,"time":25660,"fy":264,"childlist":[{"x":171,"time":25675,"y":262},{"x":171,"time":25707,"y":261},{"x":171,"time":25740,"y":260},{"x":171,"time":25900,"y":261},{"x":171,"time":25923,"y":263},{"x":171,"time":25942,"y":265},{"x":171,"time":25949,"y":266},{"x":170,"time":25963,"y":268},{"x":170,"time":25980,"y":270},{"x":170,"time":25988,"y":271},{"x":170,"time":26005,"y":273},{"x":170,"time":26011,"y":275},{"x":170,"time":26020,"y":276},{"x":170,"time":26028,"y":277},{"x":170,"time":26043,"y":279},{"x":171,"time":26051,"y":280},{"x":171,"time":26060,"y":281},{"x":172,"time":26068,"y":283},{"x":172,"time":26091,"y":285},{"x":173,"time":26108,"y":286},{"x":174,"time":26123,"y":287},{"x":175,"time":26140,"y":289},{"x":177,"time":26164,"y":290},{"x":179,"time":26180,"y":292},{"x":180,"time":26196,"y":292},{"x":182,"time":26205,"y":293},{"x":183,"time":26219,"y":294},{"x":184,"time":26237,"y":294},{"x":186,"time":26251,"y":294},{"x":189,"time":26276,"y":293},{"x":190,"time":26284,"y":293},{"x":192,"time":26308,"y":291},{"x":200,"time":26761,"y":269}],"fx":171,"id":0},{"type":"draw","col":16777165,"time":27188,"fy":268,"childlist":[{"x":181,"time":27308,"y":269},{"x":181,"time":27331,"y":271},{"x":181,"time":27347,"y":273},{"x":181,"time":27364,"y":275},{"x":181,"time":27372,"y":276},{"x":181,"time":27379,"y":278},{"x":181,"time":27396,"y":279},{"x":181,"time":27404,"y":281},{"x":181,"time":27412,"y":282},{"x":181,"time":27420,"y":284},{"x":181,"time":27444,"y":286},{"x":180,"time":27564,"y":285}],"fx":181,"id":0},{"type":"draw","col":16763954,"time":32700,"fy":204,"childlist":[{"x":132,"time":32795,"y":205},{"x":132,"time":32820,"y":206},{"x":132,"time":32828,"y":207},{"x":131,"time":32843,"y":210},{"x":130,"time":32868,"y":212},{"x":129,"time":32891,"y":214},{"x":129,"time":32899,"y":215},{"x":129,"time":32907,"y":217},{"x":129,"time":32915,"y":218},{"x":129,"time":32931,"y":219},{"x":129,"time":32939,"y":220},{"x":128,"time":32947,"y":222},{"x":128,"time":32956,"y":223},{"x":128,"time":32971,"y":225},{"x":127,"time":32979,"y":227},{"x":127,"time":32987,"y":228},{"x":127,"time":32995,"y":229},{"x":126,"time":33021,"y":231},{"x":126,"time":33027,"y":234},{"x":125,"time":33035,"y":235},{"x":124,"time":33051,"y":236},{"x":124,"time":33059,"y":238},{"x":124,"time":33083,"y":241},{"x":124,"time":33091,"y":243},{"x":124,"time":33099,"y":244},{"x":124,"time":33107,"y":245},{"x":124,"time":33123,"y":247},{"x":124,"time":33131,"y":249},{"x":123,"time":33139,"y":250},{"x":123,"time":33147,"y":251},{"x":123,"time":33164,"y":253},{"x":123,"time":33171,"y":254},{"x":123,"time":33179,"y":255},{"x":122,"time":33187,"y":257},{"x":122,"time":33204,"y":258},{"x":122,"time":33211,"y":259},{"x":122,"time":33227,"y":261},{"x":122,"time":33243,"y":263},{"x":122,"time":33251,"y":264},{"x":122,"time":33259,"y":265},{"x":122,"time":33275,"y":267},{"x":122,"time":33283,"y":268},{"x":122,"time":33291,"y":269},{"x":122,"time":33299,"y":270},{"x":122,"time":33315,"y":272},{"x":122,"time":33323,"y":273},{"x":122,"time":33331,"y":274},{"x":122,"time":33339,"y":275},{"x":122,"time":33355,"y":277},{"x":122,"time":33363,"y":278},{"x":122,"time":33371,"y":279},{"x":122,"time":33395,"y":281},{"x":123,"time":33403,"y":283},{"x":123,"time":33411,"y":284},{"x":124,"time":33435,"y":286},{"x":124,"time":33443,"y":288},{"x":124,"time":33451,"y":289},{"x":124,"time":33467,"y":290},{"x":124,"time":33484,"y":292},{"x":124,"time":33507,"y":294},{"x":124,"time":33523,"y":297},{"x":124,"time":33547,"y":298},{"x":124,"time":33563,"y":299},{"x":124,"time":33588,"y":300},{"x":125,"time":33603,"y":302},{"x":125,"time":33627,"y":303},{"x":126,"time":33643,"y":304},{"x":126,"time":33667,"y":306},{"x":126,"time":33683,"y":307},{"x":126,"time":33707,"y":308},{"x":126,"time":33723,"y":310},{"x":126,"time":33748,"y":311},{"x":127,"time":33763,"y":312},{"x":127,"time":33788,"y":314},{"x":127,"time":33803,"y":315},{"x":127,"time":33828,"y":316},{"x":128,"time":33843,"y":318},{"x":128,"time":33867,"y":319},{"x":128,"time":33883,"y":320},{"x":128,"time":33907,"y":321},{"x":129,"time":33923,"y":323},{"x":129,"time":33947,"y":324},{"x":130,"time":33964,"y":325},{"x":130,"time":33989,"y":327},{"x":130,"time":34012,"y":329},{"x":130,"time":34036,"y":330},{"x":131,"time":34067,"y":332},{"x":131,"time":34091,"y":334},{"x":131,"time":34107,"y":336},{"x":131,"time":34131,"y":338},{"x":131,"time":34147,"y":339},{"x":132,"time":34155,"y":341},{"x":133,"time":34179,"y":342},{"x":133,"time":34195,"y":344},{"x":133,"time":34221,"y":346},{"x":133,"time":34243,"y":347},{"x":134,"time":34259,"y":348},{"x":134,"time":34267,"y":349},{"x":134,"time":34291,"y":351},{"x":134,"time":34307,"y":352},{"x":135,"time":34331,"y":353},{"x":135,"time":34347,"y":355},{"x":134,"time":34363,"y":356},{"x":134,"time":34379,"y":357},{"x":134,"time":34403,"y":359},{"x":134,"time":34411,"y":360},{"x":135,"time":34427,"y":361},{"x":135,"time":34451,"y":363},{"x":136,"time":34467,"y":364},{"x":136,"time":34491,"y":366},{"x":136,"time":34515,"y":368},{"x":136,"time":34523,"y":369},{"x":137,"time":34540,"y":370},{"x":137,"time":34563,"y":371},{"x":137,"time":34579,"y":373},{"x":137,"time":34603,"y":374},{"x":137,"time":34622,"y":375},{"x":137,"time":34675,"y":377},{"x":137,"time":34699,"y":378},{"x":136,"time":34739,"y":379},{"x":136,"time":34763,"y":381},{"x":136,"time":34795,"y":382},{"x":135,"time":34835,"y":383},{"x":134,"time":34867,"y":385},{"x":134,"time":34915,"y":386},{"x":134,"time":34963,"y":387},{"x":132,"time":35027,"y":389},{"x":132,"time":35051,"y":390},{"x":132,"time":35091,"y":391},{"x":132,"time":35124,"y":393},{"x":133,"time":35155,"y":394},{"x":133,"time":35179,"y":395},{"x":134,"time":35203,"y":397},{"x":134,"time":35235,"y":398},{"x":136,"time":35259,"y":399},{"x":137,"time":35283,"y":399},{"x":138,"time":35307,"y":400},{"x":140,"time":35339,"y":400},{"x":141,"time":35363,"y":400},{"x":142,"time":35387,"y":400},{"x":144,"time":35421,"y":399},{"x":145,"time":35451,"y":397},{"x":146,"time":35475,"y":396},{"x":147,"time":35515,"y":395},{"x":148,"time":35539,"y":393},{"x":148,"time":35579,"y":392},{"x":148,"time":35611,"y":391},{"x":146,"time":35691,"y":391},{"x":145,"time":35715,"y":393},{"x":145,"time":35763,"y":394},{"x":144,"time":35779,"y":395},{"x":143,"time":35803,"y":397},{"x":143,"time":35827,"y":398},{"x":143,"time":35851,"y":399},{"x":145,"time":35891,"y":401},{"x":146,"time":35907,"y":401},{"x":147,"time":35931,"y":401},{"x":149,"time":35963,"y":400},{"x":150,"time":35979,"y":399},{"x":151,"time":36003,"y":399},{"x":153,"time":36043,"y":398},{"x":154,"time":36082,"y":397},{"x":155,"time":36115,"y":396},{"x":155,"time":36131,"y":394},{"x":155,"time":36299,"y":395},{"x":154,"time":36331,"y":396},{"x":154,"time":36355,"y":397},{"x":154,"time":36371,"y":399},{"x":154,"time":36403,"y":400},{"x":154,"time":36427,"y":401},{"x":155,"time":36467,"y":403},{"x":156,"time":36491,"y":404},{"x":157,"time":36523,"y":404},{"x":158,"time":36555,"y":404},{"x":159,"time":36587,"y":404},{"x":161,"time":36603,"y":403},{"x":161,"time":36627,"y":401},{"x":163,"time":36643,"y":401},{"x":164,"time":36683,"y":400},{"x":166,"time":36715,"y":399},{"x":166,"time":36739,"y":397},{"x":167,"time":36755,"y":396},{"x":167,"time":36789,"y":395},{"x":168,"time":36827,"y":393},{"x":168,"time":36859,"y":392},{"x":169,"time":36883,"y":391},{"x":170,"time":36907,"y":389},{"x":170,"time":36947,"y":388},{"x":170,"time":36979,"y":387},{"x":170,"time":37003,"y":385},{"x":170,"time":37035,"y":384},{"x":170,"time":37067,"y":383},{"x":169,"time":37107,"y":381},{"x":169,"time":37147,"y":380},{"x":169,"time":37179,"y":379},{"x":169,"time":37211,"y":377},{"x":169,"time":37227,"y":376},{"x":169,"time":37250,"y":375},{"x":169,"time":37275,"y":374},{"x":169,"time":37307,"y":372},{"x":169,"time":37331,"y":371},{"x":169,"time":37347,"y":370},{"x":169,"time":37371,"y":368},{"x":169,"time":37411,"y":367},{"x":169,"time":37427,"y":366},{"x":169,"time":37458,"y":365},{"x":169,"time":37491,"y":363},{"x":169,"time":37531,"y":362},{"x":168,"time":37563,"y":361},{"x":167,"time":37587,"y":359},{"x":167,"time":37611,"y":358},{"x":167,"time":37643,"y":357},{"x":166,"time":37659,"y":355},{"x":166,"time":37691,"y":354},{"x":166,"time":37723,"y":353},{"x":166,"time":37754,"y":352},{"x":166,"time":37779,"y":350},{"x":166,"time":37803,"y":349},{"x":166,"time":37821,"y":348},{"x":166,"time":37843,"y":346},{"x":166,"time":37883,"y":345},{"x":166,"time":37915,"y":344},{"x":166,"time":37931,"y":343},{"x":166,"time":37963,"y":341},{"x":166,"time":37995,"y":340},{"x":165,"time":38027,"y":339},{"x":165,"time":38042,"y":337},{"x":164,"time":38075,"y":336},{"x":164,"time":38107,"y":335},{"x":164,"time":38147,"y":333}],"fx":133,"id":0},{"type":"draw","col":16763954,"time":39251,"fy":327,"childlist":[{"x":155,"time":39298,"y":327},{"x":155,"time":39331,"y":328},{"x":157,"time":39347,"y":330},{"x":158,"time":39371,"y":331},{"x":160,"time":39378,"y":332},{"x":162,"time":39403,"y":333},{"x":163,"time":39411,"y":333},{"x":165,"time":39421,"y":334},{"x":166,"time":39435,"y":334},{"x":168,"time":39451,"y":336},{"x":170,"time":39475,"y":337},{"x":172,"time":39483,"y":337},{"x":173,"time":39491,"y":338},{"x":175,"time":39515,"y":339},{"x":176,"time":39523,"y":339},{"x":179,"time":39539,"y":339},{"x":180,"time":39563,"y":340},{"x":181,"time":39571,"y":341},{"x":183,"time":39595,"y":341},{"x":184,"time":39603,"y":341},{"x":186,"time":39622,"y":341},{"x":187,"time":39651,"y":341},{"x":189,"time":39674,"y":341},{"x":190,"time":39691,"y":340},{"x":191,"time":39723,"y":340},{"x":194,"time":39747,"y":340},{"x":195,"time":39771,"y":340},{"x":196,"time":39827,"y":340},{"x":198,"time":39867,"y":339},{"x":199,"time":39891,"y":339},{"x":200,"time":39922,"y":339},{"x":201,"time":39930,"y":339},{"x":203,"time":39956,"y":338}],"fx":154,"id":0},{"type":"draw","col":16763954,"time":41451,"fy":339,"childlist":[{"x":191,"time":41554,"y":340},{"x":191,"time":41587,"y":341},{"x":191,"time":41603,"y":342},{"x":190,"time":41626,"y":344},{"x":190,"time":41634,"y":345},{"x":190,"time":41642,"y":346},{"x":190,"time":41666,"y":348},{"x":190,"time":41674,"y":349},{"x":190,"time":41691,"y":350},{"x":189,"time":41706,"y":351},{"x":189,"time":41722,"y":354},{"x":188,"time":41731,"y":355},{"x":188,"time":41747,"y":357},{"x":188,"time":41755,"y":358},{"x":188,"time":41762,"y":361},{"x":188,"time":41771,"y":362},{"x":188,"time":41789,"y":363},{"x":188,"time":41794,"y":364},{"x":187,"time":41802,"y":366},{"x":187,"time":41821,"y":367},{"x":187,"time":41827,"y":368},{"x":186,"time":41834,"y":370},{"x":186,"time":41842,"y":371},{"x":186,"time":41859,"y":373},{"x":186,"time":41867,"y":374},{"x":186,"time":41874,"y":376},{"x":186,"time":41882,"y":377},{"x":186,"time":41899,"y":378},{"x":186,"time":41907,"y":380},{"x":186,"time":41922,"y":381},{"x":186,"time":41939,"y":382},{"x":186,"time":41955,"y":383},{"x":186,"time":41962,"y":385},{"x":186,"time":41988,"y":386},{"x":186,"time":41995,"y":387},{"x":186,"time":42020,"y":389},{"x":186,"time":42035,"y":390},{"x":186,"time":42059,"y":391},{"x":187,"time":42090,"y":393},{"x":187,"time":42107,"y":395},{"x":188,"time":42130,"y":396},{"x":188,"time":42147,"y":397},{"x":190,"time":42178,"y":398},{"x":191,"time":42210,"y":399},{"x":192,"time":42235,"y":400},{"x":192,"time":42275,"y":402},{"x":193,"time":42298,"y":403},{"x":194,"time":42338,"y":404},{"x":196,"time":42378,"y":404},{"x":197,"time":42411,"y":403},{"x":198,"time":42451,"y":401},{"x":199,"time":42483,"y":400},{"x":200,"time":42506,"y":399},{"x":200,"time":42539,"y":397},{"x":200,"time":42579,"y":396},{"x":199,"time":42603,"y":395},{"x":199,"time":42619,"y":393},{"x":199,"time":42699,"y":394},{"x":199,"time":42755,"y":395},{"x":199,"time":42770,"y":396},{"x":200,"time":42794,"y":398},{"x":201,"time":42822,"y":399},{"x":203,"time":42850,"y":401},{"x":204,"time":42874,"y":401},{"x":205,"time":42890,"y":401},{"x":207,"time":42922,"y":401},{"x":208,"time":42988,"y":400},{"x":209,"time":43027,"y":398},{"x":208,"time":43050,"y":397},{"x":208,"time":43075,"y":396},{"x":207,"time":43090,"y":394},{"x":207,"time":43283,"y":395},{"x":209,"time":43315,"y":397},{"x":210,"time":43346,"y":399},{"x":212,"time":43371,"y":399},{"x":214,"time":43403,"y":399},{"x":215,"time":43426,"y":399},{"x":216,"time":43474,"y":399},{"x":218,"time":43514,"y":398},{"x":218,"time":43555,"y":397},{"x":218,"time":43595,"y":395},{"x":218,"time":43634,"y":394},{"x":218,"time":43666,"y":393},{"x":217,"time":43706,"y":391},{"x":217,"time":43722,"y":390},{"x":217,"time":43747,"y":389},{"x":217,"time":43762,"y":387},{"x":217,"time":43789,"y":386},{"x":216,"time":43810,"y":385},{"x":216,"time":43834,"y":384},{"x":216,"time":43850,"y":382},{"x":216,"time":43867,"y":381},{"x":216,"time":43890,"y":380},{"x":215,"time":43907,"y":378},{"x":215,"time":43930,"y":376},{"x":215,"time":43947,"y":374},{"x":215,"time":43956,"y":373},{"x":215,"time":43978,"y":371},{"x":215,"time":43995,"y":369},{"x":215,"time":44023,"y":368},{"x":215,"time":44027,"y":367},{"x":216,"time":44050,"y":365},{"x":217,"time":44067,"y":364},{"x":217,"time":44091,"y":363},{"x":217,"time":44098,"y":361},{"x":217,"time":44123,"y":360},{"x":218,"time":44138,"y":359},{"x":219,"time":44163,"y":357},{"x":219,"time":44188,"y":356},{"x":219,"time":44210,"y":355},{"x":220,"time":44226,"y":353},{"x":220,"time":44250,"y":352},{"x":221,"time":44266,"y":351},{"x":221,"time":44315,"y":349},{"x":221,"time":44331,"y":348},{"x":223,"time":44371,"y":347},{"x":223,"time":44403,"y":345},{"x":223,"time":44443,"y":344},{"x":224,"time":44474,"y":343},{"x":225,"time":44539,"y":341},{"x":226,"time":44690,"y":340},{"x":227,"time":44755,"y":338},{"x":228,"time":44803,"y":337},{"x":228,"time":44842,"y":336},{"x":230,"time":44890,"y":335},{"x":231,"time":45050,"y":334},{"x":232,"time":45106,"y":333},{"x":232,"time":45127,"y":332},{"x":233,"time":45163,"y":330},{"x":235,"time":45203,"y":329},{"x":235,"time":45226,"y":328},{"x":236,"time":45258,"y":326},{"x":237,"time":45283,"y":325},{"x":236,"time":45418,"y":324}],"fx":191,"id":0},{"type":"draw","col":16763954,"time":46995,"fy":175,"childlist":[{"x":260,"time":47115,"y":176},{"x":261,"time":47146,"y":177},{"x":263,"time":47178,"y":178},{"x":264,"time":47194,"y":179},{"x":265,"time":47226,"y":180},{"x":267,"time":47250,"y":181},{"x":268,"time":47266,"y":183},{"x":270,"time":47290,"y":183},{"x":271,"time":47306,"y":185},{"x":272,"time":47331,"y":186},{"x":273,"time":47347,"y":187},{"x":274,"time":47371,"y":188},{"x":276,"time":47388,"y":189},{"x":277,"time":47411,"y":190},{"x":279,"time":47426,"y":192},{"x":280,"time":47450,"y":193},{"x":281,"time":47458,"y":195},{"x":282,"time":47482,"y":196},{"x":284,"time":47498,"y":198},{"x":284,"time":47514,"y":199},{"x":285,"time":47530,"y":200},{"x":286,"time":47555,"y":202},{"x":286,"time":47570,"y":203},{"x":287,"time":47578,"y":204},{"x":288,"time":47602,"y":207},{"x":289,"time":47619,"y":209},{"x":290,"time":47642,"y":211},{"x":290,"time":47650,"y":212},{"x":291,"time":47674,"y":214},{"x":291,"time":47682,"y":215},{"x":292,"time":47698,"y":216},{"x":293,"time":47722,"y":218},{"x":294,"time":47747,"y":221},{"x":294,"time":47762,"y":222},{"x":295,"time":47789,"y":223},{"x":296,"time":47802,"y":226},{"x":296,"time":47827,"y":227},{"x":296,"time":47834,"y":228},{"x":296,"time":47850,"y":230},{"x":297,"time":47874,"y":232},{"x":297,"time":47890,"y":233},{"x":297,"time":47915,"y":234},{"x":297,"time":47922,"y":236},{"x":298,"time":47946,"y":238},{"x":298,"time":47956,"y":239},{"x":299,"time":47970,"y":241},{"x":299,"time":47988,"y":243},{"x":299,"time":47994,"y":244},{"x":299,"time":48002,"y":245},{"x":299,"time":48022,"y":246},{"x":300,"time":48034,"y":249},{"x":300,"time":48060,"y":251},{"x":300,"time":48074,"y":253},{"x":300,"time":48082,"y":254},{"x":301,"time":48106,"y":256},{"x":301,"time":48114,"y":258},{"x":301,"time":48138,"y":260},{"x":301,"time":48146,"y":261},{"x":301,"time":48163,"y":263},{"x":301,"time":48178,"y":265},{"x":301,"time":48194,"y":266},{"x":301,"time":48202,"y":267},{"x":301,"time":48218,"y":268},{"x":301,"time":48234,"y":271},{"x":301,"time":48258,"y":273},{"x":301,"time":48274,"y":274},{"x":301,"time":48290,"y":275},{"x":301,"time":48306,"y":277},{"x":301,"time":48331,"y":280},{"x":301,"time":48346,"y":281},{"x":301,"time":48355,"y":282},{"x":301,"time":48378,"y":284},{"x":301,"time":48395,"y":286},{"x":301,"time":48418,"y":289},{"x":301,"time":48434,"y":290},{"x":301,"time":48450,"y":291},{"x":301,"time":48466,"y":293},{"x":300,"time":48490,"y":295},{"x":300,"time":48506,"y":298},{"x":299,"time":48530,"y":300},{"x":299,"time":48546,"y":301},{"x":299,"time":48562,"y":302},{"x":299,"time":48578,"y":304},{"x":299,"time":48602,"y":305},{"x":298,"time":48618,"y":307},{"x":298,"time":48642,"y":308},{"x":298,"time":48658,"y":310},{"x":297,"time":48665,"y":311},{"x":297,"time":48691,"y":312},{"x":297,"time":48723,"y":314},{"x":297,"time":48738,"y":315},{"x":297,"time":48762,"y":316},{"x":297,"time":48794,"y":318},{"x":297,"time":48810,"y":319},{"x":296,"time":48834,"y":320},{"x":296,"time":48850,"y":321},{"x":296,"time":48882,"y":323},{"x":296,"time":48962,"y":321}],"fx":259,"id":0},{"type":"draw","col":16763954,"time":49810,"fy":287,"childlist":[{"x":270,"time":49898,"y":288},{"x":270,"time":49906,"y":289},{"x":270,"time":49931,"y":290},{"x":270,"time":49938,"y":292},{"x":269,"time":49962,"y":294},{"x":268,"time":49978,"y":296},{"x":268,"time":49989,"y":297},{"x":268,"time":50011,"y":300},{"x":268,"time":50018,"y":301},{"x":267,"time":50037,"y":302},{"x":267,"time":50042,"y":304},{"x":266,"time":50050,"y":305},{"x":266,"time":50058,"y":306},{"x":265,"time":50082,"y":309},{"x":265,"time":50094,"y":311},{"x":264,"time":50100,"y":312},{"x":264,"time":50114,"y":313},{"x":263,"time":50123,"y":315},{"x":263,"time":50130,"y":316},{"x":262,"time":50155,"y":317},{"x":261,"time":50170,"y":320},{"x":260,"time":50194,"y":322},{"x":259,"time":50210,"y":324},{"x":257,"time":50234,"y":326},{"x":257,"time":50249,"y":328},{"x":255,"time":50274,"y":328},{"x":254,"time":50290,"y":330},{"x":253,"time":50314,"y":331},{"x":251,"time":50330,"y":332},{"x":250,"time":50355,"y":333},{"x":248,"time":50370,"y":334},{"x":247,"time":50394,"y":335},{"x":246,"time":50410,"y":336},{"x":244,"time":50442,"y":337},{"x":243,"time":50466,"y":337},{"x":242,"time":50482,"y":338},{"x":240,"time":50506,"y":339},{"x":239,"time":50538,"y":339},{"x":238,"time":50555,"y":339},{"x":236,"time":50588,"y":340},{"x":235,"time":50626,"y":340},{"x":234,"time":50658,"y":340},{"x":232,"time":50698,"y":341},{"x":231,"time":50738,"y":342},{"x":230,"time":50770,"y":342},{"x":228,"time":50810,"y":342},{"x":227,"time":50858,"y":342},{"x":228,"time":50938,"y":341}],"fx":271,"id":0},{"type":"draw","col":16763954,"time":52106,"fy":336,"childlist":[{"x":248,"time":52322,"y":337},{"x":249,"time":52355,"y":339},{"x":249,"time":52362,"y":340},{"x":249,"time":52389,"y":341},{"x":250,"time":52394,"y":343},{"x":250,"time":52417,"y":344},{"x":251,"time":52434,"y":346},{"x":252,"time":52457,"y":348},{"x":252,"time":52466,"y":349},{"x":253,"time":52490,"y":350},{"x":254,"time":52498,"y":352},{"x":255,"time":52514,"y":352},{"x":255,"time":52530,"y":354},{"x":256,"time":52545,"y":355},{"x":257,"time":52570,"y":357},{"x":259,"time":52588,"y":357},{"x":259,"time":52618,"y":359},{"x":261,"time":52642,"y":359},{"x":262,"time":52658,"y":359},{"x":263,"time":52682,"y":360},{"x":265,"time":52698,"y":361},{"x":265,"time":52730,"y":362},{"x":267,"time":52746,"y":362},{"x":268,"time":52778,"y":363},{"x":269,"time":52818,"y":364},{"x":269,"time":52930,"y":365},{"x":269,"time":52970,"y":367},{"x":269,"time":53058,"y":368},{"x":269,"time":53090,"y":369},{"x":269,"time":53123,"y":371},{"x":268,"time":53171,"y":372},{"x":267,"time":53234,"y":373},{"x":266,"time":53282,"y":375},{"x":266,"time":53337,"y":376},{"x":264,"time":53377,"y":377},{"x":264,"time":53410,"y":378},{"x":263,"time":53450,"y":379},{"x":262,"time":53482,"y":381},{"x":260,"time":53514,"y":382},{"x":260,"time":53545,"y":383},{"x":258,"time":53570,"y":384},{"x":257,"time":53610,"y":386},{"x":256,"time":53634,"y":387},{"x":256,"time":53650,"y":388},{"x":256,"time":53673,"y":390},{"x":256,"time":53690,"y":391},{"x":256,"time":53713,"y":392},{"x":256,"time":53730,"y":394},{"x":256,"time":53746,"y":395},{"x":258,"time":53763,"y":396},{"x":258,"time":53789,"y":397},{"x":259,"time":53826,"y":398},{"x":260,"time":53841,"y":398},{"x":261,"time":53866,"y":398},{"x":263,"time":53881,"y":398},{"x":264,"time":53906,"y":397},{"x":265,"time":53922,"y":396},{"x":266,"time":53970,"y":395},{"x":264,"time":54106,"y":395},{"x":264,"time":54138,"y":396},{"x":264,"time":54156,"y":398},{"x":265,"time":54194,"y":398},{"x":266,"time":54217,"y":399},{"x":268,"time":54249,"y":399},{"x":269,"time":54266,"y":399},{"x":270,"time":54290,"y":398},{"x":271,"time":54306,"y":396},{"x":272,"time":54330,"y":395},{"x":273,"time":54377,"y":394},{"x":273,"time":54538,"y":395},{"x":273,"time":54578,"y":396},{"x":274,"time":54610,"y":397},{"x":275,"time":54665,"y":398},{"x":276,"time":54713,"y":399},{"x":277,"time":54756,"y":399},{"x":278,"time":54770,"y":397},{"x":280,"time":54810,"y":396},{"x":281,"time":54841,"y":396},{"x":282,"time":54859,"y":394},{"x":283,"time":54881,"y":393},{"x":285,"time":54930,"y":391},{"x":286,"time":54961,"y":390},{"x":287,"time":54978,"y":389},{"x":288,"time":55009,"y":388},{"x":288,"time":55034,"y":387},{"x":289,"time":55049,"y":386},{"x":290,"time":55074,"y":385},{"x":291,"time":55089,"y":383},{"x":292,"time":55114,"y":382},{"x":292,"time":55146,"y":381},{"x":294,"time":55169,"y":379},{"x":294,"time":55202,"y":378},{"x":296,"time":55226,"y":376},{"x":296,"time":55242,"y":375},{"x":297,"time":55266,"y":374},{"x":298,"time":55290,"y":372},{"x":298,"time":55323,"y":371},{"x":299,"time":55356,"y":370},{"x":299,"time":55362,"y":368},{"x":300,"time":55394,"y":367},{"x":301,"time":55425,"y":366},{"x":301,"time":55442,"y":364},{"x":301,"time":55474,"y":363},{"x":301,"time":55505,"y":362},{"x":301,"time":55538,"y":360},{"x":301,"time":55562,"y":359},{"x":301,"time":55593,"y":358},{"x":301,"time":55625,"y":356},{"x":301,"time":55658,"y":355},{"x":301,"time":55681,"y":354},{"x":301,"time":55730,"y":353},{"x":301,"time":55756,"y":351},{"x":299,"time":55793,"y":351},{"x":298,"time":55850,"y":349},{"x":297,"time":55899,"y":348},{"x":296,"time":55938,"y":347},{"x":296,"time":56034,"y":345},{"x":295,"time":56129,"y":344},{"x":295,"time":56169,"y":343},{"x":295,"time":56202,"y":341},{"x":295,"time":56217,"y":340},{"x":295,"time":56249,"y":339},{"x":296,"time":56290,"y":337},{"x":296,"time":56305,"y":336},{"x":296,"time":56337,"y":335},{"x":296,"time":56370,"y":333},{"x":297,"time":56417,"y":332},{"x":297,"time":56450,"y":331},{"x":297,"time":56490,"y":329},{"x":297,"time":56530,"y":328},{"x":297,"time":56578,"y":327},{"x":297,"time":56633,"y":326},{"x":297,"time":56673,"y":324},{"x":297,"time":56698,"y":323},{"x":297,"time":56738,"y":322},{"x":297,"time":56849,"y":320}],"fx":248,"id":0},{"type":"draw","col":16763954,"time":58081,"fy":345,"childlist":[{"x":246,"time":58169,"y":346},{"x":246,"time":58217,"y":347},{"x":246,"time":58249,"y":348},{"x":245,"time":58257,"y":350},{"x":245,"time":58273,"y":351},{"x":245,"time":58290,"y":352},{"x":244,"time":58297,"y":354},{"x":243,"time":58323,"y":356},{"x":243,"time":58330,"y":357},{"x":243,"time":58356,"y":359},{"x":242,"time":58370,"y":361},{"x":241,"time":58393,"y":363},{"x":241,"time":58402,"y":364},{"x":241,"time":58425,"y":366},{"x":239,"time":58442,"y":368},{"x":238,"time":58465,"y":370},{"x":237,"time":58481,"y":372},{"x":236,"time":58490,"y":374},{"x":236,"time":58505,"y":375},{"x":235,"time":58523,"y":377},{"x":235,"time":58545,"y":378},{"x":233,"time":58561,"y":380},{"x":233,"time":58589,"y":381},{"x":231,"time":58601,"y":383},{"x":231,"time":58625,"y":384},{"x":229,"time":58658,"y":385},{"x":228,"time":58698,"y":386},{"x":226,"time":58724,"y":387},{"x":225,"time":58761,"y":389},{"x":224,"time":58801,"y":390},{"x":223,"time":58833,"y":391},{"x":222,"time":58866,"y":392},{"x":222,"time":59017,"y":390},{"x":223,"time":59026,"y":389}],"fx":246,"id":0},{"type":"draw","col":16763954,"time":60746,"fy":208,"childlist":[{"x":288,"time":60849,"y":209},{"x":288,"time":60889,"y":210},{"x":290,"time":60923,"y":212},{"x":291,"time":60956,"y":213},{"x":291,"time":60969,"y":214},{"x":293,"time":60994,"y":216},{"x":295,"time":61009,"y":217},{"x":296,"time":61034,"y":219},{"x":299,"time":61057,"y":219},{"x":300,"time":61074,"y":220},{"x":301,"time":61097,"y":221},{"x":303,"time":61105,"y":221},{"x":304,"time":61113,"y":221},{"x":306,"time":61137,"y":222},{"x":308,"time":61157,"y":222},{"x":310,"time":61179,"y":223},{"x":313,"time":61194,"y":223},{"x":314,"time":61201,"y":223},{"x":315,"time":61217,"y":223},{"x":317,"time":61235,"y":222},{"x":319,"time":61241,"y":222},{"x":321,"time":61265,"y":222},{"x":322,"time":61273,"y":222},{"x":324,"time":61297,"y":221},{"x":325,"time":61305,"y":221},{"x":327,"time":61313,"y":220},{"x":328,"time":61330,"y":220},{"x":330,"time":61337,"y":220},{"x":331,"time":61345,"y":219},{"x":333,"time":61370,"y":218},{"x":334,"time":61389,"y":217},{"x":337,"time":61410,"y":215},{"x":338,"time":61425,"y":213},{"x":340,"time":61449,"y":212},{"x":341,"time":61465,"y":210},{"x":343,"time":61490,"y":208},{"x":343,"time":61505,"y":207},{"x":344,"time":61529,"y":205},{"x":345,"time":61545,"y":204},{"x":345,"time":61556,"y":203},{"x":345,"time":61578,"y":201},{"x":346,"time":61601,"y":199},{"x":346,"time":61618,"y":197},{"x":347,"time":61641,"y":195},{"x":347,"time":61649,"y":193},{"x":347,"time":61658,"y":192},{"x":347,"time":61681,"y":190},{"x":347,"time":61697,"y":189},{"x":346,"time":61723,"y":187},{"x":345,"time":61737,"y":186},{"x":344,"time":61746,"y":185},{"x":344,"time":61761,"y":183},{"x":344,"time":61777,"y":182},{"x":344,"time":61801,"y":181},{"x":345,"time":61905,"y":181},{"x":346,"time":61937,"y":182},{"x":348,"time":61961,"y":183},{"x":348,"time":61969,"y":185},{"x":349,"time":61977,"y":186},{"x":350,"time":61994,"y":187},{"x":350,"time":62001,"y":189},{"x":351,"time":62009,"y":190},{"x":352,"time":62017,"y":192},{"x":352,"time":62034,"y":193},{"x":353,"time":62041,"y":194},{"x":354,"time":62049,"y":196},{"x":354,"time":62057,"y":197},{"x":355,"time":62073,"y":199},{"x":355,"time":62081,"y":200},{"x":355,"time":62089,"y":203},{"x":355,"time":62105,"y":204},{"x":355,"time":62113,"y":205},{"x":354,"time":62123,"y":207},{"x":354,"time":62129,"y":209},{"x":353,"time":62145,"y":211},{"x":353,"time":62157,"y":213},{"x":353,"time":62161,"y":215},{"x":352,"time":62169,"y":216},{"x":352,"time":62190,"y":219},{"x":351,"time":62202,"y":221},{"x":350,"time":62209,"y":223},{"x":349,"time":62225,"y":224},{"x":349,"time":62233,"y":226},{"x":348,"time":62241,"y":227},{"x":347,"time":62265,"y":229},{"x":345,"time":62281,"y":231},{"x":344,"time":62290,"y":231},{"x":342,"time":62313,"y":231},{"x":340,"time":62324,"y":231},{"x":339,"time":62345,"y":231},{"x":340,"time":62433,"y":232},{"x":341,"time":62457,"y":234},{"x":341,"time":62465,"y":235},{"x":341,"time":62473,"y":236},{"x":342,"time":62498,"y":238},{"x":342,"time":62505,"y":240},{"x":342,"time":62513,"y":241},{"x":341,"time":62523,"y":242},{"x":340,"time":62538,"y":244},{"x":340,"time":62545,"y":247},{"x":339,"time":62556,"y":248},{"x":338,"time":62561,"y":249},{"x":337,"time":62578,"y":251},{"x":335,"time":62593,"y":252},{"x":333,"time":62609,"y":253},{"x":331,"time":62617,"y":254},{"x":330,"time":62625,"y":254},{"x":328,"time":62633,"y":254},{"x":327,"time":62649,"y":254},{"x":325,"time":62665,"y":254},{"x":324,"time":62706,"y":252},{"x":323,"time":62737,"y":251},{"x":324,"time":62793,"y":250},{"x":325,"time":62818,"y":251},{"x":325,"time":62833,"y":253},{"x":325,"time":62857,"y":255},{"x":325,"time":62865,"y":256},{"x":324,"time":62889,"y":258},{"x":323,"time":62897,"y":259},{"x":322,"time":62905,"y":260},{"x":320,"time":62929,"y":261},{"x":317,"time":62937,"y":261},{"x":316,"time":62945,"y":262},{"x":314,"time":62961,"y":263},{"x":312,"time":62969,"y":264},{"x":310,"time":62977,"y":264},{"x":309,"time":62990,"y":264},{"x":308,"time":63001,"y":264},{"x":306,"time":63017,"y":262},{"x":305,"time":63025,"y":261},{"x":304,"time":63041,"y":261},{"x":302,"time":63057,"y":260},{"x":301,"time":63097,"y":259}],"fx":287,"id":0},{"type":"draw","col":16763954,"time":64190,"fy":220,"childlist":[{"x":139,"time":64249,"y":221},{"x":139,"time":64281,"y":222},{"x":138,"time":64297,"y":223},{"x":138,"time":64305,"y":225},{"x":138,"time":64329,"y":226},{"x":138,"time":64337,"y":227},{"x":138,"time":64358,"y":229},{"x":139,"time":64369,"y":231},{"x":139,"time":64377,"y":232},{"x":140,"time":64394,"y":233},{"x":140,"time":64401,"y":235},{"x":140,"time":64409,"y":236},{"x":141,"time":64418,"y":238},{"x":141,"time":64435,"y":240},{"x":142,"time":64441,"y":241},{"x":142,"time":64451,"y":242},{"x":143,"time":64473,"y":244},{"x":143,"time":64481,"y":246},{"x":144,"time":64495,"y":247},{"x":144,"time":64497,"y":248},{"x":145,"time":64525,"y":251},{"x":146,"time":64545,"y":253},{"x":148,"time":64561,"y":254},{"x":149,"time":64590,"y":256},{"x":150,"time":64601,"y":258},{"x":151,"time":64625,"y":259},{"x":152,"time":64641,"y":261},{"x":153,"time":64665,"y":262},{"x":155,"time":64681,"y":263},{"x":156,"time":64705,"y":265},{"x":157,"time":64713,"y":265},{"x":158,"time":64729,"y":266},{"x":159,"time":64757,"y":266},{"x":161,"time":64769,"y":267},{"x":162,"time":64793,"y":267},{"x":163,"time":64833,"y":268},{"x":162,"time":64914,"y":268}],"fx":140,"id":0},{"type":"draw","col":16763954,"time":65538,"fy":265,"childlist":[{"x":215,"time":65617,"y":265},{"x":217,"time":65801,"y":265},{"x":218,"time":65817,"y":265},{"x":219,"time":65841,"y":264},{"x":222,"time":65857,"y":263},{"x":223,"time":65881,"y":262},{"x":224,"time":65890,"y":262},{"x":226,"time":65905,"y":262},{"x":227,"time":65924,"y":261},{"x":228,"time":65937,"y":260},{"x":231,"time":65961,"y":259},{"x":232,"time":65977,"y":257},{"x":233,"time":66000,"y":257},{"x":235,"time":66017,"y":256},{"x":235,"time":66040,"y":255},{"x":237,"time":66058,"y":253},{"x":238,"time":66081,"y":252},{"x":239,"time":66097,"y":250},{"x":240,"time":66129,"y":249},{"x":241,"time":66158,"y":248},{"x":242,"time":66168,"y":246},{"x":243,"time":66193,"y":245},{"x":244,"time":66208,"y":243},{"x":245,"time":66241,"y":241},{"x":246,"time":66273,"y":240},{"x":247,"time":66305,"y":239},{"x":247,"time":66329,"y":237},{"x":246,"time":66449,"y":237}],"fx":217,"id":0},{"type":"draw","col":16763954,"time":67465,"fy":265,"childlist":[{"x":206,"time":67525,"y":264},{"x":207,"time":67601,"y":265},{"x":207,"time":67619,"y":266},{"x":207,"time":67633,"y":267},{"x":208,"time":67641,"y":269},{"x":208,"time":67649,"y":270},{"x":208,"time":67658,"y":271},{"x":208,"time":67672,"y":273},{"x":208,"time":67680,"y":274},{"x":208,"time":67690,"y":275},{"x":208,"time":67697,"y":277},{"x":207,"time":67724,"y":279},{"x":207,"time":67737,"y":281},{"x":207,"time":67761,"y":282},{"x":206,"time":67769,"y":284},{"x":206,"time":67792,"y":285},{"x":205,"time":67800,"y":286},{"x":205,"time":67825,"y":288},{"x":203,"time":67840,"y":288},{"x":201,"time":67865,"y":289},{"x":200,"time":67880,"y":290},{"x":198,"time":67905,"y":290},{"x":196,"time":67929,"y":289},{"x":195,"time":67960,"y":287},{"x":194,"time":67985,"y":284},{"x":194,"time":67993,"y":283},{"x":193,"time":68000,"y":281},{"x":193,"time":68025,"y":279},{"x":193,"time":68033,"y":277},{"x":193,"time":68040,"y":276},{"x":193,"time":68065,"y":275},{"x":193,"time":68073,"y":273},{"x":194,"time":68097,"y":272},{"x":194,"time":68105,"y":271},{"x":195,"time":68137,"y":269},{"x":196,"time":68158,"y":268},{"x":198,"time":68177,"y":267},{"x":200,"time":68190,"y":266},{"x":202,"time":68201,"y":266},{"x":204,"time":68225,"y":266},{"x":206,"time":68241,"y":266},{"x":207,"time":68265,"y":267},{"x":209,"time":68281,"y":268},{"x":210,"time":68305,"y":270},{"x":210,"time":68313,"y":271},{"x":210,"time":68336,"y":272},{"x":210,"time":68357,"y":274},{"x":210,"time":68369,"y":276},{"x":209,"time":68392,"y":278},{"x":208,"time":68416,"y":279},{"x":207,"time":68462,"y":276}],"fx":206,"id":0},{"type":"draw","col":16763954,"time":70105,"fy":92,"childlist":[{"x":355,"time":70241,"y":92},{"x":356,"time":70248,"y":93},{"x":357,"time":70257,"y":93},{"x":360,"time":70264,"y":94},{"x":362,"time":70281,"y":94},{"x":365,"time":70290,"y":94},{"x":367,"time":70297,"y":94},{"x":370,"time":70304,"y":95},{"x":373,"time":70325,"y":96},{"x":375,"time":70329,"y":96},{"x":377,"time":70336,"y":97},{"x":382,"time":70362,"y":97},{"x":383,"time":70369,"y":97},{"x":385,"time":70393,"y":97},{"x":387,"time":70441,"y":98},{"x":385,"time":70512,"y":98}],"fx":354,"id":0},{"type":"draw","col":16763954,"time":70769,"fy":81,"childlist":[{"x":371,"time":70849,"y":83},{"x":371,"time":70865,"y":84},{"x":371,"time":70873,"y":85},{"x":371,"time":70880,"y":87},{"x":371,"time":70890,"y":90},{"x":371,"time":70905,"y":93},{"x":371,"time":70913,"y":97},{"x":371,"time":70924,"y":101},{"x":372,"time":70937,"y":106},{"x":372,"time":70945,"y":110},{"x":372,"time":70957,"y":115},{"x":372,"time":70960,"y":117},{"x":372,"time":70977,"y":120},{"x":372,"time":70985,"y":123},{"x":372,"time":70993,"y":125},{"x":372,"time":71000,"y":127},{"x":372,"time":71016,"y":128},{"x":372,"time":71025,"y":130},{"x":372,"time":71081,"y":128},{"x":371,"time":71105,"y":127}],"fx":372,"id":0},{"type":"draw","col":16763954,"time":71258,"fy":109,"childlist":[{"x":361,"time":71273,"y":108},{"x":361,"time":71313,"y":109},{"x":359,"time":71336,"y":111},{"x":358,"time":71361,"y":112},{"x":357,"time":71376,"y":114},{"x":355,"time":71390,"y":115},{"x":354,"time":71401,"y":116},{"x":352,"time":71409,"y":117},{"x":350,"time":71416,"y":117},{"x":349,"time":71429,"y":117},{"x":348,"time":71441,"y":117},{"x":346,"time":71449,"y":118},{"x":345,"time":71481,"y":118},{"x":346,"time":71497,"y":117},{"x":348,"time":71526,"y":116},{"x":349,"time":71529,"y":116}],"fx":362,"id":0},{"type":"draw","col":16763954,"time":71681,"fy":113,"childlist":[{"x":382,"time":71724,"y":113},{"x":383,"time":71758,"y":115},{"x":385,"time":71760,"y":116},{"x":386,"time":71768,"y":118},{"x":387,"time":71777,"y":119},{"x":389,"time":71792,"y":120},{"x":390,"time":71800,"y":122},{"x":392,"time":71808,"y":123},{"x":393,"time":71832,"y":125},{"x":391,"time":71890,"y":122}],"fx":381,"id":0},{"type":"draw","col":16763954,"time":72040,"fy":98,"childlist":[{"x":391,"time":72113,"y":99},{"x":391,"time":72136,"y":101},{"x":393,"time":72158,"y":103},{"x":395,"time":72176,"y":105},{"x":396,"time":72190,"y":106},{"x":397,"time":72193,"y":106},{"x":398,"time":72201,"y":106},{"x":400,"time":72216,"y":105},{"x":402,"time":72233,"y":103},{"x":402,"time":72241,"y":102},{"x":402,"time":72264,"y":100},{"x":402,"time":72272,"y":99},{"x":402,"time":72281,"y":97},{"x":400,"time":72304,"y":95},{"x":398,"time":72325,"y":94},{"x":396,"time":72344,"y":93},{"x":393,"time":72369,"y":93},{"x":392,"time":72384,"y":93},{"x":391,"time":72409,"y":95},{"x":390,"time":72416,"y":96},{"x":389,"time":72425,"y":97},{"x":389,"time":72432,"y":99},{"x":389,"time":72449,"y":100},{"x":389,"time":72464,"y":101},{"x":390,"time":72491,"y":102},{"x":390,"time":72512,"y":101}],"fx":392,"id":0},{"type":"draw","col":16763954,"time":72937,"fy":158,"childlist":[{"x":389,"time":72968,"y":156},{"x":387,"time":73073,"y":156},{"x":386,"time":73091,"y":157},{"x":384,"time":73113,"y":158},{"x":382,"time":73124,"y":159},{"x":381,"time":73129,"y":160},{"x":379,"time":73144,"y":161},{"x":377,"time":73158,"y":162},{"x":375,"time":73168,"y":163},{"x":374,"time":73193,"y":163},{"x":373,"time":73241,"y":161}],"fx":388,"id":0},{"type":"draw","col":16763954,"time":73492,"fy":174,"childlist":[{"x":366,"time":73537,"y":172},{"x":367,"time":73558,"y":172},{"x":370,"time":73577,"y":172},{"x":372,"time":73592,"y":172},{"x":373,"time":73608,"y":172},{"x":375,"time":73617,"y":172},{"x":377,"time":73625,"y":171},{"x":379,"time":73632,"y":171},{"x":383,"time":73648,"y":171},{"x":384,"time":73658,"y":171},{"x":386,"time":73665,"y":172},{"x":388,"time":73680,"y":172},{"x":390,"time":73691,"y":173},{"x":392,"time":73697,"y":173},{"x":393,"time":73705,"y":173},{"x":394,"time":73725,"y":173},{"x":396,"time":73728,"y":173},{"x":397,"time":73736,"y":173},{"x":398,"time":73760,"y":172},{"x":396,"time":73880,"y":172}],"fx":366,"id":0},{"type":"draw","col":16763954,"time":74125,"fy":159,"childlist":[{"x":388,"time":74201,"y":160},{"x":388,"time":74233,"y":161},{"x":388,"time":74240,"y":162},{"x":387,"time":74248,"y":164},{"x":387,"time":74264,"y":165},{"x":387,"time":74272,"y":166},{"x":387,"time":74281,"y":168},{"x":387,"time":74291,"y":169},{"x":387,"time":74304,"y":170},{"x":387,"time":74312,"y":172},{"x":387,"time":74326,"y":174},{"x":387,"time":74329,"y":175},{"x":386,"time":74344,"y":176},{"x":386,"time":74358,"y":177},{"x":386,"time":74360,"y":179},{"x":385,"time":74369,"y":180},{"x":385,"time":74391,"y":181},{"x":384,"time":74400,"y":184},{"x":383,"time":74409,"y":185},{"x":382,"time":74432,"y":186},{"x":380,"time":74449,"y":188},{"x":379,"time":74464,"y":188},{"x":377,"time":74480,"y":189},{"x":376,"time":74497,"y":189},{"x":374,"time":74504,"y":190},{"x":373,"time":74537,"y":190},{"x":374,"time":74592,"y":188},{"x":375,"time":74617,"y":187}],"fx":388,"id":0},{"type":"draw","col":16763954,"time":75008,"fy":222,"childlist":[{"x":384,"time":75025,"y":222},{"x":384,"time":75081,"y":224},{"x":384,"time":75091,"y":225},{"x":384,"time":75096,"y":227},{"x":384,"time":75104,"y":229},{"x":384,"time":75125,"y":233},{"x":384,"time":75128,"y":235},{"x":383,"time":75136,"y":238},{"x":383,"time":75159,"y":241},{"x":383,"time":75161,"y":244},{"x":383,"time":75168,"y":246},{"x":383,"time":75176,"y":247},{"x":382,"time":75193,"y":248},{"x":382,"time":75201,"y":250},{"x":381,"time":75216,"y":250},{"x":379,"time":75241,"y":250},{"x":377,"time":75248,"y":250},{"x":375,"time":75272,"y":250},{"x":374,"time":75291,"y":251},{"x":372,"time":75312,"y":251},{"x":370,"time":75329,"y":251},{"x":369,"time":75344,"y":251},{"x":368,"time":75358,"y":252},{"x":366,"time":75361,"y":251},{"x":365,"time":75368,"y":251},{"x":364,"time":75384,"y":251},{"x":362,"time":75401,"y":251},{"x":361,"time":75425,"y":250},{"x":360,"time":75440,"y":250},{"x":358,"time":75464,"y":250},{"x":359,"time":75568,"y":249},{"x":359,"time":75584,"y":248}],"fx":385,"id":0},{"type":"draw","col":16763954,"time":75785,"fy":235,"childlist":[{"x":366,"time":75873,"y":236},{"x":365,"time":75896,"y":237},{"x":364,"time":75913,"y":238},{"x":362,"time":75925,"y":240},{"x":360,"time":75944,"y":241},{"x":358,"time":75960,"y":243},{"x":356,"time":75976,"y":244},{"x":354,"time":75993,"y":246},{"x":353,"time":76000,"y":246},{"x":352,"time":76016,"y":248},{"x":351,"time":76033,"y":248},{"x":349,"time":76096,"y":249},{"x":349,"time":76248,"y":250},{"x":351,"time":76258,"y":251},{"x":353,"time":76272,"y":253},{"x":355,"time":76291,"y":255},{"x":356,"time":76296,"y":256},{"x":358,"time":76304,"y":257},{"x":360,"time":76326,"y":259},{"x":362,"time":76329,"y":260},{"x":363,"time":76336,"y":261},{"x":365,"time":76360,"y":262},{"x":364,"time":76492,"y":260}],"fx":367,"id":0}]';
			
			var comList:Array = JSON.decode(comListString);
			
			_player.setCommandList(comList);
			musicStart();
			_ch.stop();
		}
		
		private function musicStart():void {
//			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars.mp3"), new SoundLoaderContext(10000, true));
			sound = new Sound(new URLRequest("http://swimmingbird.heteml.jp/wonderfl/sounds/stars_long.mp3"), new SoundLoaderContext(10000, true));
			_ch = sound.play();
			bA = new ByteArray();
			//			stage.quality = StageQuality.LOW;
			stage.fullScreenSourceRect=new Rectangle(0,0,465,465); 
			addEventListener(Event.ENTER_FRAME, updateSpectrum);
			
			//timer start
			_startTime = getTimer();
			
			/**
			 * action setup
			 */
			_field.addEventListener(MouseEvent.MOUSE_DOWN, _fieldDownHandler);
			_field.addEventListener(MouseEvent.MOUSE_UP, _fieldUpHandler);
			_field.addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			//Play Draw
			_player.addEventListener(DrawPlayer.DO_ROOT, _rootEventHandler);
			_player.addEventListener(DrawPlayer.DO_NODE, _nodeEventHandler);
			_player.addEventListener(DrawPlayer.DO_CLEAR, _clearEventHandler);
		}
		
		public function setupDisplay():void {
			addChild(_paintField);
			addChild(_field);
			addChild(_clearEffBmp);
			addChild(_uiField);
			addChild(_stopUiField);
			addChild(_startField);
			_uiField.addChild(_colSelector);
			_colSelector.x = 20;
			_colSelector.y = 85;
			_stopUiField.visible = true;
			_uiField.visible = false;
			_startField.visible = false;
		}
		/**
		 * mouse Action
		 */
		private function _fieldDownHandler(event:MouseEvent):void {
			addRoot();
			_col = _colSelector.currentColor;
			_field.addEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
			var currentTime:int = getTimer() - _startTime;
			var id:int=0;
			_rec.startLineRec(id,mouseX,mouseY,_colSelector.currentColor,currentTime);
		}
		private function _fieldUpHandler(event:MouseEvent):void {
			//今書いたものにベクトル情報追加
			_field.removeEventListener(MouseEvent.MOUSE_MOVE, _fieldMoveHandler);
		}
		private function _fieldMoveHandler(event:MouseEvent):void {
			addNode(_field.mouseX, _field.mouseY);
			//rec
			var currentTime:int = getTimer() - _startTime;
			_rec.addPoint(_field.mouseX, _field.mouseY, currentTime);
		}
		/**
		 * play Action
		 */
		private function _rootEventHandler(event:Event):void {
			addRoot();
			_col = _player.cur_Col;
		}
		private function _nodeEventHandler(event:Event):void {
			addNode(_player.cur_x, _player.cur_y);	
		}
		private function _clearEventHandler(event:Event):void {
			clear();
		}
		/**
		 * node Action
		 */
		private function addRoot():void {
			trace("adRoot");
			_currentListIndex = _pointListList.length;
			_pointListList.push(new Array());
		}
		private function addNode(px:Number, py:Number):void {
			trace("addNode");
			var _list:Array = _pointListList[_currentListIndex];
			_list.push(new LinePoint(px, py));
			var i:int = _list.length-1;
			_list[i].color = _col;
			if(_list[i-1]) {
				var _pt:LinePoint = _list[i];
				var _dx:Number = _list[i].x - _list[i-1].x;
				var _dy:Number = _list[i].y - _list[i-1].y;
				var _distance:Number = Math.sqrt(_dx*_dx+_dy*_dy);
				_pt.vx = _list[i].x - _list[i-1].x;
				_pt.vy = _list[i].y - _list[i-1].y;
				//				_pt.vx = _dx/_distance;
				//				_pt.vy = _dy/_distance;
				_pt.genRotation();
			}
		}
		private function _enterFrameHandler(event:Event):void {
			var i:int;
			var len:int = _pointListList.length;
			_paintField.graphics.clear();
			_paintField.graphics.lineStyle(1,0xFFFFFF);
			var _list:Array;
			var j:int;
			var _listlen:int;
			var nx:Number;
			var ny:Number;
			var dist:Number;
			if(_actionFlg) {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.lineStyle(1,_list[0].color);
						_paintField.graphics.moveTo(_list[0].x, _list[0].y);
						//スペクトラムずらす
						for(j=_listlen-1;j>0;j--) {
							_list[j].spectrum = _list[j-1].spectrum;
						}
						_list[0].spectrum = spectrum[10];
						for(j=0;j<_listlen;j++) {
							//							_paintField.graphics.moveTo(_list[j].x, _list[j].y);
							if(_list[j].r){
								nx = -(_list[j].vy);
								ny = _list[j].vx;
								dist = Math.sqrt(nx*nx+ny*ny);
								//							    _list[j].spectrum = spectrum[j];//スペクトラム直でまっぴんぐ
								_paintField.graphics.lineTo(_list[j].x+nx*_list[j].spectrum*7, _list[j].y+ny*_list[j].spectrum*7);
								//							    _paintField.graphics.lineTo(_list[j].x+_list[j].spectrum*2*nx/dist, _list[j].y+40*_list[j].spectrum*2*ny/dist);
							}
						}
					}
				}
			} else {
				for(i=0; i<len; i++) {
					_list = _pointListList[i];
					_listlen = _list.length;
					if(_listlen>0) {
						_paintField.graphics.moveTo(_list[0].x, _list[0].y); 
						for(j=0;j<_listlen;j++) {
							_paintField.graphics.lineTo(_list[j].x, _list[j].y);
						}
					}
				}
			}
		}
		
		private function updateSpectrum(e:Event):void {
			SoundMixer.computeSpectrum(bA,false,0);
			spectrum = [];
			var i:int;
			for(i=0; i<256; i++){
				spectrum[i] = bA.readFloat();
			}
			for(i=256; i<512; i++){
				spectrum[i] = bA.readFloat();
			}
			bA.position=0;
			lowVal = spectrum[0];
			middleVal = spectrum[1];
			highVal = spectrum[2];
		} 
		
		/**
		 * ui Action
		 */
		private function startHandler(event:MouseEvent):void {
			_startField.visible = false;
			_uiField.visible = true;
			musicStart();
		}
		private function actionHandler(event:MouseEvent):void {
			_actionFlg = true;
		}
		private function noActionHandler(event:MouseEvent):void {
			_actionFlg = false;
		}
		private function clearHandler(event:MouseEvent):void {
			_rec.addClear(getTimer()-_startTime)
			clear();
		}
		private function plotHandler(event:MouseEvent):void {
			_rec.outPut();
		}
		private function stopHandler(event:MouseEvent):void {
			_ch.stop();
			clear();
			_player.setCommandList(_rec.commandList);
			Tweener.addTween(_uiField, {_autoAlpha:0, time:0.5, transition:Equations.easeOutQuint});
			Tweener.addTween(_stopUiField, {_autoAlpha:1, time:0.5, transition:Equations.easeOutQuint});
		}
		private function playDataHandler(event:MouseEvent):void {
			_ch = sound.play(0);
			_player.playStart();
		}
		private function stopDrawHandler(event:MouseEvent):void {
			clear();
			_currentListIndex = 0;
			_ch.stop();
			_player.playStop();
		}
		public var clearCnt:Number = 0;
		private function clear():void {
			_clearBmd.fillRect(new Rectangle(0,0,465,465),0);
			_clearBmd.draw(_paintField);
			_clearEffBmp.visible = true;
			_clearEffBmp.alpha = 1;
			_clearEffBmp.scaleX = _clearEffBmp.scaleY = 1;
			Tweener.addTween(_clearEffBmp, {/*scaleX:2, scaleY:2, */_autoAlpha:0, time:1, transition:Equations.easeOutQuint});
			clearComp();
			//			var i:int;
			//			var len:int = _pointListList.length;
			//			var _list:Array;
			//			var _listlen:int;
			//			var j:int;
			//			var nx:int, ny:int;
			//			for(i=0; i<len; i++) {
			//				_list = _pointListList[i];
			//				_listlen = _list.length;
			//				for(j=0;j<_listlen;j++) {
			//					_list[j].endAction();
			//				}
			//			}
			//			Tweener.addTween(this, {clearCnt:10, time:0.8, transition:Equations.easeOutQuint, onComplete:clearComp});
		}
		private function clearComp():void {
			var i:int;
			var len:int = _pointListList.length;
			var _list:Array;
			var _listlen:int;
			var j:int;
			var nx:int, ny:int;
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_listlen = _list.length;
				for(j=0;j<_listlen;j++) {
					_list[j] = null;
				}
			}
			for(i=0; i<len; i++) {
				_list = _pointListList[i];
				_list.length = 0;
				_list = null;
			}
			_pointListList.length = 0;
			_pointListList = new Array();
		}
	}
}
import caurina.transitions.Equations;
import caurina.transitions.Tweener;

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.external.ExternalInterface;
import flash.geom.Point;
import flash.utils.Timer;
import flash.utils.getTimer;

import org.osmf.events.TimeEvent;



class LinePoint extends Point {
	public var vx:Number, vy:Number, r:Number;
	public var spectrum:Number = 0;
	public var color:Number;
	public function LinePoint(x:Number=0, y:Number=0) {
		super(x,y);
	}
	public function genRotation():void {
		r = Math.atan2(vy, vx);
	}
	public function endAction():void {
		var _targetSp:Number = spectrum * 20;
		Tweener.addTween(this, {spectrum:_targetSp, time:0.5, transition:Equations.easeOutQuint});
	}
}

class ColorSelector extends Sprite {
	public var colorList:Array = new Array();
	public var currentColor:Number = 0xFFFF32;
	private var _colTotal:int = 5;
	private var _selectedColor:Sprite = new Sprite();
	
	public function ColorSelector() {
		init();
		setupDisplay();
	}
	public function init():void {
		var i:int;
		for(i=0; i<_colTotal; i++) {
			var block:Sprite = new Sprite();
			//			block.name = String(0xFF0000*Math.random());
			block.addEventListener(MouseEvent.CLICK, selectedHandler);
			colorList.push(block);
		}
		colorList[0].name = String(0xFFFF32);
		colorList[1].name = String(0xFFFF99);
		        colorList[2].name = String(0xFFFFCD);
		        colorList[3].name = String(0xFFCC32);
		        colorList[4].name = String(0xFFCC00);
		for(i=0; i<_colTotal; i++) {
			colorList[i].graphics.clear();
			colorList[i].graphics.beginFill(Number(colorList[i].name));
			colorList[i].graphics.drawRect(0,0,10,10);
			colorList[i].graphics.endFill();
		}
		
		currentColor = Number(colorList[0].name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
		
	}
	public function setupDisplay():void {
		addChild(_selectedColor);
		for(var i:int=0; i<_colTotal; i++) {
			addChild(colorList[i]);
			colorList[i].x = i*(colorList[i].width+1);
			colorList[i].y = 20;
		}
	}
	private function selectedHandler(event:MouseEvent):void {
		_selectedColor.graphics.clear();
		currentColor = Number(event.target.name);
		_selectedColor.graphics.beginFill(currentColor);
		_selectedColor.graphics.drawRect(0,0,19,19);
		_selectedColor.graphics.endFill();
	}
}

class DrawPlayer extends Sprite {
	
	public static const DO_ROOT:String = "DoRoot";
	public static const DO_NODE:String = "DoNode";
	public static const DO_CLEAR:String = "DoClear";
	private var _commandList:Array;
	private var _timer:Timer = new Timer(1);
	private var _rootIndex:int = 0;
	private var _nodeIndex:int = 0;
	private var _counter:int = 0;
	private var _watchTarget:int = 0; //0:親, 1:子
	
	//現在の命令
	public var cur_Command:int = 0; //0:親, 1:子
	public var cur_Col:Number;
	public var cur_x:Number;
	public var cur_y:Number;
	
	//timer
	private var _startTime:Number;
	
	public function DrawPlayer() {
		super();
	}
	
	public function setCommandList(list:Array):void {
		_commandList = list;
	}
	
	public function playStart():void {
		_counter = 0;
		_rootIndex = 0;
		_nodeIndex = 0;
		_watchTarget = 0;
		_startTime = getTimer();
		addEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	public function playStop():void {
		removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
	}
	
	private function _commandCheckHandler(event:Event):void {
		_counter = getTimer()-_startTime;
		//まだ終わってなかったら終わる
		if(_rootIndex == _commandList.length) {
			if(hasEventListener(Event.ENTER_FRAME))removeEventListener(Event.ENTER_FRAME, _commandCheckHandler);
			return;
		}
		if(_watchTarget==0) {
			if(_commandList[_rootIndex].time<=_counter) {
				switch(_commandList[_rootIndex].type) {
					case "clear":
						_watchTarget = 0;
						dispatchEvent(new Event(DO_CLEAR));
						_rootIndex++;
						break;
					case "draw":
						cur_Col = _commandList[_rootIndex].col;
						cur_x = _commandList[_rootIndex].fx;
						cur_y = _commandList[_rootIndex].fy;
						dispatchEvent(new Event(DO_ROOT));
						_watchTarget = 1;
						break;
				}
			}
		} else {
			var obj:Object = _commandList[_rootIndex][_nodeIndex];
			//マウス動かなかった時は親にそのまま向ける
			if(!_commandList[_rootIndex].childlist[_nodeIndex]){
				_rootIndex++;
				_nodeIndex=0;
				_watchTarget=0;
				return;
			}
			if(_commandList[_rootIndex].childlist[_nodeIndex].time<=_counter) {
				cur_x = _commandList[_rootIndex].childlist[_nodeIndex].x;
				cur_y = _commandList[_rootIndex].childlist[_nodeIndex].y;
				dispatchEvent(new Event(DO_NODE));
				_nodeIndex++;
				//最後尾到達で親監視に切り替え
				if(_nodeIndex==_commandList[_rootIndex].length-1) {
					//親も最後尾なら終了
					if(_rootIndex==_commandList.length-1) {
						_timer.removeEventListener(TimerEvent.TIMER, _commandCheckHandler);
						_timer.stop();
						return;
					} else {
						_watchTarget = 0;
						_rootIndex++;
					}
				}
			}
			
		}
	}
	
	private function _commandCheck():void{
		
	}
	
}

class DrawRecoder extends Sprite {
	private var _commandList:Array = new Array();
	public function get commandList():Array {
		return _commandList;
	}
	public function DrawRecoder() {
		
	}
	
	public function startLineRec(_id:int,_mx:Number,_my:Number,_col:Number, _time:Number):void {
		_commandList.push({type:"draw", id:_id,fx:_mx, fy:_my, col:_col, time:_time, childlist:new Array()});
	}
	public function addPoint(_mx:Number, _my:Number, _time:Number):void {
		var _currentList:Array = _commandList[_commandList.length-1].childlist;
		_currentList.push({x:_mx, y:_my, time:_time});
	}
	public function addClear(_time:Number):void {
		_commandList.push({type:"clear", time:_time});
	}
	public function endLineRec():void {
		
	}
	
	public function outPut():void {
		var i:int;
		var j:int;
	}
}