/**
 * Copyright beryu ( http://wonderfl.net/user/beryu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/epir
 */

/**
 * 古い映像エフェクト
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    [SWF(backgroundColor="0x000000", frameRate="30")]
    
    public class NoizyImage extends Sprite {
        private var _image:Loader = new Loader();
        private var _stageBmp:Bitmap;
        private var _noiseBmd:BitmapData; // ざらざらエフェクト用
        private var _imgBmd:BitmapData, _imgBmdSrc:BitmapData;
        private var _fadeNum:uint = 0xFF;
        private var _blackBoard:BitmapData;
        private var _darkFilter:BitmapData;
        private var _imgSize:Array;
        
        public function NoizyImage() {
            // init
            _imgSize = [stage.stageWidth, stage.stageHeight];
            _noiseBmd = new BitmapData(_imgSize[0], _imgSize[1], true);
            _imgBmdSrc = new BitmapData(_imgSize[0], _imgSize[1], true);
            _stageBmp = new Bitmap();
            
            // 画像読み込み
            var context:LoaderContext = new LoaderContext(true);
            _image.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoadImage);
            _image.load(new URLRequest('http://farm4.static.flickr.com/3528/3945075114_1c1c472317_o.jpg'), context);
            
            // 黒いレイヤー
            var sprite:Sprite = new Sprite();
            sprite.graphics.beginFill(0x000000);
            sprite.graphics.drawRect(0, 0, _imgSize[0], _imgSize[1]);
            sprite.graphics.endFill();
            _blackBoard = new BitmapData(_imgSize[0], _imgSize[1], true);
            _blackBoard.draw(sprite);
            
            // 減光表現生成
            var circle:Sprite = new Sprite();
            circle.graphics.beginFill(0x000000);
            circle.graphics.drawCircle(_imgSize[0]*0.5, _imgSize[1]*0.5, _imgSize[0]*0.7);
            circle.graphics.endFill();
            var blurFilter:BlurFilter = new BlurFilter(128, 128, BitmapFilterQuality.HIGH);
            circle.filters = [blurFilter];
            var rect:Sprite = new Sprite();
            rect.graphics.beginFill(0x000000);
            rect.graphics.drawRect(0, 0, _imgSize[0], _imgSize[1]);
            rect.graphics.endFill();
            _darkFilter = new BitmapData(_imgSize[0], _imgSize[1]);
            _darkFilter.draw(rect);
            _darkFilter.draw(circle, null, null, BlendMode.ERASE);

            // イベント登録
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onLoadImage(e:Event):void
        {
            // 読み込んだ画像をBitmapDataに描画
            _imgBmd = new BitmapData(_image.width, _image.height, true);
            _imgBmd.draw(_image);
            _imgBmdSrc = _imgBmd.clone();
            
            // stageにadd
            _stageBmp.bitmapData = _imgBmd;
            _stageBmp.visible = false;
            addChild(_stageBmp);
            
            // フェードイン開始
            _fadeNum = 0xFE;
        }
        
        private function onEnterFrame(e:Event):void
        {
            // 砂嵐エフェクトの元になるノイズ作成
            _noiseBmd.noise(int(Math.random() * 1000), 
                    0, 
                    255, 
                    BitmapDataChannel.RED | 
                        BitmapDataChannel.BLUE |
                        BitmapDataChannel.GREEN |
                        BitmapDataChannel.ALPHA,
                    false);
            
            // 画像にノイズを加える
            _imgBmd = _imgBmdSrc.clone();
            _imgBmd.draw(_noiseBmd, null, null, BlendMode.OVERLAY);
            
            // 画像にフェード効果用のレイヤーを乗せる
            if(_fadeNum < 0xFF)
            {
                _imgBmd.merge(_blackBoard, _blackBoard.rect, new Point(0, 0), _fadeNum, _fadeNum, _fadeNum, _fadeNum);
                _fadeNum -= _fadeNum * 0.1;
                _stageBmp.visible = true;
            }
            else if(_fadeNum <= 0)
            {
                // 何もしない
            }
            
            // 減光表現を加える
            _imgBmd.draw(_darkFilter);
            
            // ステージに適用
            _stageBmp.bitmapData = _imgBmd;
        }
    }
}